/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FrameReaderTest
extends InitializedNullHandlingTest {
    private final FrameType frameType;
    private StorageAdapter inputAdapter;
    private Frame frame;
    private FrameReader frameReader;

    public FrameReaderTest(FrameType frameType) {
        this.frameType = frameType;
    }

    @Parameterized.Parameters(name="frameType = {0}")
    public static Iterable<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (FrameType frameType : FrameType.values()) {
            constructors.add(new Object[]{frameType});
        }
        return constructors;
    }

    @Before
    public void setUp() {
        this.inputAdapter = new QueryableIndexStorageAdapter(TestIndex.getNoRollupMMappedTestIndex());
        FrameSequenceBuilder frameSequenceBuilder = FrameSequenceBuilder.fromAdapter(this.inputAdapter).frameType(this.frameType).allocator((MemoryAllocator)HeapMemoryAllocator.unlimited());
        this.frame = (Frame)Iterables.getOnlyElement((Iterable)frameSequenceBuilder.frames().toList());
        this.frameReader = FrameReader.create((RowSignature)frameSequenceBuilder.signature());
    }

    @Test
    public void testSignature() {
        Assert.assertEquals((Object)this.inputAdapter.getRowSignature(), (Object)this.frameReader.signature());
    }

    @Test
    public void testColumnCapabilitiesToColumnType() {
        for (String columnName : this.inputAdapter.getRowSignature().getColumnNames()) {
            Assert.assertEquals((String)columnName, (Object)this.inputAdapter.getRowSignature().getColumnCapabilities(columnName).toColumnType(), (Object)this.frameReader.columnCapabilities(this.frame, columnName).toColumnType());
        }
    }
}

