/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CPUTimeMetricQueryRunnerTest {
    @Test
    public void testCpuTimeMetric() {
        StubServiceEmitter emitter = new StubServiceEmitter("s", "h");
        AtomicLong accumulator = new AtomicLong();
        List<Result> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2000-01-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"x", (Object)"y"))));
        QueryRunner runner = CPUTimeMetricQueryRunner.safeBuild((queryPlus, responseContext) -> Sequences.simple((Iterable)expectedResults), (QueryToolChest)new TimeseriesQueryQueryToolChest(), (ServiceEmitter)emitter, (AtomicLong)accumulator, (boolean)true);
        Sequence results = runner.run(QueryPlus.wrap((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals("2000/2001").build()).withQueryMetrics((QueryToolChest)new TimeseriesQueryQueryToolChest()));
        Assert.assertEquals(expectedResults, (Object)results.toList());
        Assert.assertEquals((long)1L, (long)emitter.getEvents().size());
        Event event = (Event)Iterables.getOnlyElement((Iterable)emitter.getEvents());
        Assert.assertEquals((Object)"metrics", (Object)event.toMap().get((Object)"feed"));
        Assert.assertEquals((Object)"query/cpu/time", (Object)event.toMap().get((Object)"metric"));
        Object value = event.toMap().get((Object)"value");
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.instanceOf(Long.class));
        Assert.assertTrue(((Long)value > 0L ? 1 : 0) != 0);
    }
}

