/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class ReportTimelineMissingSegmentQueryRunnerTest {
    @Test
    public void testRunWithOneSegment() {
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        SegmentDescriptor missingSegment = new SegmentDescriptor(interval, "version", 0);
        ReportTimelineMissingSegmentQueryRunner runner = new ReportTimelineMissingSegmentQueryRunner(missingSegment);
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        runner.run(QueryPlus.wrap((Query)new TestQuery()), (ResponseContext)responseContext);
        Assert.assertNotNull((Object)responseContext.getMissingSegments());
        Assert.assertEquals(Collections.singletonList(missingSegment), (Object)responseContext.getMissingSegments());
    }

    @Test
    public void testRunWithMultipleSegments() {
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        ImmutableList missingSegments = ImmutableList.of((Object)new SegmentDescriptor(interval, "version", 0), (Object)new SegmentDescriptor(interval, "version", 1));
        ReportTimelineMissingSegmentQueryRunner runner = new ReportTimelineMissingSegmentQueryRunner((List)missingSegments);
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        runner.run(QueryPlus.wrap((Query)new TestQuery()), (ResponseContext)responseContext);
        Assert.assertNotNull((Object)responseContext.getMissingSegments());
        Assert.assertEquals((Object)missingSegments, (Object)responseContext.getMissingSegments());
    }

    private static class TestQuery
    extends BaseQuery<Object> {
        private TestQuery() {
            super((DataSource)new TableDataSource("datasource"), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(Collections.emptyList()), false, new HashMap());
        }

        public boolean hasFilters() {
            return false;
        }

        public DimFilter getFilter() {
            return null;
        }

        public String getType() {
            return null;
        }

        public Query<Object> withOverriddenContext(Map<String, Object> contextOverride) {
            return null;
        }

        public Query<Object> withQuerySegmentSpec(QuerySegmentSpec spec) {
            return null;
        }

        public Query<Object> withDataSource(DataSource dataSource) {
            return null;
        }
    }
}

