/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.apache.druid.query.TimewarpOperator;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class TimewarpOperatorTest {
    TimewarpOperator<Result<TimeseriesResultValue>> testOperator = new TimewarpOperator(new Interval((ReadableInstant)DateTimes.of((String)"2014-01-01"), (ReadableInstant)DateTimes.of((String)"2014-01-15")), new Period((Object)"P1W"), DateTimes.of((String)"2014-01-06"));

    @Test
    public void testComputeOffset() {
        DateTime t = DateTimes.of((String)"2014-01-23");
        DateTime tOffset = DateTimes.of((String)"2014-01-09");
        Assert.assertEquals((Object)tOffset, (Object)t.plus(this.testOperator.computeOffset(t.getMillis(), DateTimeZone.UTC)));
        t = DateTimes.of((String)"2014-08-02");
        tOffset = DateTimes.of((String)"2014-01-11");
        Assert.assertEquals((Object)tOffset, (Object)t.plus(this.testOperator.computeOffset(t.getMillis(), DateTimeZone.UTC)));
        t = DateTimes.of((String)"2014-08-02T-07");
        tOffset = DateTimes.of((String)"2014-01-11T-08");
        Assert.assertEquals((Object)tOffset, (Object)t.plus(this.testOperator.computeOffset(t.getMillis(), DateTimes.inferTzFromString((String)"America/Los_Angeles"))));
    }

    @Test
    public void testPostProcess() {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2014-01-09"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(DateTimes.of((String)"2014-01-11"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), (Object)new Result(((Interval)queryPlus.getQuery().getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))));
            }
        }, DateTimes.of((String)"2014-08-02").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-07-31/2014-08-05").aggregators(Collections.singletonList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2014-07-31"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))}), (Object)queryRunner.run(QueryPlus.wrap((Query)query)).toList());
        TimewarpOperator timeBoundaryOperator = new TimewarpOperator(new Interval((ReadableInstant)DateTimes.of((String)"2014-01-01"), (ReadableInstant)DateTimes.of((String)"2014-01-15")), new Period((Object)"P1W"), DateTimes.of((String)"2014-01-06"));
        QueryRunner timeBoundaryRunner = timeBoundaryOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeBoundaryResultValue>>(){

            public Sequence<Result<TimeBoundaryResultValue>> run(QueryPlus<Result<TimeBoundaryResultValue>> queryPlus, ResponseContext responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2014-01-12"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)DateTimes.of((String)"2014-01-12"))))));
            }
        }, DateTimes.of((String)"2014-08-02").getMillis());
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("dummy").build();
        Assert.assertEquals(Collections.singletonList(new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)DateTimes.of((String)"2014-08-02"))))), (Object)timeBoundaryRunner.run(QueryPlus.wrap((Query)timeBoundaryQuery)).toList());
    }

    @Test
    public void testPostProcessWithTimezonesAndDstShift() {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2014-01-09T-08"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(DateTimes.of((String)"2014-01-11T-08"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), (Object)new Result(((Interval)queryPlus.getQuery().getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))));
            }
        }, DateTimes.of((String)"2014-08-02T-07").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-07-31T-07/2014-08-05T-07").granularity((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(Collections.singletonList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2014-07-31T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(DateTimes.of((String)"2014-08-02T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), new Result(DateTimes.of((String)"2014-08-02T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))}), (Object)queryRunner.run(QueryPlus.wrap((Query)query)).toList());
    }

    @Test
    public void testPostProcessWithTimezonesAndNoDstShift() {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2014-01-09T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(DateTimes.of((String)"2014-01-11T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), (Object)new Result(((Interval)queryPlus.getQuery().getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))));
            }
        }, DateTimes.of((String)"2014-08-02T-07").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-07-31T-07/2014-08-05T-07").granularity((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimes.inferTzFromString((String)"America/Phoenix"))).aggregators(Collections.singletonList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2014-07-31T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(DateTimes.of((String)"2014-08-02T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), new Result(DateTimes.of((String)"2014-08-02T-07"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))}), (Object)queryRunner.run(QueryPlus.wrap((Query)query)).toList());
    }

    @Test
    public void testEmptyFutureInterval() {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext responseContext) {
                Query query = queryPlus.getQuery();
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(((Interval)query.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(((Interval)query.getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3)))));
            }
        }, DateTimes.of((String)"2014-08-02").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-08-06/2014-08-08").aggregators(Collections.singletonList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(DateTimes.of((String)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3)))}), (Object)queryRunner.run(QueryPlus.wrap((Query)query)).toList());
    }
}

