/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class UnionDataSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("bar")));
    private final UnionDataSource unionDataSourceWithDuplicates = new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("bar"), (Object)new TableDataSource("foo"), (Object)new TableDataSource("bar")));

    @Test
    public void test_constructor_empty() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("'dataSources' must be non-null and non-empty for 'union'");
        new UnionDataSource(Collections.emptyList());
    }

    @Test
    public void test_getTableNames() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)this.unionDataSource.getTableNames());
    }

    @Test
    public void test_getTableNames_withDuplicates() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)this.unionDataSourceWithDuplicates.getTableNames());
    }

    @Test
    public void test_getChildren() {
        Assert.assertEquals((Object)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("bar")), (Object)this.unionDataSource.getChildren());
    }

    @Test
    public void test_getChildren_withDuplicates() {
        Assert.assertEquals((Object)ImmutableList.of((Object)new TableDataSource("bar"), (Object)new TableDataSource("foo"), (Object)new TableDataSource("bar")), (Object)this.unionDataSourceWithDuplicates.getChildren());
    }

    @Test
    public void test_isCacheable() {
        Assert.assertFalse((boolean)this.unionDataSource.isCacheable(true));
        Assert.assertFalse((boolean)this.unionDataSource.isCacheable(false));
    }

    @Test
    public void test_isGlobal() {
        Assert.assertFalse((boolean)this.unionDataSource.isGlobal());
    }

    @Test
    public void test_isConcrete() {
        Assert.assertTrue((boolean)this.unionDataSource.isConcrete());
    }

    @Test
    public void test_withChildren_empty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected [2] children, got [0]");
        this.unionDataSource.withChildren(Collections.emptyList());
    }

    @Test
    public void test_withChildren_sameNumber() {
        ImmutableList newDataSources = ImmutableList.of((Object)new TableDataSource("baz"), (Object)new TableDataSource("qux"));
        Assert.assertEquals((Object)new UnionDataSource((List)newDataSources), (Object)this.unionDataSource.withChildren((List)newDataSources));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(UnionDataSource.class).usingGetClass().withNonnullFields(new String[]{"dataSources"}).verify();
    }

    @Test
    public void test_serde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        UnionDataSource deserialized = (UnionDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)this.unionDataSource), DataSource.class);
        Assert.assertEquals((Object)this.unionDataSource, (Object)deserialized);
    }
}

