/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongMaxAggregationTest {
    private LongMaxAggregatorFactory longMaxAggFactory;
    private LongMaxAggregatorFactory longMaxVectorAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private VectorColumnSelectorFactory vectorColumnSelectorFactory;
    private TestLongColumnSelector selector;
    private final long[] values = new long[]{0x7FFFFFFFFFFFFFFAL, 0x7FFFFFFFFFFFFFFBL, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFDL};
    private final long[] longValues1 = new long[]{5L, 2L, 4L, 100L, 1L, 5L, -2L, -3L, 0L, 55L};

    public LongMaxAggregationTest() throws Exception {
        String aggSpecJson = "{\"type\": \"longMax\", \"name\": \"billy\", \"fieldName\": \"nilly\"}";
        this.longMaxAggFactory = (LongMaxAggregatorFactory)TestHelper.makeJsonMapper().readValue(aggSpecJson, LongMaxAggregatorFactory.class);
        String vectorAggSpecJson = "{\"type\": \"longMax\", \"name\": \"lng\", \"fieldName\": \"lngFld\"}";
        this.longMaxVectorAggFactory = (LongMaxAggregatorFactory)TestHelper.makeJsonMapper().readValue(vectorAggSpecJson, LongMaxAggregatorFactory.class);
    }

    @Before
    public void setup() {
        NullHandling.initializeForTests();
        this.selector = new TestLongColumnSelector(this.values);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.selector);
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("nilly")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
        VectorValueSelector vectorValueSelector = (VectorValueSelector)EasyMock.createMock(VectorValueSelector.class);
        EasyMock.expect((Object)vectorValueSelector.getLongVector()).andReturn((Object)this.longValues1).anyTimes();
        EasyMock.expect((Object)vectorValueSelector.getNullVector()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{vectorValueSelector});
        this.vectorColumnSelectorFactory = (VectorColumnSelectorFactory)EasyMock.createMock(VectorColumnSelectorFactory.class);
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.getColumnCapabilities("lngFld")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ColumnType.LONG).setDictionaryEncoded(true)).anyTimes();
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.makeValueSelector("lngFld")).andReturn((Object)vectorValueSelector).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.vectorColumnSelectorFactory});
    }

    @Test
    public void testLongMaxAggregator() {
        Aggregator agg = this.longMaxAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        Assert.assertEquals((long)this.values[2], (long)((Long)agg.get()));
        Assert.assertEquals((long)this.values[2], (long)agg.getLong());
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testLongMaxBufferAggregator() {
        BufferAggregator agg = this.longMaxAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[9]);
        agg.init(buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        Assert.assertEquals((long)this.values[2], (long)((Long)agg.get(buffer, 0)));
        Assert.assertEquals((long)this.values[2], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testLongMaxVectorAggregator() {
        Assert.assertTrue((boolean)this.longMaxVectorAggFactory.canVectorize((ColumnInspector)this.vectorColumnSelectorFactory));
        VectorValueSelector vectorValueSelector = this.longMaxVectorAggFactory.vectorSelector(this.vectorColumnSelectorFactory);
        Assert.assertEquals((Object)this.longValues1, (Object)vectorValueSelector.getLongVector());
        VectorAggregator vectorAggregator = this.longMaxVectorAggFactory.factorizeVector(this.vectorColumnSelectorFactory);
        ByteBuffer buf = ByteBuffer.allocate(this.longMaxAggFactory.getMaxIntermediateSizeWithNulls() * 3);
        vectorAggregator.init(buf, 0);
        vectorAggregator.aggregate(buf, 0, 0, 3);
        Assert.assertEquals((long)this.longValues1[0], (long)((Long)vectorAggregator.get(buf, 0)));
        vectorAggregator.aggregate(buf, 8, 0, 3);
        Assert.assertEquals((long)this.longValues1[0], (long)((Long)vectorAggregator.get(buf, 8)));
        vectorAggregator.aggregate(buf, 16, 3, 7);
        Assert.assertEquals((long)this.longValues1[3], (long)((Long)vectorAggregator.get(buf, 16)));
        vectorAggregator.init(buf, 0);
        vectorAggregator.aggregate(buf, 0, 0, 10);
        Assert.assertEquals((long)this.longValues1[3], (long)((Long)vectorAggregator.get(buf, 0)));
    }

    @Test
    public void testCombine() {
        Assert.assertEquals((Object)0x7FFFFFFFFFFFFFFBL, (Object)this.longMaxAggFactory.combine((Object)0x7FFFFFFFFFFFFFF8L, (Object)0x7FFFFFFFFFFFFFFBL));
    }

    @Test
    public void testEqualsAndHashCode() {
        LongMaxAggregatorFactory one = new LongMaxAggregatorFactory("name1", "fieldName1");
        LongMaxAggregatorFactory oneMore = new LongMaxAggregatorFactory("name1", "fieldName1");
        LongMaxAggregatorFactory two = new LongMaxAggregatorFactory("name2", "fieldName2");
        Assert.assertEquals((long)one.hashCode(), (long)oneMore.hashCode());
        Assert.assertTrue((boolean)one.equals((Object)oneMore));
        Assert.assertFalse((boolean)one.equals((Object)two));
    }

    private void aggregate(TestLongColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestLongColumnSelector selector, BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }
}

