/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.NoopInputRowParser;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StringColumnAggregationTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final String singleValue = "singleValue";
    private final String multiValue = "multiValue";
    private final int n = 10;
    private long numRows;
    private double singleValueSum;
    private double multiValueSum;
    private double singleValueMax;
    private double multiValueMax;
    private double singleValueMin;
    private double multiValueMin;
    private List<Segment> segments;
    private AggregationTestHelper aggregationTestHelper;

    @Before
    public void setup() throws Exception {
        ImmutableList dimensions = ImmutableList.of((Object)"singleValue", (Object)"multiValue");
        ArrayList<MapBasedInputRow> inputRows = new ArrayList<MapBasedInputRow>(10);
        for (int i = 1; i <= 10; ++i) {
            String val = String.valueOf((double)i * 1.0);
            inputRows.add(new MapBasedInputRow(DateTime.now((DateTimeZone)DateTimeZone.UTC), (List)dimensions, (Map)ImmutableMap.of((Object)"singleValue", (Object)val, (Object)"multiValue", (Object)Lists.newArrayList((Object[])new String[]{val, null, val}))));
        }
        this.aggregationTestHelper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Collections.emptyList(), new GroupByQueryConfig(), this.tempFolder);
        IncrementalIndex index = AggregationTestHelper.createIncrementalIndex(inputRows.iterator(), (InputRowParser)new NoopInputRowParser(null), new AggregatorFactory[]{new CountAggregatorFactory("count")}, 0L, Granularities.NONE, false, 100, false);
        this.segments = ImmutableList.of((Object)new IncrementalIndexSegment(index, SegmentId.dummy((String)"test")), (Object)this.aggregationTestHelper.persistIncrementalIndex(index, null));
        this.numRows = 20L;
        this.singleValueSum = 110.0;
        this.multiValueSum = 220.0;
        this.singleValueMax = 10.0;
        this.multiValueMax = 10.0;
        this.singleValueMin = 1.0;
        this.multiValueMin = 1.0;
    }

    @After
    public void tearDown() {
        if (this.segments != null) {
            for (Segment seg : this.segments) {
                CloseableUtils.closeAndWrapExceptions((Closeable)seg);
            }
        }
    }

    @Test
    public void testGroupBy() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval("1970/2050").setAggregatorSpecs(new AggregatorFactory[]{new DoubleSumAggregatorFactory("singleDoubleSum", "singleValue"), new DoubleSumAggregatorFactory("multiDoubleSum", "multiValue"), new DoubleMaxAggregatorFactory("singleDoubleMax", "singleValue"), new DoubleMaxAggregatorFactory("multiDoubleMax", "multiValue"), new DoubleMinAggregatorFactory("singleDoubleMin", "singleValue"), new DoubleMinAggregatorFactory("multiDoubleMin", "multiValue"), new FloatSumAggregatorFactory("singleFloatSum", "singleValue"), new FloatSumAggregatorFactory("multiFloatSum", "multiValue"), new FloatMaxAggregatorFactory("singleFloatMax", "singleValue"), new FloatMaxAggregatorFactory("multiFloatMax", "multiValue"), new FloatMinAggregatorFactory("singleFloatMin", "singleValue"), new FloatMinAggregatorFactory("multiFloatMin", "multiValue"), new LongSumAggregatorFactory("singleLongSum", "singleValue"), new LongSumAggregatorFactory("multiLongSum", "multiValue"), new LongMaxAggregatorFactory("singleLongMax", "singleValue"), new LongMaxAggregatorFactory("multiLongMax", "multiValue"), new LongMinAggregatorFactory("singleLongMin", "singleValue"), new LongMinAggregatorFactory("multiLongMin", "multiValue"), new LongSumAggregatorFactory("count", "count")}).build();
        Sequence seq = this.aggregationTestHelper.runQueryOnSegmentsObjs(this.segments, query);
        MapBasedRow result = ((ResultRow)Iterables.getOnlyElement((Iterable)seq.toList())).toMapBasedRow(query);
        Assert.assertEquals((long)this.numRows, (long)result.getMetric("count").longValue());
        Assert.assertEquals((double)this.singleValueSum, (double)result.getMetric("singleDoubleSum").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)this.multiValueSum, (double)result.getMetric("multiDoubleSum").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)this.singleValueMax, (double)result.getMetric("singleDoubleMax").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)this.multiValueMax, (double)result.getMetric("multiDoubleMax").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)this.singleValueMin, (double)result.getMetric("singleDoubleMin").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)this.multiValueMin, (double)result.getMetric("multiDoubleMin").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)this.singleValueSum, (double)result.getMetric("singleFloatSum").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.multiValueSum, (double)result.getMetric("multiFloatSum").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.singleValueMax, (double)result.getMetric("singleFloatMax").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.multiValueMax, (double)result.getMetric("multiFloatMax").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.singleValueMin, (double)result.getMetric("singleFloatMin").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.multiValueMin, (double)result.getMetric("multiFloatMin").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((long)((long)this.singleValueSum), (long)result.getMetric("singleLongSum").longValue());
        Assert.assertEquals((long)((long)this.multiValueSum), (long)result.getMetric("multiLongSum").longValue());
        Assert.assertEquals((long)((long)this.singleValueMax), (long)result.getMetric("singleLongMax").longValue());
        Assert.assertEquals((long)((long)this.multiValueMax), (long)result.getMetric("multiLongMax").longValue());
        Assert.assertEquals((long)((long)this.singleValueMin), (long)result.getMetric("singleLongMin").longValue());
        Assert.assertEquals((long)((long)this.multiValueMin), (long)result.getMetric("multiLongMin").longValue());
    }

    @Test
    public void testTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals("1970/2050").aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("singleDoubleSum", "singleValue"), new DoubleSumAggregatorFactory("multiDoubleSum", "multiValue"), new DoubleMaxAggregatorFactory("singleDoubleMax", "singleValue"), new DoubleMaxAggregatorFactory("multiDoubleMax", "multiValue"), new DoubleMinAggregatorFactory("singleDoubleMin", "singleValue"), new DoubleMinAggregatorFactory("multiDoubleMin", "multiValue"), new FloatSumAggregatorFactory("singleFloatSum", "singleValue"), new FloatSumAggregatorFactory("multiFloatSum", "multiValue"), new FloatMaxAggregatorFactory("singleFloatMax", "singleValue"), new FloatMaxAggregatorFactory("multiFloatMax", "multiValue"), new FloatMinAggregatorFactory("singleFloatMin", "singleValue"), new FloatMinAggregatorFactory("multiFloatMin", "multiValue"), new LongSumAggregatorFactory("singleLongSum", "singleValue"), new LongSumAggregatorFactory("multiLongSum", "multiValue"), new LongMaxAggregatorFactory("singleLongMax", "singleValue"), new LongMaxAggregatorFactory("multiLongMax", "multiValue"), new LongMinAggregatorFactory("singleLongMin", "singleValue"), new LongMinAggregatorFactory("multiLongMin", "multiValue"), new LongSumAggregatorFactory("count", "count")}).build();
        Sequence seq = AggregationTestHelper.createTimeseriesQueryAggregationTestHelper(Collections.emptyList(), this.tempFolder).runQueryOnSegmentsObjs(this.segments, query);
        TimeseriesResultValue result = (TimeseriesResultValue)((Result)Iterables.getOnlyElement((Iterable)seq.toList())).getValue();
        Assert.assertEquals((long)this.numRows, (long)result.getLongMetric("count"));
        Assert.assertEquals((double)this.singleValueSum, (double)result.getDoubleMetric("singleDoubleSum"), (double)1.0E-4);
        Assert.assertEquals((double)this.multiValueSum, (double)result.getDoubleMetric("multiDoubleSum"), (double)1.0E-4);
        Assert.assertEquals((double)this.singleValueMax, (double)result.getDoubleMetric("singleDoubleMax"), (double)1.0E-4);
        Assert.assertEquals((double)this.multiValueMax, (double)result.getDoubleMetric("multiDoubleMax"), (double)1.0E-4);
        Assert.assertEquals((double)this.singleValueMin, (double)result.getDoubleMetric("singleDoubleMin"), (double)1.0E-4);
        Assert.assertEquals((double)this.multiValueMin, (double)result.getDoubleMetric("multiDoubleMin"), (double)1.0E-4);
        Assert.assertEquals((double)this.singleValueSum, (double)result.getFloatMetric("singleFloatSum").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.multiValueSum, (double)result.getFloatMetric("multiFloatSum").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.singleValueMax, (double)result.getFloatMetric("singleFloatMax").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.multiValueMax, (double)result.getFloatMetric("multiFloatMax").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.singleValueMin, (double)result.getFloatMetric("singleFloatMin").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((double)this.multiValueMin, (double)result.getFloatMetric("multiFloatMin").floatValue(), (double)1.0E-4f);
        Assert.assertEquals((long)((long)this.singleValueSum), (long)result.getLongMetric("singleLongSum"));
        Assert.assertEquals((long)((long)this.multiValueSum), (long)result.getLongMetric("multiLongSum"));
        Assert.assertEquals((long)((long)this.singleValueMax), (long)result.getLongMetric("singleLongMax"));
        Assert.assertEquals((long)((long)this.multiValueMax), (long)result.getLongMetric("multiLongMax"));
        Assert.assertEquals((long)((long)this.singleValueMin), (long)result.getLongMetric("singleLongMin"));
        Assert.assertEquals((long)((long)this.multiValueMin), (long)result.getLongMetric("multiLongMin"));
    }
}

