/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongAnyAggregationTest
extends InitializedNullHandlingTest {
    private LongAnyAggregatorFactory longAnyAggFactory;
    private LongAnyAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector valueSelector;
    private TestObjectColumnSelector objectSelector;
    private long[] longs = new long[]{185L, -216L, -128751132L, Long.MIN_VALUE};
    private Long[] objects = new Long[]{1123126751L, 1784247991L, 1854329816L, 1000000000L};

    @Before
    public void setup() {
        this.longAnyAggFactory = new LongAnyAggregatorFactory("billy", "nilly");
        this.combiningAggFactory = (LongAnyAggregatorFactory)this.longAnyAggFactory.getCombiningFactory();
        this.valueSelector = new TestLongColumnSelector(this.longs);
        this.objectSelector = new TestObjectColumnSelector<Long>(this.objects);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testLongAnyAggregator() {
        Aggregator agg = this.longAnyAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Long result = (Long)agg.get();
        Assert.assertEquals((Object)this.longs[0], (Object)result);
        Assert.assertEquals((long)this.longs[0], (long)agg.getLong());
        Assert.assertEquals((double)this.longs[0], (double)agg.getLong(), (double)1.0E-4);
    }

    @Test
    public void testLongAnyBufferAggregator() {
        BufferAggregator agg = this.longAnyAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longAnyAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Long result = (Long)agg.get(buffer, 0);
        Assert.assertEquals((double)this.longs[0], (double)result.longValue(), (double)1.0E-4);
        Assert.assertEquals((long)this.longs[0], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.longs[0], (double)agg.getLong(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        Long l1 = 3L;
        Long l2 = 4L;
        Assert.assertEquals((Object)l1, (Object)this.longAnyAggFactory.combine((Object)l1, (Object)l2));
    }

    @Test
    public void testComparatorWithNulls() {
        Long l1 = 3L;
        Object l2 = null;
        Comparator comparator = this.longAnyAggFactory.getComparator();
        Assert.assertEquals((long)1L, (long)comparator.compare(l1, l2));
        Assert.assertEquals((long)0L, (long)comparator.compare(l1, l1));
        Assert.assertEquals((long)0L, (long)comparator.compare(l2, l2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(l2, l1));
    }

    @Test
    public void testLongAnyCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Long result = (Long)agg.get();
        Assert.assertEquals((double)this.objects[0].longValue(), (double)result.longValue(), (double)1.0E-4);
        Assert.assertEquals((long)this.objects[0], (long)agg.getLong());
        Assert.assertEquals((double)this.objects[0].longValue(), (double)agg.getLong(), (double)1.0E-4);
    }

    @Test
    public void testLongAnyCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longAnyAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Long result = (Long)agg.get(buffer, 0);
        Assert.assertEquals((double)this.objects[0].longValue(), (double)result.longValue(), (double)1.0E-4);
        Assert.assertEquals((long)this.objects[0], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.objects[0].longValue(), (double)agg.getLong(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String longSpecJson = "{\"type\":\"longAny\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        Assert.assertEquals((Object)this.longAnyAggFactory, (Object)mapper.readValue(longSpecJson, AggregatorFactory.class));
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

