/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.query.aggregation.any.StringAnyVectorAggregator;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StringAnyVectorAggregatorTest
extends InitializedNullHandlingTest {
    private static final int MAX_STRING_BYTES = 32;
    private static final int BUFFER_SIZE = 1024;
    private static final int POSITION = 2;
    private static final IndexedInts[] MULTI_VALUE_ROWS = new IndexedInts[]{new ArrayBasedIndexedInts(new int[]{1, 0}), new ArrayBasedIndexedInts(new int[]{1}), new ArrayBasedIndexedInts(), new ArrayBasedIndexedInts(new int[]{2})};
    private static final int[] SINGLE_VALUE_ROWS = new int[]{1, 1, 3, 2};
    private static final String[] DICTIONARY = new String[]{"Zero", "One", "TwoThisStringIsLongerThanThirtyTwoBytes"};
    private ByteBuffer buf;
    @Mock
    private SingleValueDimensionVectorSelector singleValueSelector;
    @Mock
    private MultiValueDimensionVectorSelector multiValueSelector;
    private StringAnyVectorAggregator singleValueTarget;
    private StringAnyVectorAggregator multiValueTarget;

    @Before
    public void setUp() {
        ((MultiValueDimensionVectorSelector)Mockito.doReturn((Object)MULTI_VALUE_ROWS).when((Object)this.multiValueSelector)).getRowVector();
        ((MultiValueDimensionVectorSelector)Mockito.doAnswer(invocation -> DICTIONARY[(Integer)invocation.getArgument(0)]).when((Object)this.multiValueSelector)).lookupName(ArgumentMatchers.anyInt());
        ((SingleValueDimensionVectorSelector)Mockito.doReturn((Object)SINGLE_VALUE_ROWS).when((Object)this.singleValueSelector)).getRowVector();
        ((SingleValueDimensionVectorSelector)Mockito.doAnswer(invocation -> {
            int index = (Integer)invocation.getArgument(0);
            return index >= DICTIONARY.length ? null : DICTIONARY[index];
        }).when((Object)this.singleValueSelector)).lookupName(ArgumentMatchers.anyInt());
        this.initializeRandomBuffer();
        this.singleValueTarget = new StringAnyVectorAggregator(this.singleValueSelector, null, 32);
        this.multiValueTarget = new StringAnyVectorAggregator(null, this.multiValueSelector, 32);
    }

    @Test(expected=IllegalStateException.class)
    public void initWithBothSingleAndMultiValueSelectorShouldThrowException() {
        new StringAnyVectorAggregator(this.singleValueSelector, this.multiValueSelector, 32);
    }

    @Test(expected=IllegalStateException.class)
    public void initWithNeitherSingleNorMultiValueSelectorShouldThrowException() {
        new StringAnyVectorAggregator(null, null, 32);
    }

    @Test
    public void initSingleValueTargetShouldMarkPositionAsNotFound() {
        this.singleValueTarget.init(this.buf, 3);
        Assert.assertEquals((long)-2L, (long)this.buf.getInt(3));
    }

    @Test
    public void initMultiValueTargetShouldMarkPositionAsNotFound() {
        this.multiValueTarget.init(this.buf, 3);
        Assert.assertEquals((long)-2L, (long)this.buf.getInt(3));
    }

    @Test
    public void aggregatePositionNotFoundShouldPutFirstValue() {
        this.singleValueTarget.aggregate(this.buf, 2, 0, 2);
        Assert.assertEquals((Object)DICTIONARY[1], (Object)this.singleValueTarget.get(this.buf, 2));
    }

    @Test
    public void aggregateEmptyShouldPutNull() {
        this.singleValueTarget.aggregate(this.buf, 2, 2, 3);
        Assert.assertNull((Object)this.singleValueTarget.get(this.buf, 2));
    }

    @Test
    public void aggregateMultiValuePositionNotFoundShouldPutFirstValue() {
        this.multiValueTarget.aggregate(this.buf, 2, 0, 2);
        Assert.assertEquals((Object)DICTIONARY[1], (Object)this.multiValueTarget.get(this.buf, 2));
    }

    @Test
    public void aggregateMultiValueEmptyShouldPutNull() {
        this.multiValueTarget.aggregate(this.buf, 2, 2, 3);
        Assert.assertNull((Object)this.multiValueTarget.get(this.buf, 2));
    }

    @Test
    public void aggregateValueLongerThanLimitShouldPutTruncatedValue() {
        this.singleValueTarget.aggregate(this.buf, 2, 3, 4);
        Assert.assertEquals((Object)DICTIONARY[2].substring(0, 32), (Object)this.singleValueTarget.get(this.buf, 2));
    }

    @Test
    public void aggregateBatchNoRowsShouldAggregateAllRows() {
        int[] positions = new int[]{0, 43, 100};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.singleValueTarget.aggregate(this.buf, 3, positions, null, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i] + positionOffset;
            Assert.assertEquals((Object)this.singleValueSelector.lookupName(SINGLE_VALUE_ROWS[i]), (Object)this.singleValueTarget.get(this.buf, position));
        }
    }

    @Test
    public void aggregateBatchWithRowsShouldAggregateAllRows() {
        int[] positions = new int[]{0, 43, 100};
        int positionOffset = 2;
        int[] rows = new int[]{2, 1, 0};
        this.clearBufferForPositions(positionOffset, positions);
        this.multiValueTarget.aggregate(this.buf, 3, positions, rows, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i] + positionOffset;
            int row = rows[i];
            IndexedInts rowIndex = MULTI_VALUE_ROWS[row];
            if (rowIndex.size() == 0) {
                Assert.assertNull((Object)this.multiValueTarget.get(this.buf, position));
                continue;
            }
            Assert.assertEquals((Object)this.multiValueSelector.lookupName(rowIndex.get(0)), (Object)this.multiValueTarget.get(this.buf, position));
        }
    }

    private void initializeRandomBuffer() {
        byte[] randomBuffer = new byte[1024];
        ThreadLocalRandom.current().nextBytes(randomBuffer);
        this.buf = ByteBuffer.wrap(randomBuffer);
        this.clearBufferForPositions(0, 2);
    }

    private void clearBufferForPositions(int offset, int ... positions) {
        for (int position : positions) {
            this.buf.putInt(position + offset, -2);
        }
    }
}

