/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.last.LongLastVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LongLastVectorAggregatorTest
extends InitializedNullHandlingTest {
    private static final double EPSILON = 1.0E-5;
    private static final long[] VALUES = new long[]{7L, 15L, 2L, 150L};
    private static final boolean[] NULLS = new boolean[]{false, false, true, false};
    private long[] times = new long[]{2436L, 6879L, 7888L, 8224L};
    @Mock
    private VectorValueSelector selector;
    @Mock
    private VectorValueSelector timeSelector;
    private ByteBuffer buf;
    private LongLastVectorAggregator target;

    @Before
    public void setup() {
        byte[] randomBytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.buf = ByteBuffer.wrap(randomBytes);
        ((VectorValueSelector)Mockito.doReturn((Object)VALUES).when((Object)this.selector)).getLongVector();
        ((VectorValueSelector)Mockito.doReturn((Object)this.times).when((Object)this.timeSelector)).getLongVector();
        this.target = new LongLastVectorAggregator(this.timeSelector, this.selector);
        this.clearBufferForPositions(0, 0);
    }

    @Test
    public void initValueShouldInitZero() {
        this.target.initValue(this.buf, 0);
        long initVal = this.buf.getLong(0);
        Assert.assertEquals((long)0L, (long)initVal);
    }

    @Test
    public void aggregate() {
        this.target.aggregate(this.buf, 0, 0, VALUES.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)this.times[3], (long)((Long)result.lhs));
        Assert.assertEquals((double)VALUES[3], (double)((Long)result.rhs).longValue(), (double)1.0E-5);
    }

    @Test
    public void aggregateWithNulls() {
        this.mockNullsVector();
        this.target.aggregate(this.buf, 0, 0, VALUES.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)this.times[3], (long)((Long)result.lhs));
        Assert.assertEquals((double)VALUES[3], (double)((Long)result.rhs).longValue(), (double)1.0E-5);
    }

    @Test
    public void aggregateBatchWithoutRows() {
        int[] positions = new int[]{0, 43, 70};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, null, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)this.times[i], (long)((Long)result.lhs));
            Assert.assertEquals((double)VALUES[i], (double)((Long)result.rhs).longValue(), (double)1.0E-5);
        }
    }

    @Test
    public void aggregateBatchWithRows() {
        int[] positions = new int[]{0, 43, 70};
        int[] rows = new int[]{3, 2, 0};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, rows, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)this.times[rows[i]], (long)((Long)result.lhs));
            Assert.assertEquals((double)VALUES[rows[i]], (double)((Long)result.rhs).longValue(), (double)1.0E-5);
        }
    }

    private void clearBufferForPositions(int offset, int ... positions) {
        for (int position : positions) {
            this.target.init(this.buf, offset + position);
        }
    }

    private void mockNullsVector() {
        if (!NullHandling.replaceWithDefault()) {
            ((VectorValueSelector)Mockito.doReturn((Object)NULLS).when((Object)this.selector)).getNullVector();
        }
    }
}

