/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.mean;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorAndSize;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.mean.DoubleMeanAggregator;
import org.apache.druid.query.aggregation.mean.DoubleMeanAggregatorFactory;
import org.apache.druid.query.aggregation.mean.DoubleMeanHolder;
import org.apache.druid.query.aggregation.mean.SimpleTestIndex;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.timeline.SegmentId;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class DoubleMeanAggregationTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final AggregationTestHelper groupByQueryTestHelper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Collections.emptyList(), new GroupByQueryConfig(), this.tempFolder);
    private final AggregationTestHelper timeseriesQueryTestHelper = AggregationTestHelper.createTimeseriesQueryAggregationTestHelper(Collections.emptyList(), this.tempFolder);
    private final List<Segment> segments = ImmutableList.of((Object)new IncrementalIndexSegment(SimpleTestIndex.getIncrementalTestIndex(), SegmentId.dummy((String)"test1")), (Object)new QueryableIndexSegment(SimpleTestIndex.getMMappedTestIndex(), SegmentId.dummy((String)"test2")));
    private final List<Segment> biggerSegments = ImmutableList.of((Object)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), SegmentId.dummy((String)"test1")), (Object)new QueryableIndexSegment(TestIndex.getMMappedTestIndex(), SegmentId.dummy((String)"test2")));

    public Object[] doVectorize() {
        return Lists.newArrayList((Object[])new Boolean[]{true, false}).toArray();
    }

    @Test
    @Parameters(method="doVectorize")
    public void testBufferAggretatorUsingGroupByQuery(boolean doVectorize) throws Exception {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval("1970/2050").setAggregatorSpecs(new AggregatorFactory[]{new DoubleMeanAggregatorFactory("meanOnDouble", "doubleCol"), new DoubleMeanAggregatorFactory("meanOnString", "singleValueDoubleAsStringDim"), new DoubleMeanAggregatorFactory("meanOnMultiValue", "multiValueDoubleAsStringDim")}).setContext((Map)ImmutableMap.of((Object)"vectorize", (Object)doVectorize)).build();
        ObjectMapper jsonMapper = this.groupByQueryTestHelper.getObjectMapper();
        query = (GroupByQuery)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)query), Query.class);
        Sequence seq = this.groupByQueryTestHelper.runQueryOnSegmentsObjs(this.segments, query);
        MapBasedRow result = ((ResultRow)Iterables.getOnlyElement((Iterable)seq.toList())).toMapBasedRow(query);
        Assert.assertEquals((double)6.2, (double)result.getMetric("meanOnDouble").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)6.2, (double)result.getMetric("meanOnString").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)4.1333, (double)result.getMetric("meanOnMultiValue").doubleValue(), (double)1.0E-4);
    }

    @Test
    @Parameters(method="doVectorize")
    public void testVectorAggretatorUsingGroupByQueryOnDoubleColumn(boolean doVectorize) throws Exception {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval("1970/2050").setAggregatorSpecs(new AggregatorFactory[]{new DoubleMeanAggregatorFactory("meanOnDouble", "doubleCol")}).setContext(Collections.singletonMap("vectorize", doVectorize)).build();
        ObjectMapper jsonMapper = this.groupByQueryTestHelper.getObjectMapper();
        query = (GroupByQuery)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)query), Query.class);
        Sequence seq = this.groupByQueryTestHelper.runQueryOnSegmentsObjs(this.segments, query);
        MapBasedRow result = ((ResultRow)Iterables.getOnlyElement((Iterable)seq.toList())).toMapBasedRow(query);
        Assert.assertEquals((double)6.2, (double)result.getMetric("meanOnDouble").doubleValue(), (double)1.0E-4);
    }

    @Test
    @Parameters(method="doVectorize")
    public void testVectorAggretatorUsingGroupByQueryOnDoubleColumnOnBiggerSegments(boolean doVectorize) throws Exception {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("blah").setGranularity(Granularities.ALL).setInterval("1970/2050").setAggregatorSpecs(new AggregatorFactory[]{new DoubleMeanAggregatorFactory("meanOnDouble", TestIndex.COLUMNS[9])}).setContext(Collections.singletonMap("vectorize", doVectorize)).build();
        ObjectMapper jsonMapper = this.groupByQueryTestHelper.getObjectMapper();
        query = (GroupByQuery)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)query), Query.class);
        Sequence seq = this.groupByQueryTestHelper.runQueryOnSegmentsObjs(this.biggerSegments, query);
        MapBasedRow result = ((ResultRow)Iterables.getOnlyElement((Iterable)seq.toList())).toMapBasedRow(query);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((double)39.2307, (double)result.getMetric("meanOnDouble").doubleValue(), (double)1.0E-4);
        } else {
            Assert.assertEquals((double)51.0, (double)result.getMetric("meanOnDouble").doubleValue(), (double)1.0E-4);
        }
    }

    @Test
    @Parameters(method="doVectorize")
    public void testAggretatorUsingTimeseriesQuery(boolean doVectorize) throws Exception {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals("1970/2050").aggregators(new AggregatorFactory[]{new DoubleMeanAggregatorFactory("meanOnDouble", "doubleCol"), new DoubleMeanAggregatorFactory("meanOnString", "singleValueDoubleAsStringDim"), new DoubleMeanAggregatorFactory("meanOnMultiValue", "multiValueDoubleAsStringDim")}).context((Map)ImmutableMap.of((Object)"vectorize", (Object)doVectorize)).build();
        ObjectMapper jsonMapper = this.timeseriesQueryTestHelper.getObjectMapper();
        query = (TimeseriesQuery)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)query), Query.class);
        Sequence seq = this.timeseriesQueryTestHelper.runQueryOnSegmentsObjs(this.segments, query);
        TimeseriesResultValue result = (TimeseriesResultValue)((Result)Iterables.getOnlyElement((Iterable)seq.toList())).getValue();
        Assert.assertEquals((double)6.2, (double)result.getDoubleMetric("meanOnDouble"), (double)1.0E-4);
        Assert.assertEquals((double)6.2, (double)result.getDoubleMetric("meanOnString"), (double)1.0E-4);
        Assert.assertEquals((double)4.1333, (double)result.getDoubleMetric("meanOnMultiValue"), (double)1.0E-4);
    }

    @Test
    public void testAggregateWithSize() {
        Double[] values = new Double[]{3.0, 1.0, 2.0};
        TestObjectColumnSelector<Double> columnValueSelector = new TestObjectColumnSelector<Double>(values);
        ColumnSelectorFactory colSelectorFactory = (ColumnSelectorFactory)EasyMock.mock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)colSelectorFactory.makeColumnValueSelector(EasyMock.anyString())).andReturn(columnValueSelector).anyTimes();
        EasyMock.replay((Object[])new Object[]{colSelectorFactory});
        DoubleMeanAggregatorFactory aggregatorFactory = new DoubleMeanAggregatorFactory("name", "fieldName");
        AggregatorAndSize aggregatorAndSize = aggregatorFactory.factorizeWithSize(colSelectorFactory);
        Assert.assertEquals((long)aggregatorFactory.getMaxIntermediateSize(), (long)aggregatorAndSize.getInitialSizeBytes());
        Assert.assertTrue((boolean)(aggregatorAndSize.getAggregator() instanceof DoubleMeanAggregator));
        Aggregator aggregator = aggregatorAndSize.getAggregator();
        for (int i = 0; i < values.length; ++i) {
            long sizeDelta = aggregator.aggregateWithSize();
            Assert.assertEquals((long)0L, (long)sizeDelta);
            columnValueSelector.increment();
        }
        DoubleMeanHolder meanHolder = (DoubleMeanHolder)aggregator.get();
        Assert.assertEquals((double)2.0, (double)meanHolder.mean(), (double)0.0);
    }
}

