/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.extraction.BucketExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.junit.Assert;
import org.junit.Test;

public class BucketExtractionFnTest {
    private static final double DELTA = 1.0E-7;

    @Test
    public void testApply() {
        BucketExtractionFn extractionFn1 = new BucketExtractionFn(Double.valueOf(100.0), Double.valueOf(0.5));
        Assert.assertEquals((Object)"1200.5", (Object)extractionFn1.apply((Object)"1234.99"));
        Assert.assertEquals((Object)"1200.5", (Object)extractionFn1.apply("1234.99"));
        Assert.assertEquals((Object)"0.5", (Object)extractionFn1.apply("1"));
        Assert.assertEquals((Object)"0.5", (Object)extractionFn1.apply("100"));
        Assert.assertEquals((Object)"500.5", (Object)extractionFn1.apply(501L));
        Assert.assertEquals((Object)"-399.5", (Object)extractionFn1.apply("-325"));
        Assert.assertEquals((Object)"2400.5", (Object)extractionFn1.apply("2.42e3"));
        Assert.assertEquals((Object)"-99.5", (Object)extractionFn1.apply("1.2e-1"));
        Assert.assertEquals(null, (Object)extractionFn1.apply("should be null"));
        Assert.assertEquals(null, (Object)extractionFn1.apply(""));
        BucketExtractionFn extractionFn2 = new BucketExtractionFn(Double.valueOf(3.0), Double.valueOf(2.0));
        Assert.assertEquals((Object)"2", (Object)extractionFn2.apply("2"));
        Assert.assertEquals((Object)"2", (Object)extractionFn2.apply("3"));
        Assert.assertEquals((Object)"2", (Object)extractionFn2.apply("4.22"));
        Assert.assertEquals((Object)"-10", (Object)extractionFn2.apply("-8"));
        Assert.assertEquals((Object)"71", (Object)extractionFn2.apply("7.1e1"));
    }

    @Test
    public void testEqualsAndHashCode() {
        BucketExtractionFn extractionFn1 = new BucketExtractionFn(Double.valueOf(100.0), Double.valueOf(0.5));
        BucketExtractionFn extractionFn2 = new BucketExtractionFn(Double.valueOf(3.0), Double.valueOf(2.0));
        BucketExtractionFn extractionFn3 = new BucketExtractionFn(Double.valueOf(3.0), Double.valueOf(2.0));
        Assert.assertNotEquals((Object)extractionFn1, (Object)extractionFn2);
        Assert.assertNotEquals((long)extractionFn1.hashCode(), (long)extractionFn2.hashCode());
        Assert.assertEquals((Object)extractionFn2, (Object)extractionFn3);
        Assert.assertEquals((long)extractionFn2.hashCode(), (long)extractionFn3.hashCode());
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json1 = "{ \"type\" : \"bucket\", \"size\" : \"2\", \"offset\" : \"0.5\" }";
        BucketExtractionFn extractionFn1 = (BucketExtractionFn)objectMapper.readValue("{ \"type\" : \"bucket\", \"size\" : \"2\", \"offset\" : \"0.5\" }", ExtractionFn.class);
        Assert.assertEquals((double)2.0, (double)extractionFn1.getSize(), (double)1.0E-7);
        Assert.assertEquals((double)0.5, (double)extractionFn1.getOffset(), (double)1.0E-7);
        Assert.assertEquals((Object)extractionFn1, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn1), ExtractionFn.class));
        String json2 = "{ \"type\" : \"bucket\"}";
        BucketExtractionFn extractionFn2 = (BucketExtractionFn)objectMapper.readValue("{ \"type\" : \"bucket\"}", ExtractionFn.class);
        Assert.assertEquals((double)1.0, (double)extractionFn2.getSize(), (double)1.0E-7);
        Assert.assertEquals((double)0.0, (double)extractionFn2.getOffset(), (double)1.0E-7);
        Assert.assertEquals((Object)extractionFn2, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn2), ExtractionFn.class));
    }
}

