/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.FunctionalExtraction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FunctionalExtractionTest {
    private static final Function<String, String> NULL_FN = new Function<String, String>(){

        @Nullable
        public String apply(String input) {
            return null;
        }
    };
    private static final Function<String, String> TURTLE_FN = new Function<String, String>(){

        @Nullable
        public String apply(@Nullable String input) {
            return "turtles";
        }
    };
    private static final Function<String, String> EMPTY_STR_FN = new Function<String, String>(){

        @Nullable
        public String apply(@Nullable String input) {
            return "";
        }
    };
    private static final Function<String, String> IDENTITY_FN = new Function<String, String>(){

        @Nullable
        public String apply(@Nullable String input) {
            return input;
        }
    };
    private static final Function<String, String> ONLY_PRESENT = new Function<String, String>(){

        @Nullable
        public String apply(@Nullable String input) {
            return PRESENT_KEY.equals(input) ? PRESENT_VALUE : null;
        }
    };
    private static String PRESENT_KEY = "present";
    private static String PRESENT_VALUE = "present_value";
    private static String MISSING = "missing";
    private final Function<String, String> fn;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{"null", NULL_FN}, (Object)new Object[]{"turtle", TURTLE_FN}, (Object)new Object[]{"empty", EMPTY_STR_FN}, (Object)new Object[]{"identity", IDENTITY_FN}, (Object)new Object[]{"only_PRESENT", ONLY_PRESENT});
    }

    public FunctionalExtractionTest(String label, Function<String, String> fn) {
        this.fn = fn;
    }

    @Test
    public void testRetainMissing() {
        String in = "NOT PRESENT";
        SimpleFunctionExtraction exFn = new SimpleFunctionExtraction(this.fn, true, null, false);
        String out = (String)this.fn.apply((Object)"NOT PRESENT");
        Assert.assertEquals((Object)(NullHandling.isNullOrEquivalent((String)out) ? "NOT PRESENT" : out), (Object)exFn.apply("NOT PRESENT"));
    }

    @Test
    public void testRetainMissingButFound() {
        String in = PRESENT_KEY;
        SimpleFunctionExtraction exFn = new SimpleFunctionExtraction(this.fn, true, null, false);
        String out = (String)this.fn.apply((Object)in);
        Assert.assertEquals((Object)(NullHandling.isNullOrEquivalent((String)out) ? in : out), (Object)exFn.apply(in));
    }

    @Test
    public void testReplaceMissing() {
        String in = "NOT PRESENT";
        SimpleFunctionExtraction exFn = new SimpleFunctionExtraction(this.fn, false, MISSING, false);
        String out = (String)this.fn.apply((Object)"NOT PRESENT");
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((Object)(NullHandling.isNullOrEquivalent((String)out) ? MISSING : out), (Object)exFn.apply("NOT PRESENT"));
        } else {
            Assert.assertEquals((Object)(out == null ? MISSING : out), (Object)exFn.apply("NOT PRESENT"));
        }
    }

    @Test
    public void testReplaceMissingBlank() {
        String in = "NOT PRESENT";
        SimpleFunctionExtraction exFn = new SimpleFunctionExtraction(this.fn, false, "", false);
        String out = (String)this.fn.apply((Object)"NOT PRESENT");
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((Object)(Strings.isNullOrEmpty((String)out) ? null : out), (Object)exFn.apply("NOT PRESENT"));
        } else {
            Assert.assertEquals((Object)(out == null ? "" : out), (Object)exFn.apply("NOT PRESENT"));
        }
    }

    @Test
    public void testOnlyOneValuePresent() {
        String in = PRESENT_KEY;
        SimpleFunctionExtraction exFn = new SimpleFunctionExtraction(this.fn, false, "", false);
        String out = (String)this.fn.apply((Object)in);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((Object)(Strings.isNullOrEmpty((String)out) ? null : out), (Object)exFn.apply(in));
        } else {
            Assert.assertEquals((Object)(Strings.isNullOrEmpty((String)out) ? "" : out), (Object)exFn.apply(in));
        }
    }

    @Test
    public void testNullInputs() {
        SimpleFunctionExtraction exFn = new SimpleFunctionExtraction(this.fn, true, null, false);
        if (NullHandling.isNullOrEquivalent((String)((String)this.fn.apply(null)))) {
            Assert.assertEquals(null, (Object)exFn.apply(null));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadConfig() {
        SimpleFunctionExtraction exFn = new SimpleFunctionExtraction(this.fn, true, MISSING, false);
    }

    @Test
    public void testUniqueProjections() {
        Assert.assertEquals((Object)ExtractionFn.ExtractionType.MANY_TO_ONE, (Object)new SimpleFunctionExtraction(this.fn, true, null, false).getExtractionType());
        Assert.assertEquals((Object)ExtractionFn.ExtractionType.MANY_TO_ONE, (Object)new SimpleFunctionExtraction(this.fn, true, null, false).getExtractionType());
        Assert.assertEquals((Object)ExtractionFn.ExtractionType.ONE_TO_ONE, (Object)new SimpleFunctionExtraction(this.fn, true, null, true).getExtractionType());
    }

    private static class SimpleFunctionExtraction
    extends FunctionalExtraction {
        public SimpleFunctionExtraction(Function<String, String> extractionFunction, Boolean retainMissingValue, String replaceMissingValueWith, Boolean uniqueProjections) {
            super(extractionFunction, retainMissingValue.booleanValue(), replaceMissingValueWith, uniqueProjections.booleanValue());
        }

        public byte[] getCacheKey() {
            return new byte[0];
        }
    }
}

