/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.StringFormatExtractionFn;
import org.junit.Assert;
import org.junit.Test;

public class StringFormatExtractionFnTest {
    @Test
    public void testApply() {
        StringFormatExtractionFn fn = new StringFormatExtractionFn("[%s]");
        long test = 1000L;
        Assert.assertEquals((Object)"[1000]", (Object)fn.apply(test));
    }

    @Test
    public void testApplyNull1() {
        String test = null;
        Assert.assertEquals((Object)"[null]", (Object)this.format("[%s]", "nullString").apply(test));
        Assert.assertEquals((Object)"[]", (Object)this.format("[%s]", "emptyString").apply(test));
        Assert.assertNull((Object)this.format("[%s]", "returnNull").apply(test));
    }

    @Test
    public void testApplyNull2() {
        String test = null;
        Assert.assertEquals((Object)"null", (Object)this.format("%s", "nullString").apply(test));
        Assert.assertEquals((Object)NullHandling.emptyToNullIfNeeded((String)""), (Object)this.format("%s", "emptyString").apply(test));
        Assert.assertNull((Object)this.format("%s", "returnNull").apply(test));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidOption1() {
        new StringFormatExtractionFn("");
    }

    @Test
    public void testSerde() throws Exception {
        this.validateSerde("{ \"type\" : \"stringFormat\", \"format\" : \"[%s]\" }");
        this.validateSerde("{ \"type\" : \"stringFormat\", \"format\" : \"[%s]\", \"nullHandling\" : \"returnNull\" }");
    }

    @Test(expected=JsonMappingException.class)
    public void testInvalidOption2() throws Exception {
        this.validateSerde("{ \"type\" : \"stringFormat\", \"format\" : \"[%s]\", \"nullHandling\" : \"invalid\" }");
    }

    public StringFormatExtractionFn format(String format, String nullHandling) {
        return new StringFormatExtractionFn(format, StringFormatExtractionFn.NullHandling.forValue((String)nullHandling));
    }

    private void validateSerde(String json) throws IOException {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        StringFormatExtractionFn extractionFn = (StringFormatExtractionFn)objectMapper.readValue(json, ExtractionFn.class);
        Assert.assertEquals((Object)"[%s]", (Object)extractionFn.getFormat());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
    }
}

