/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.ArrayDoubleGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.ArrayNumericGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.data.ComparableList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ArrayDoubleGroupByColumnSelectorStrategyTest {
    protected final List<List<Double>> dictionary = new ArrayList<List<Double>>(){
        {
            this.add(ImmutableList.of((Object)1.0, (Object)2.0));
            this.add(ImmutableList.of((Object)2.0, (Object)3.0));
            this.add(ImmutableList.of((Object)1.0));
        }
    };
    protected final Object2IntOpenHashMap<List<Double>> reverseDictionary = new Object2IntOpenHashMap<List<Double>>(){
        {
            this.put(ImmutableList.of((Object)1.0, (Object)2.0), 0);
            this.put(ImmutableList.of((Object)2.0, (Object)3.0), 1);
            this.put(ImmutableList.of((Object)1.0), 2);
        }
    };
    private final ByteBuffer buffer1 = ByteBuffer.allocate(4);
    private final ByteBuffer buffer2 = ByteBuffer.allocate(4);
    private ArrayNumericGroupByColumnSelectorStrategy strategy;

    @Before
    public void setup() {
        this.reverseDictionary.defaultReturnValue(-1);
        this.strategy = new ArrayDoubleGroupByColumnSelectorStrategy(this.dictionary, this.reverseDictionary);
    }

    @Test
    public void testKeySize() {
        Assert.assertEquals((long)4L, (long)this.strategy.getGroupingKeySize());
    }

    @Test
    public void testWriteKey() {
        this.strategy.writeToKeyBuffer(0, 1, this.buffer1);
        Assert.assertEquals((long)1L, (long)this.buffer1.getInt(0));
    }

    @Test
    public void testBufferComparatorsWithNullAndNonNullStringComprators() {
        this.buffer1.putInt(1);
        this.buffer2.putInt(2);
        Grouper.BufferComparator comparator = this.strategy.bufferComparator(0, null);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.buffer2, this.buffer1, 0, 0) < 0 ? 1 : 0) != 0);
        comparator = this.strategy.bufferComparator(0, StringComparators.LEXICOGRAPHIC);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.buffer2, this.buffer1, 0, 0) < 0 ? 1 : 0) != 0);
        comparator = this.strategy.bufferComparator(0, StringComparators.STRLEN);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.buffer2, this.buffer1, 0, 0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBufferComparator() {
        this.buffer1.putInt(0);
        this.buffer2.putInt(2);
        Grouper.BufferComparator comparator = this.strategy.bufferComparator(0, null);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSanity() {
        ColumnValueSelector columnValueSelector = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
        Mockito.when((Object)columnValueSelector.getObject()).thenReturn((Object)ImmutableList.of((Object)1.0, (Object)2.0));
        Assert.assertEquals((long)0L, (long)this.strategy.computeDictionaryId(columnValueSelector));
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        ResultRow row = ResultRow.create((int)1);
        this.buffer1.putInt(0);
        this.strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, this.buffer1, row, 0);
        Assert.assertEquals((Object)new ComparableList((List)ImmutableList.of((Object)1.0, (Object)2.0)), (Object)row.get(0));
    }

    @Test
    public void testAddingInDictionary() {
        ColumnValueSelector columnValueSelector = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
        Mockito.when((Object)columnValueSelector.getObject()).thenReturn((Object)ImmutableList.of((Object)4.0, (Object)2.0));
        Assert.assertEquals((long)3L, (long)this.strategy.computeDictionaryId(columnValueSelector));
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        ResultRow row = ResultRow.create((int)1);
        this.buffer1.putInt(3);
        this.strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, this.buffer1, row, 0);
        Assert.assertEquals((Object)new ComparableList((List)ImmutableList.of((Object)4.0, (Object)2.0)), (Object)row.get(0));
    }

    @Test
    public void testAddingInDictionaryWithObjects() {
        ColumnValueSelector columnValueSelector = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
        Mockito.when((Object)columnValueSelector.getObject()).thenReturn((Object)new Object[]{4.0, 2.0});
        Assert.assertEquals((long)3L, (long)this.strategy.computeDictionaryId(columnValueSelector));
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        ResultRow row = ResultRow.create((int)1);
        this.buffer1.putInt(3);
        this.strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, this.buffer1, row, 0);
        Assert.assertEquals((Object)new ComparableList((List)ImmutableList.of((Object)4.0, (Object)2.0)), (Object)row.get(0));
    }

    @After
    public void tearDown() {
        this.buffer1.clear();
        this.buffer2.clear();
    }
}

