/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.timeline.LogicalSegment;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class SegmentMetadataQueryQueryToolChestTest {
    @Test
    public void testCacheStrategy() throws Exception {
        SegmentMetadataQuery query = new SegmentMetadataQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2015-01-01/2015-01-02"), null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(false));
        CacheStrategy strategy = new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()).getCacheStrategy(query);
        byte[] expectedKey = new byte[]{4, 9, 1, 10, 0, 0, 0, 3, 0, 2, 4};
        byte[] actualKey = strategy.computeCacheKey((Query)query);
        Assert.assertArrayEquals((byte[])expectedKey, (byte[])actualKey);
        SegmentAnalysis result = new SegmentAnalysis("testSegment", (List)ImmutableList.of((Object)Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")), new LinkedHashMap(ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.name(), true, false, 10881L, Integer.valueOf(1), (Comparable)((Object)"preferred"), (Comparable)((Object)"preferred"), null))), 71982L, 100L, null, null, null, null);
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        SegmentAnalysis fromCacheValue = (SegmentAnalysis)objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        SegmentAnalysis fromCacheResult = (SegmentAnalysis)strategy.pullFromSegmentLevelCache().apply((Object)fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }

    @Test
    public void testMergeAggregators() {
        SegmentAnalysis analysis1 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), (Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2).getAggregators());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new DoubleSumAggregatorFactory("baz", "baz")), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2).getAggregators());
    }

    @Test
    public void testMergeAggregatorsOneNull() {
        SegmentAnalysis analysis1 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2).getAggregators());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2).getAggregators());
    }

    @Test
    public void testMergeAggregatorsAllNull() {
        SegmentAnalysis analysis1 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2).getAggregators());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2).getAggregators());
    }

    @Test
    public void testMergeAggregatorsConflict() {
        SegmentAnalysis analysis1 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleSumAggregatorFactory("bar", "bar")), null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, (Map)ImmutableMap.of((Object)"foo", (Object)new LongSumAggregatorFactory("foo", "foo"), (Object)"bar", (Object)new DoubleMaxAggregatorFactory("bar", "bar"), (Object)"baz", (Object)new LongMaxAggregatorFactory("baz", "baz")), null, null, null);
        HashMap<String, Object> expectedLenient = new HashMap<String, Object>();
        expectedLenient.put("foo", new LongSumAggregatorFactory("foo", "foo"));
        expectedLenient.put("bar", null);
        expectedLenient.put("baz", new LongMaxAggregatorFactory("baz", "baz"));
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2).getAggregators());
        Assert.assertEquals(expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2).getAggregators());
        Assert.assertEquals(expectedLenient, (Object)SegmentMetadataQueryQueryToolChestTest.mergeLenient(SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2), SegmentMetadataQueryQueryToolChestTest.mergeLenient(analysis1, analysis2)).getAggregators());
    }

    @Test
    public void testFilterSegments() {
        SegmentMetadataQueryConfig config = new SegmentMetadataQueryConfig();
        SegmentMetadataQueryQueryToolChest toolChest = new SegmentMetadataQueryQueryToolChest(config);
        List filteredSegments = toolChest.filterSegments(Druids.newSegmentMetadataQueryBuilder().dataSource("foo").merge(true).build(), ImmutableList.of((Object)"2000-01-01/P1D", (Object)"2000-01-04/P1D", (Object)"2000-01-09/P1D", (Object)"2000-01-09/P1D").stream().map(interval -> new LogicalSegment((String)interval){
            final /* synthetic */ String val$interval;
            {
                this.val$interval = string;
            }

            public Interval getInterval() {
                return Intervals.of((String)this.val$interval);
            }

            public Interval getTrueInterval() {
                return Intervals.of((String)this.val$interval);
            }
        }).collect(Collectors.toList()));
        Assert.assertEquals((Object)Period.weeks((int)1), (Object)config.getDefaultHistory());
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2000-01-04/P1D"), (Object)Intervals.of((String)"2000-01-09/P1D"), (Object)Intervals.of((String)"2000-01-09/P1D")), filteredSegments.stream().map(LogicalSegment::getInterval).collect(Collectors.toList()));
    }

    @Test
    public void testMergeRollup() {
        SegmentAnalysis analysis1 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, null, null, null, null);
        SegmentAnalysis analysis2 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(false));
        SegmentAnalysis analysis3 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(false));
        SegmentAnalysis analysis4 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(true));
        SegmentAnalysis analysis5 = new SegmentAnalysis("id", null, new LinkedHashMap(), 0L, 0L, null, null, null, Boolean.valueOf(true));
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis2).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis1, analysis4).isRollup());
        Assert.assertNull((Object)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis2, analysis4).isRollup());
        Assert.assertFalse((boolean)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis2, analysis3).isRollup());
        Assert.assertTrue((boolean)SegmentMetadataQueryQueryToolChestTest.mergeStrict(analysis4, analysis5).isRollup());
    }

    private static SegmentAnalysis mergeStrict(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses(null, (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (boolean)false));
    }

    private static SegmentAnalysis mergeLenient(SegmentAnalysis analysis1, SegmentAnalysis analysis2) {
        return SegmentMetadataQueryQueryToolChest.finalizeAnalysis((SegmentAnalysis)SegmentMetadataQueryQueryToolChest.mergeAnalyses(null, (SegmentAnalysis)analysis1, (SegmentAnalysis)analysis2, (boolean)true));
    }
}

