/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Druids;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NestedDataScanQueryTest
extends InitializedNullHandlingTest {
    private static final Logger LOG = new Logger(NestedDataScanQueryTest.class);
    private static final String NESTED_LONG_FIELD = "long";
    private static final String NESTED_DOUBLE_FIELD = "double";
    private static final String NESTED_MIXED_NUMERIC_FIELD = "mixed_numeric";
    private static final String NESTED_MIXED_FIELD = "mixed";
    private static final String NESTED_SPARSE_LONG_FIELD = "sparse_long";
    private static final String NESTED_SPARSE_DOUBLE_FIELD = "sparse_double";
    private static final String NESTED_SPARSE_MIXED_NUMERIC_FIELD = "sparse_mixed_numeric";
    private static final String NESTED_SPARSE_MIXED_FIELD = "sparse_mixed";
    private final AggregationTestHelper helper;
    private final Closer closer;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    public NestedDataScanQueryTest() {
        NestedDataModule.registerHandlersAndSerde();
        List mods = NestedDataModule.getJacksonModulesList();
        this.helper = AggregationTestHelper.createScanQueryAggregationTestHelper(mods, this.tempFolder);
        this.closer = Closer.create();
    }

    @Test
    public void testIngestAndScanSegments() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x"), new NestedFieldVirtualColumn("nester", "$.x[0]", "x_0"), new NestedFieldVirtualColumn("nester", "$.y.c[1]", "y_c_1")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createDefaultHourlySegments(this.helper, this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)8L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
        NestedDataScanQueryTest.logResults(results);
    }

    @Test
    public void testIngestAndScanSegmentsRollup() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.long", NESTED_LONG_FIELD)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        ImmutableList segs = ImmutableList.builder().addAll(NestedDataTestUtils.createSegments(this.helper, this.tempFolder, this.closer, "numeric-nested-test-data.json", "numeric-nested-test-data-parser.json", "simple-nested-test-data-aggs.json", Granularities.YEAR, true, 1000)).build();
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)segs, scanQuery);
        List results = seq.toList();
        NestedDataScanQueryTest.logResults(results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)6L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
    }

    @Test
    public void testIngestAndScanSegmentsRealtime() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x"), new NestedFieldVirtualColumn("nester", "$.x[0]", "x_0"), new NestedFieldVirtualColumn("nester", "$.y.c[1]", "y_c_1"), new NestedFieldVirtualColumn("nester", "$.", "nester_root")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        ImmutableList realtimeSegs = ImmutableList.of((Object)NestedDataTestUtils.createDefaultHourlyIncrementalIndex());
        List<Segment> segs = NestedDataTestUtils.createDefaultHourlySegments(this.helper, this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)realtimeSegs, scanQuery);
        Sequence seq2 = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List resultsRealtime = seq.toList();
        List resultsSegments = seq2.toList();
        NestedDataScanQueryTest.logResults(resultsSegments);
        NestedDataScanQueryTest.logResults(resultsRealtime);
        Assert.assertEquals((long)1L, (long)resultsRealtime.size());
        Assert.assertEquals((long)resultsRealtime.size(), (long)resultsSegments.size());
        Assert.assertEquals((Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString(), (Object)((ScanResultValue)resultsRealtime.get(0)).getEvents().toString());
    }

    @Test
    public void testIngestAndScanSegmentsRealtimeWithFallback() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).columns(new String[]{"x", "x_0", "y_c_1"}).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "x", ColumnType.LONG, null, Boolean.valueOf(true), "$.x", Boolean.valueOf(false)), new NestedFieldVirtualColumn("nester", "x_0", NestedDataComplexTypeSerde.TYPE, null, Boolean.valueOf(true), "$.x[0]", Boolean.valueOf(false)), new NestedFieldVirtualColumn("nester", "y_c_1", NestedDataComplexTypeSerde.TYPE, null, Boolean.valueOf(true), "$.y.c[1]", Boolean.valueOf(false)), new NestedFieldVirtualColumn("nester", "nester_root", NestedDataComplexTypeSerde.TYPE, null, Boolean.valueOf(true), "$.", Boolean.valueOf(false))}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        ImmutableList realtimeSegs = ImmutableList.of((Object)NestedDataTestUtils.createDefaultHourlyIncrementalIndex());
        List<Segment> segs = NestedDataTestUtils.createDefaultHourlySegments(this.helper, this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)realtimeSegs, scanQuery);
        Sequence seq2 = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List resultsRealtime = seq.toList();
        List resultsSegments = seq2.toList();
        NestedDataScanQueryTest.logResults(resultsSegments);
        NestedDataScanQueryTest.logResults(resultsRealtime);
        Assert.assertEquals((long)1L, (long)resultsRealtime.size());
        Assert.assertEquals((long)resultsRealtime.size(), (long)resultsSegments.size());
        Assert.assertEquals((Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString(), (Object)((ScanResultValue)resultsRealtime.get(0)).getEvents().toString());
    }

    @Test
    public void testIngestAndScanSegmentsTsv() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x"), new NestedFieldVirtualColumn("nester", "$.x[0]", "x_0"), new NestedFieldVirtualColumn("nester", "$.y.c[1]", "y_c_1")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createDefaultHourlySegmentsTsv(this.helper, this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)8L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
        NestedDataScanQueryTest.logResults(results);
    }

    @Test
    public void testIngestWithMergesAndScanSegments() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createSegments(this.helper, this.tempFolder, this.closer, Granularities.HOUR, true, 3);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)8L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
        NestedDataScanQueryTest.logResults(results);
    }

    @Test
    public void testIngestAndScanSegmentsAndFilter() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x")}).filters((DimFilter)new SelectorDimFilter("x", "200", null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createDefaultHourlySegments(this.helper, this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        NestedDataScanQueryTest.logResults(results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)1L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
    }

    @Test
    public void testIngestAndScanSegmentsAndRangeFilter() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x")}).filters((DimFilter)new BoundDimFilter("x", "100", "300", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.LEXICOGRAPHIC)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createDefaultHourlySegments(this.helper, this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        NestedDataScanQueryTest.logResults(results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)4L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
    }

    @Test
    public void testExpectedTypes() throws Exception {
        ColumnSelectorFactory columnSelectorFactory = this.getNumericColumnSelectorFactory(this.makeNestedNumericVirtualColumns());
        ColumnValueSelector longValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_LONG_FIELD);
        Assert.assertNotNull((Object)longValueSelector);
        Assert.assertTrue((boolean)(longValueSelector instanceof LongColumnSelector));
        ColumnValueSelector doubleValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_DOUBLE_FIELD);
        Assert.assertNotNull((Object)doubleValueSelector);
        Assert.assertTrue((boolean)(doubleValueSelector instanceof DoubleColumnSelector));
        ColumnValueSelector mixedNumericValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_MIXED_NUMERIC_FIELD);
        Assert.assertNotNull((Object)mixedNumericValueSelector);
        Assert.assertTrue((boolean)(mixedNumericValueSelector instanceof DimensionDictionarySelector));
        ColumnValueSelector mixedValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_MIXED_FIELD);
        Assert.assertNotNull((Object)mixedValueSelector);
        Assert.assertTrue((boolean)(mixedValueSelector instanceof DimensionDictionarySelector));
        ColumnValueSelector sparseLongValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_SPARSE_LONG_FIELD);
        Assert.assertNotNull((Object)sparseLongValueSelector);
        Assert.assertTrue((boolean)(sparseLongValueSelector instanceof LongColumnSelector));
        ColumnValueSelector sparseDoubleValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_SPARSE_DOUBLE_FIELD);
        Assert.assertNotNull((Object)sparseDoubleValueSelector);
        Assert.assertTrue((boolean)(sparseDoubleValueSelector instanceof DoubleColumnSelector));
        ColumnValueSelector sparseMixedNumericValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_SPARSE_MIXED_NUMERIC_FIELD);
        Assert.assertNotNull((Object)sparseMixedNumericValueSelector);
        Assert.assertTrue((boolean)(sparseMixedNumericValueSelector instanceof DimensionDictionarySelector));
        ColumnValueSelector sparseMixedValueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_SPARSE_MIXED_FIELD);
        Assert.assertNotNull((Object)sparseMixedValueSelector);
        Assert.assertTrue((boolean)(sparseMixedValueSelector instanceof DimensionDictionarySelector));
    }

    @Test
    public void testExpectedTypesVectorSelectors() throws Exception {
        VectorColumnSelectorFactory factory = this.getVectorColumnSelectorFactory(this.makeNestedNumericVirtualColumns());
        VectorValueSelector longValueSelector = factory.makeValueSelector(NESTED_LONG_FIELD);
        Assert.assertNotNull((Object)longValueSelector);
        Assert.assertTrue((boolean)(longValueSelector instanceof BaseLongVectorValueSelector));
        VectorValueSelector doubleValueSelector = factory.makeValueSelector(NESTED_DOUBLE_FIELD);
        Assert.assertNotNull((Object)doubleValueSelector);
        Assert.assertTrue((boolean)(doubleValueSelector instanceof BaseDoubleVectorValueSelector));
        Assert.assertThrows(UOE.class, () -> factory.makeValueSelector(NESTED_MIXED_NUMERIC_FIELD));
        Assert.assertThrows(UOE.class, () -> factory.makeValueSelector(NESTED_MIXED_FIELD));
        SingleValueDimensionVectorSelector longDimensionSelector = factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)NESTED_LONG_FIELD));
        Assert.assertNotNull((Object)longDimensionSelector);
        SingleValueDimensionVectorSelector doubleDimensionSelector = factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)NESTED_DOUBLE_FIELD));
        Assert.assertNotNull((Object)doubleDimensionSelector);
        SingleValueDimensionVectorSelector mixedNumericValueSelector = factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)NESTED_MIXED_NUMERIC_FIELD));
        Assert.assertNotNull((Object)mixedNumericValueSelector);
        SingleValueDimensionVectorSelector mixedValueSelector = factory.makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)NESTED_MIXED_FIELD));
        Assert.assertNotNull((Object)mixedValueSelector);
        VectorObjectSelector longObjectSelector = factory.makeObjectSelector(NESTED_LONG_FIELD);
        Assert.assertNotNull((Object)longObjectSelector);
        VectorObjectSelector doubleObjectSelector = factory.makeObjectSelector(NESTED_DOUBLE_FIELD);
        Assert.assertNotNull((Object)doubleObjectSelector);
        VectorObjectSelector mixedNumericObjectSelector = factory.makeObjectSelector(NESTED_MIXED_NUMERIC_FIELD);
        Assert.assertNotNull((Object)mixedNumericObjectSelector);
        VectorObjectSelector mixedObjectSelector = factory.makeObjectSelector(NESTED_MIXED_FIELD);
        Assert.assertNotNull((Object)mixedObjectSelector);
    }

    private VirtualColumns makeNestedNumericVirtualColumns() {
        List longParts = NestedPathFinder.parseJqPath((String)".long");
        List doubleParts = NestedPathFinder.parseJqPath((String)".double");
        List mixedNumericParts = NestedPathFinder.parseJqPath((String)".mixed_numeric");
        List mixedParts = NestedPathFinder.parseJqPath((String)".mixed");
        List sparseLongParts = NestedPathFinder.parseJqPath((String)".sparse_long");
        List sparseDoubleParts = NestedPathFinder.parseJqPath((String)".sparse_double");
        List sparseMixedNumericParts = NestedPathFinder.parseJqPath((String)".sparse_mixed_numeric");
        List sparseMixedParts = NestedPathFinder.parseJqPath((String)".sparse_mixed");
        NestedFieldVirtualColumn longVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_LONG_FIELD, ColumnType.LONG, longParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn doubleVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_DOUBLE_FIELD, ColumnType.DOUBLE, doubleParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn mixedNumericVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_MIXED_NUMERIC_FIELD, null, mixedNumericParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn mixedVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_MIXED_FIELD, null, mixedParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn sparseLongVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_SPARSE_LONG_FIELD, ColumnType.LONG, sparseLongParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn sparseDoubleVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_SPARSE_DOUBLE_FIELD, ColumnType.DOUBLE, sparseDoubleParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn sparseMixedNumericVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_SPARSE_MIXED_NUMERIC_FIELD, null, sparseMixedNumericParts, Boolean.valueOf(false), null, null);
        NestedFieldVirtualColumn sparseMixedVirtualColumn = new NestedFieldVirtualColumn("nest", NESTED_SPARSE_MIXED_FIELD, null, sparseMixedParts, Boolean.valueOf(false), null, null);
        return VirtualColumns.create((List)ImmutableList.of((Object)longVirtualColumn, (Object)doubleVirtualColumn, (Object)mixedNumericVirtualColumn, (Object)mixedVirtualColumn, (Object)sparseLongVirtualColumn, (Object)sparseDoubleVirtualColumn, (Object)sparseMixedNumericVirtualColumn, (Object)sparseMixedVirtualColumn));
    }

    private ColumnSelectorFactory getNumericColumnSelectorFactory(VirtualColumns virtualColumns) throws Exception {
        List<Segment> segments = NestedDataTestUtils.createSegments(this.helper, this.tempFolder, this.closer, "numeric-nested-test-data.json", "numeric-nested-test-data-parser.json", "simple-nested-test-data-aggs.json", Granularities.DAY, true, 1000);
        Assert.assertEquals((long)1L, (long)segments.size());
        StorageAdapter storageAdapter = segments.get(0).asStorageAdapter();
        Sequence cursorSequence = storageAdapter.makeCursors(null, Intervals.ETERNITY, virtualColumns, Granularities.DAY, false, null);
        Yielder yielder = Yielders.each((Sequence)cursorSequence);
        this.closer.register((Closeable)yielder);
        Cursor cursor = (Cursor)yielder.get();
        return cursor.getColumnSelectorFactory();
    }

    private VectorColumnSelectorFactory getVectorColumnSelectorFactory(VirtualColumns virtualColumns) throws Exception {
        List<Segment> segments = NestedDataTestUtils.createSegments(this.helper, this.tempFolder, this.closer, "numeric-nested-test-data.json", "numeric-nested-test-data-parser.json", "simple-nested-test-data-aggs.json", Granularities.DAY, true, 1000);
        Assert.assertEquals((long)1L, (long)segments.size());
        StorageAdapter storageAdapter = segments.get(0).asStorageAdapter();
        VectorCursor cursor = storageAdapter.makeVectorCursor(null, Intervals.ETERNITY, virtualColumns, false, 512, null);
        return cursor.getColumnSelectorFactory();
    }

    private static void logResults(List<ScanResultValue> results) {
        StringBuilder bob = new StringBuilder();
        for (Object event : (List)results.get(0).getEvents()) {
            bob.append("[").append(event).append("]").append("\n");
        }
        LOG.info("results:\n%s", new Object[]{bob});
    }
}

