/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryLimitRowIterator;
import org.apache.druid.query.scan.ScanQueryTestHelper;
import org.apache.druid.query.scan.ScanResultValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScanQueryLimitRowIteratorTest {
    private static final int NUM_ELEMENTS = 1000;
    private final int batchSize;
    private final int limit;
    private static List<ScanResultValue> singleEventScanResultValues = new ArrayList<ScanResultValue>();
    private static List<ScanResultValue> multiEventScanResultValues = new ArrayList<ScanResultValue>();
    private static final ScanQuery.ResultFormat RESULT_FORMAT = ScanQuery.ResultFormat.RESULT_FORMAT_LIST;

    public ScanQueryLimitRowIteratorTest(int batchSize, int limit) {
        this.batchSize = batchSize;
        this.limit = limit;
    }

    @Parameterized.Parameters(name="{0} {1}")
    public static Iterable<Object[]> constructorFeeder() {
        ImmutableList batchSizes = ImmutableList.of((Object)1, (Object)33);
        ImmutableList limits = ImmutableList.of((Object)3, (Object)10000);
        return QueryRunnerTestHelper.cartesian(new Iterable[]{batchSizes, limits});
    }

    @Before
    public void setup() {
        int i;
        singleEventScanResultValues = new ArrayList<ScanResultValue>();
        multiEventScanResultValues = new ArrayList<ScanResultValue>();
        for (i = 0; i < 1000; ++i) {
            singleEventScanResultValues.add(ScanQueryTestHelper.generateScanResultValue(ThreadLocalRandom.current().nextLong(), RESULT_FORMAT, 1));
        }
        for (i = 0; i < 1000 / this.batchSize; ++i) {
            multiEventScanResultValues.add(ScanQueryTestHelper.generateScanResultValue(ThreadLocalRandom.current().nextLong(), RESULT_FORMAT, this.batchSize));
        }
        multiEventScanResultValues.add(ScanQueryTestHelper.generateScanResultValue(ThreadLocalRandom.current().nextLong(), RESULT_FORMAT, 1000 % this.batchSize));
    }

    @Test
    public void testNonOrderedScan() {
        ScanQuery query = Druids.newScanQueryBuilder().limit((long)this.limit).order(ScanQuery.Order.NONE).dataSource("some datasource").batchSize(this.batchSize).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).resultFormat(RESULT_FORMAT).context((Map)ImmutableMap.of((Object)"scanOutermost", (Object)false)).build();
        QueryPlus queryPlus = QueryPlus.wrap((Query)query);
        ScanQueryLimitRowIterator itr = new ScanQueryLimitRowIterator((queryInput, responseContext) -> Sequences.simple(multiEventScanResultValues), queryPlus, ResponseContext.createEmpty());
        int count = 0;
        int expectedNumRows = Math.min(this.limit, 1000);
        while (itr.hasNext()) {
            ScanResultValue curr = itr.next();
            List<Map<String, Object>> events = ScanQueryTestHelper.getEventsListResultFormat(curr);
            if (events.size() != this.batchSize) {
                if (expectedNumRows - count > this.batchSize) {
                    Assert.fail((String)"Batch size is incorrect");
                } else {
                    Assert.assertEquals((long)(expectedNumRows - count), (long)events.size());
                }
            }
            count += events.size();
        }
        Assert.assertEquals((long)expectedNumRows, (long)count);
    }

    @Test
    public void testBrokerOrderedScan() {
        ScanQuery query = Druids.newScanQueryBuilder().limit((long)this.limit).order(ScanQuery.Order.DESCENDING).dataSource("some datasource").batchSize(this.batchSize).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).resultFormat(RESULT_FORMAT).build();
        QueryPlus queryPlus = QueryPlus.wrap((Query)query);
        ScanQueryLimitRowIterator itr = new ScanQueryLimitRowIterator((queryInput, responseContext) -> Sequences.simple(singleEventScanResultValues), queryPlus, ResponseContext.createEmpty());
        int count = 0;
        int expectedNumRows = Math.min(this.limit, 1000);
        while (itr.hasNext()) {
            ScanResultValue curr = itr.next();
            List<Map<String, Object>> events = ScanQueryTestHelper.getEventsListResultFormat(curr);
            if (events.size() != this.batchSize) {
                if (expectedNumRows - count >= this.batchSize) {
                    Assert.fail((String)"Batch size is incorrect");
                } else {
                    Assert.assertEquals((long)(expectedNumRows - count), (long)events.size());
                }
            }
            count += events.size();
        }
        Assert.assertEquals((long)expectedNumRows, (long)count);
    }

    @Test
    public void testHistoricalOrderedScan() {
        ScanQuery query = Druids.newScanQueryBuilder().limit((long)this.limit).order(ScanQuery.Order.DESCENDING).dataSource("some datasource").batchSize(this.batchSize).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).resultFormat(RESULT_FORMAT).context((Map)ImmutableMap.of((Object)"scanOutermost", (Object)false)).build();
        QueryPlus queryPlus = QueryPlus.wrap((Query)query);
        ScanQueryLimitRowIterator itr = new ScanQueryLimitRowIterator((queryInput, responseContext) -> Sequences.simple(singleEventScanResultValues), queryPlus, ResponseContext.createEmpty());
        int count = 0;
        int expectedNumRows = Math.min(this.limit, 1000);
        while (itr.hasNext()) {
            ScanResultValue curr = itr.next();
            List<Map<String, Object>> events = ScanQueryTestHelper.getEventsListResultFormat(curr);
            Assert.assertEquals((long)1L, (long)events.size());
            count += events.size();
        }
        Assert.assertEquals((long)expectedNumRows, (long)count);
    }
}

