/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Test;

public class ColumnCapabilitiesImplTest {
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String json = this.mapper.writeValueAsString((Object)new ColumnCapabilitiesImpl().setDictionaryEncoded(true).setHasBitmapIndexes(true).setHasMultipleValues(true).setHasSpatialIndexes(true).setType(ColumnType.UNKNOWN_COMPLEX).setHasNulls(true).setFilterable(true));
        Assert.assertFalse((boolean)json.contains("filterable"));
        ColumnCapabilities cc = (ColumnCapabilities)this.mapper.readValue(json, ColumnCapabilitiesImpl.class);
        Assert.assertEquals((Object)ColumnType.UNKNOWN_COMPLEX, (Object)cc.toColumnType());
        Assert.assertTrue((boolean)cc.isDictionaryEncoded().isTrue());
        Assert.assertTrue((boolean)cc.hasSpatialIndexes());
        Assert.assertTrue((boolean)cc.hasMultipleValues().isTrue());
        Assert.assertTrue((boolean)cc.hasBitmapIndexes());
        Assert.assertFalse((boolean)cc.hasNulls().isTrue());
        Assert.assertFalse((boolean)cc.isFilterable());
    }

    @Test
    public void testDeserialization() throws Exception {
        String json = "{\n  \"type\":\"COMPLEX\",\n  \"dictionaryEncoded\":true,\n  \"runLengthEncoded\":true,\n  \"hasSpatialIndexes\":true,\n  \"hasMultipleValues\":true,\n  \"hasBitmapIndexes\":true,\n  \"hasNulls\":true,\n  \"filterable\":true\n}";
        ColumnCapabilities cc = (ColumnCapabilities)this.mapper.readValue(json, ColumnCapabilitiesImpl.class);
        Assert.assertEquals((Object)ColumnType.UNKNOWN_COMPLEX, (Object)cc.toColumnType());
        Assert.assertTrue((boolean)cc.isDictionaryEncoded().isTrue());
        Assert.assertTrue((boolean)cc.hasSpatialIndexes());
        Assert.assertTrue((boolean)cc.hasMultipleValues().isTrue());
        Assert.assertTrue((boolean)cc.hasBitmapIndexes());
        Assert.assertFalse((boolean)cc.hasNulls().isTrue());
        Assert.assertFalse((boolean)cc.isFilterable());
    }
}

