/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class RowSignatureTest {
    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(RowSignature.class).usingGetClass().withCachedHashCode("hashCode", "computeHashCode", (Object)RowSignature.builder().build()).withIgnoredFields(new String[]{"columnPositions"}).verify();
    }

    @Test
    public void test_add_withConflict() {
        RowSignature.Builder builder = RowSignature.builder().add("s", ColumnType.STRING).add("d", ColumnType.DOUBLE).add("d", ColumnType.LONG);
        Assert.assertThrows((String)"Column [d] has conflicting types", IllegalArgumentException.class, () -> ((RowSignature.Builder)builder).build());
    }

    @Test
    public void test_addAll() {
        RowSignature expectedSignature = RowSignature.builder().add("s", ColumnType.STRING).add("d", ColumnType.DOUBLE).add("l", ColumnType.LONG).build();
        RowSignature signature = RowSignature.builder().addAll(RowSignature.builder().add("s", ColumnType.STRING).add("d", ColumnType.DOUBLE).build()).addAll(RowSignature.builder().add("l", ColumnType.LONG).build()).build();
        Assert.assertEquals((Object)expectedSignature, (Object)signature);
    }

    @Test
    public void test_addAll_withOverlap() {
        RowSignature expectedSignature = RowSignature.builder().add("s", ColumnType.STRING).add("d", ColumnType.DOUBLE).add("d", ColumnType.DOUBLE).build();
        RowSignature signature = RowSignature.builder().addAll(RowSignature.builder().add("s", ColumnType.STRING).add("d", ColumnType.DOUBLE).build()).addAll(RowSignature.builder().add("d", ColumnType.DOUBLE).build()).build();
        Assert.assertEquals((Object)ImmutableList.of((Object)"s", (Object)"d", (Object)"d"), (Object)expectedSignature.getColumnNames());
        Assert.assertEquals((Object)expectedSignature, (Object)signature);
    }

    @Test
    public void test_json() throws IOException {
        String signatureString = "[{\"name\":\"s\",\"type\":\"STRING\"},{\"name\":\"d\",\"type\":\"DOUBLE\"},{\"name\":\"f\",\"type\":\"FLOAT\"},{\"name\":\"l\",\"type\":\"LONG\"},{\"name\":\"u\"},{\"name\":\"c\",\"type\":\"COMPLEX\"},{\"name\":\"cf\",\"type\":\"COMPLEX<foo>\"},{\"name\":\"as\",\"type\":\"ARRAY<STRING>\"}]";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        RowSignature signature = (RowSignature)mapper.readValue("[{\"name\":\"s\",\"type\":\"STRING\"},{\"name\":\"d\",\"type\":\"DOUBLE\"},{\"name\":\"f\",\"type\":\"FLOAT\"},{\"name\":\"l\",\"type\":\"LONG\"},{\"name\":\"u\"},{\"name\":\"c\",\"type\":\"COMPLEX\"},{\"name\":\"cf\",\"type\":\"COMPLEX<foo>\"},{\"name\":\"as\",\"type\":\"ARRAY<STRING>\"}]", RowSignature.class);
        Assert.assertEquals((Object)"[{\"name\":\"s\",\"type\":\"STRING\"},{\"name\":\"d\",\"type\":\"DOUBLE\"},{\"name\":\"f\",\"type\":\"FLOAT\"},{\"name\":\"l\",\"type\":\"LONG\"},{\"name\":\"u\"},{\"name\":\"c\",\"type\":\"COMPLEX\"},{\"name\":\"cf\",\"type\":\"COMPLEX<foo>\"},{\"name\":\"as\",\"type\":\"ARRAY<STRING>\"}]", (Object)mapper.writeValueAsString((Object)signature));
        Assert.assertEquals((Object)RowSignature.builder().add("s", ColumnType.STRING).add("d", ColumnType.DOUBLE).add("f", ColumnType.FLOAT).add("l", ColumnType.LONG).add("u", null).add("c", ColumnType.UNKNOWN_COMPLEX).add("cf", ColumnType.ofComplex((String)"foo")).add("as", ColumnType.ofArray((ColumnType)ColumnType.STRING)).build(), (Object)signature);
    }

    @Test
    public void test_json_missingName() {
        String signatureString = "[{\"name\":\"s\",\"type\":\"STRING\"},{\"type\":\"DOUBLE\"}]";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        Assert.assertThrows((String)"Column name must be non-empty", IOException.class, () -> {
            RowSignature cfr_ignored_0 = (RowSignature)mapper.readValue("[{\"name\":\"s\",\"type\":\"STRING\"},{\"type\":\"DOUBLE\"}]", RowSignature.class);
        });
    }
}

