/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.druid.segment.data.ComparableStringArray;
import org.junit.Assert;
import org.junit.Test;

public class ComparableStringArrayTest {
    private final String[] array = new String[]{"a", "b", "c"};
    private final ComparableStringArray comparableStringArray = ComparableStringArray.of((String[])new String[]{"a", "b", "c"});

    @Test
    public void testDelegate() {
        Assert.assertArrayEquals((Object[])this.array, (Object[])this.comparableStringArray.getDelegate());
        Assert.assertEquals((long)0L, (long)ComparableStringArray.of((String[])new String[0]).getDelegate().length);
        Assert.assertEquals((long)0L, (long)ComparableStringArray.of((String[])new String[0]).getDelegate().length);
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)Arrays.hashCode(this.array), (long)this.comparableStringArray.hashCode());
        HashSet<ComparableStringArray> set = new HashSet<ComparableStringArray>();
        set.add(this.comparableStringArray);
        set.add(ComparableStringArray.of((String[])this.array));
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.comparableStringArray.equals((Object)ComparableStringArray.of((String[])this.array)));
        Assert.assertFalse((boolean)this.comparableStringArray.equals((Object)ComparableStringArray.of((String[])new String[]{"a", "b", "C"})));
        Assert.assertFalse((boolean)this.comparableStringArray.equals((Object)ComparableStringArray.EMPTY_ARRAY));
        Assert.assertFalse((boolean)this.comparableStringArray.equals(null));
    }

    @Test
    public void testCompareTo() {
        Assert.assertEquals((long)0L, (long)this.comparableStringArray.compareTo(ComparableStringArray.of((String[])this.array)));
        Assert.assertEquals((long)1L, (long)this.comparableStringArray.compareTo(null));
        Assert.assertEquals((long)1L, (long)this.comparableStringArray.compareTo(ComparableStringArray.of((String[])new String[]{"a", "b"})));
        Assert.assertEquals((long)-1L, (long)this.comparableStringArray.compareTo(ComparableStringArray.of((String[])new String[]{"a", "b", "c", "d"})));
        Assert.assertTrue((this.comparableStringArray.compareTo(ComparableStringArray.of((String[])new String[]{"b"})) < 0 ? 1 : 0) != 0);
        ComparableStringArray nullList = ComparableStringArray.of((String[])new String[]{null, "a"});
        Assert.assertTrue((this.comparableStringArray.compareTo(nullList) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((nullList.compareTo(this.comparableStringArray) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((nullList.compareTo(ComparableStringArray.of((String[])new String[]{null, "a"})) == 0 ? 1 : 0) != 0);
    }
}

