/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedLongsAutoEncodingSerdeTest {
    private static final long[] BITS_PER_VALUE_PARAMETERS = new long[]{1L, 2L, 4L, 7L, 11L, 14L, 18L, 23L, 31L, 39L, 46L, 55L, 62L};
    protected final CompressionFactory.LongEncodingStrategy encodingStrategy = CompressionFactory.LongEncodingStrategy.AUTO;
    protected final CompressionStrategy compressionStrategy;
    protected final ByteOrder order;
    protected final long bitsPerValue;

    @Parameterized.Parameters(name="{0} {1} {2}")
    public static Iterable<Object[]> compressionStrategies() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (long bpv : BITS_PER_VALUE_PARAMETERS) {
            for (CompressionStrategy strategy : CompressionStrategy.values()) {
                data.add(new Object[]{bpv, strategy, ByteOrder.BIG_ENDIAN});
                data.add(new Object[]{bpv, strategy, ByteOrder.LITTLE_ENDIAN});
            }
        }
        return data;
    }

    public CompressedLongsAutoEncodingSerdeTest(long bitsPerValue, CompressionStrategy compressionStrategy, ByteOrder order) {
        this.bitsPerValue = bitsPerValue;
        this.compressionStrategy = compressionStrategy;
        this.order = order;
    }

    @Test
    public void testFidelity() throws Exception {
        int i;
        long bound = 1L << (int)this.bitsPerValue;
        int blockSize = 65536;
        int numBits = 64 - Long.numberOfLeadingZeros(1 << (int)(this.bitsPerValue - 1L));
        double numValuesPerByte = 8.0 / (double)numBits;
        ThreadLocalRandom currRand = ThreadLocalRandom.current();
        int numRows = (int)((double)blockSize * numValuesPerByte) * 2 + currRand.nextInt(1, 101);
        long[] chunk = new long[numRows];
        for (i = 0; i < numRows; ++i) {
            chunk[i] = currRand.nextLong(bound);
        }
        this.testValues(chunk);
        chunk = new long[++numRows];
        for (i = 0; i < numRows; ++i) {
            chunk[i] = currRand.nextLong(bound);
        }
        this.testValues(chunk);
    }

    public void testValues(long[] values) throws Exception {
        ColumnarLongsSerializer serializer = CompressionFactory.getLongSerializer((String)"test", (SegmentWriteOutMedium)new OffHeapMemorySegmentWriteOutMedium(), (String)"test", (ByteOrder)this.order, (CompressionFactory.LongEncodingStrategy)this.encodingStrategy, (CompressionStrategy)this.compressionStrategy);
        serializer.open();
        for (long value : values) {
            serializer.add(value);
        }
        Assert.assertEquals((long)values.length, (long)serializer.size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.writeTo(Channels.newChannel(baos), null);
        Assert.assertEquals((long)baos.size(), (long)serializer.getSerializedSize());
        CompressedColumnarLongsSupplier supplier = CompressedColumnarLongsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(baos.toByteArray()), (ByteOrder)this.order);
        ColumnarLongs longs = supplier.get();
        this.assertIndexMatchesVals(longs, values);
        longs.close();
    }

    private void assertIndexMatchesVals(ColumnarLongs indexed, long[] vals) {
        Assert.assertEquals((long)vals.length, (long)indexed.size());
        for (int i = 0; i < indexed.size(); ++i) {
            Assert.assertEquals((String)StringUtils.format((String)"Value [%d] at row '%d' does not match [%d]", (Object[])new Object[]{indexed.get(i), i, vals[i]}), (long)vals[i], (long)indexed.get(i));
        }
    }
}

