/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCreator;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexTest
extends InitializedNullHandlingTest {
    public final IncrementalIndexCreator indexCreator;
    private final boolean isPreserveExistingMetrics;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final CloserRule closer = new CloserRule(false);
    private static final AggregatorFactory[] DEFAULT_AGGREGATOR_FACTORIES = new AggregatorFactory[]{new CountAggregatorFactory("count")};
    private static final AggregatorFactory[] DEFAULT_COMBINING_AGGREGATOR_FACTORIES = new AggregatorFactory[]{DEFAULT_AGGREGATOR_FACTORIES[0].getCombiningFactory()};

    public IncrementalIndexTest(String indexType, String mode, boolean isPreserveExistingMetrics) throws JsonProcessingException {
        this.isPreserveExistingMetrics = isPreserveExistingMetrics;
        this.indexCreator = this.closer.closeLater(new IncrementalIndexCreator(indexType, (builder, args) -> builder.setSimpleTestingIndexSchema(Boolean.valueOf("rollup".equals(mode)), Boolean.valueOf(isPreserveExistingMetrics), (AggregatorFactory[])args[0]).setMaxRowCount(1000000).build()));
    }

    @Parameterized.Parameters(name="{index}: {0}, {1}, {2}")
    public static Collection<?> constructorFeeder() {
        return IncrementalIndexCreator.indexTypeCartesianProduct(new Collection[]{ImmutableList.of((Object)"rollup", (Object)"plain"), ImmutableList.of((Object)true, (Object)false)});
    }

    public static AggregatorFactory[] getDefaultCombiningAggregatorFactories() {
        return DEFAULT_COMBINING_AGGREGATOR_FACTORIES;
    }

    public static IncrementalIndex createIndex(AggregatorFactory[] aggregatorFactories, DimensionsSpec dimensionsSpec) {
        if (null == aggregatorFactories) {
            aggregatorFactories = DEFAULT_AGGREGATOR_FACTORIES;
        }
        return new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(dimensionsSpec).withMetrics(aggregatorFactories).build()).setMaxRowCount(1000000).build();
    }

    public static IncrementalIndex createIndex(AggregatorFactory[] aggregatorFactories) {
        if (null == aggregatorFactories) {
            aggregatorFactories = DEFAULT_AGGREGATOR_FACTORIES;
        }
        return new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(aggregatorFactories).setMaxRowCount(1000000).build();
    }

    public static IncrementalIndex createNoRollupIndex(AggregatorFactory[] aggregatorFactories) {
        if (null == aggregatorFactories) {
            aggregatorFactories = DEFAULT_AGGREGATOR_FACTORIES;
        }
        return new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(Boolean.valueOf(false), Boolean.valueOf(false), aggregatorFactories).setMaxRowCount(1000000).build();
    }

    public static void populateIndex(long timestamp, IncrementalIndex index) throws IndexSizeExceededException {
        index.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2")));
        index.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"3", (Object)"dim2", (Object)"4")));
    }

    public static MapBasedInputRow getRow(long timestamp, int rowID, int dimensionCount) {
        ArrayList<String> dimensionList = new ArrayList<String>(dimensionCount);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < dimensionCount; ++i) {
            String dimName = StringUtils.format((String)"Dim_%d", (Object[])new Object[]{i});
            dimensionList.add(dimName);
            builder.put((Object)dimName, (Object)(dimName + rowID));
        }
        return new MapBasedInputRow(timestamp, dimensionList, (Map)builder.build());
    }

    private static MapBasedInputRow getLongRow(long timestamp, int dimensionCount) {
        ArrayList<String> dimensionList = new ArrayList<String>(dimensionCount);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < dimensionCount; ++i) {
            String dimName = StringUtils.format((String)"Dim_%d", (Object[])new Object[]{i});
            dimensionList.add(dimName);
            builder.put((Object)dimName, (Object)1L);
        }
        return new MapBasedInputRow(timestamp, dimensionList, (Map)builder.build());
    }

    @Test
    public void testCaseSensitivity() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex index = this.indexCreator.createIndex(new Object[]{DEFAULT_AGGREGATOR_FACTORIES});
        IncrementalIndexTest.populateIndex(timestamp, index);
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)index.getDimensionNames());
        Assert.assertEquals((long)2L, (long)index.size());
        Iterator rows = index.iterator();
        Row row = (Row)rows.next();
        Assert.assertEquals((long)timestamp, (long)row.getTimestampFromEpoch());
        Assert.assertEquals(Collections.singletonList("1"), (Object)row.getDimension("dim1"));
        Assert.assertEquals(Collections.singletonList("2"), (Object)row.getDimension("dim2"));
        row = (Row)rows.next();
        Assert.assertEquals((long)timestamp, (long)row.getTimestampFromEpoch());
        Assert.assertEquals(Collections.singletonList("3"), (Object)row.getDimension("dim1"));
        Assert.assertEquals(Collections.singletonList("4"), (Object)row.getDimension("dim2"));
    }

    @Test
    public void testFilteredAggregators() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex index = this.indexCreator.createIndex(new Object[]{new AggregatorFactory[]{new CountAggregatorFactory("count"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("count_selector_filtered"), (DimFilter)new SelectorDimFilter("dim2", "2", null)), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("count_bound_filtered"), (DimFilter)new BoundDimFilter("dim2", "2", "3", Boolean.valueOf(false), Boolean.valueOf(true), null, null, StringComparators.NUMERIC)), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("count_multivaldim_filtered"), (DimFilter)new SelectorDimFilter("dim3", "b", null)), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("count_numeric_filtered"), (DimFilter)new SelectorDimFilter("met1", "11", null))}});
        index.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2", "dim3"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2", (Object)"dim3", (Object)Lists.newArrayList((Object[])new String[]{"b", "a"}), (Object)"met1", (Object)10)));
        index.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2", "dim3"), (Map)ImmutableMap.of((Object)"dim1", (Object)"3", (Object)"dim2", (Object)"4", (Object)"dim3", (Object)Lists.newArrayList((Object[])new String[]{"c", "d"}), (Object)"met1", (Object)11)));
        Assert.assertEquals(Arrays.asList("dim1", "dim2", "dim3"), (Object)index.getDimensionNames());
        Assert.assertEquals(Arrays.asList("count", "count_selector_filtered", "count_bound_filtered", "count_multivaldim_filtered", "count_numeric_filtered"), (Object)index.getMetricNames());
        Assert.assertEquals((long)2L, (long)index.size());
        Iterator rows = index.iterator();
        Row row = (Row)rows.next();
        Assert.assertEquals((long)timestamp, (long)row.getTimestampFromEpoch());
        Assert.assertEquals(Collections.singletonList("1"), (Object)row.getDimension("dim1"));
        Assert.assertEquals(Collections.singletonList("2"), (Object)row.getDimension("dim2"));
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)row.getDimension("dim3"));
        Assert.assertEquals((Object)1L, (Object)row.getMetric("count"));
        Assert.assertEquals((Object)1L, (Object)row.getMetric("count_selector_filtered"));
        Assert.assertEquals((Object)1L, (Object)row.getMetric("count_bound_filtered"));
        Assert.assertEquals((Object)1L, (Object)row.getMetric("count_multivaldim_filtered"));
        Assert.assertEquals((Object)0L, (Object)row.getMetric("count_numeric_filtered"));
        row = (Row)rows.next();
        Assert.assertEquals((long)timestamp, (long)row.getTimestampFromEpoch());
        Assert.assertEquals(Collections.singletonList("3"), (Object)row.getDimension("dim1"));
        Assert.assertEquals(Collections.singletonList("4"), (Object)row.getDimension("dim2"));
        Assert.assertEquals(Arrays.asList("c", "d"), (Object)row.getDimension("dim3"));
        Assert.assertEquals((Object)1L, (Object)row.getMetric("count"));
        Assert.assertEquals((Object)0L, (Object)row.getMetric("count_selector_filtered"));
        Assert.assertEquals((Object)0L, (Object)row.getMetric("count_bound_filtered"));
        Assert.assertEquals((Object)0L, (Object)row.getMetric("count_multivaldim_filtered"));
        Assert.assertEquals((Object)1L, (Object)row.getMetric("count_numeric_filtered"));
    }

    @Test
    public void testSingleThreadedIndexingAndQuery() throws Exception {
        int i;
        int dimensionCount = 5;
        ArrayList<Object> ingestAggregatorFactories = new ArrayList<Object>();
        ingestAggregatorFactories.add(new CountAggregatorFactory("rows"));
        for (int i2 = 0; i2 < 5; ++i2) {
            ingestAggregatorFactories.add(new LongSumAggregatorFactory(StringUtils.format((String)"sumResult%s", (Object[])new Object[]{i2}), StringUtils.format((String)"Dim_%s", (Object[])new Object[]{i2})));
            ingestAggregatorFactories.add(new DoubleSumAggregatorFactory(StringUtils.format((String)"doubleSumResult%s", (Object[])new Object[]{i2}), StringUtils.format((String)"Dim_%s", (Object[])new Object[]{i2})));
        }
        IncrementalIndex index = this.indexCreator.createIndex(new Object[]{ingestAggregatorFactories.toArray(new AggregatorFactory[0])});
        long timestamp = System.currentTimeMillis();
        int rows = 50;
        for (i = 0; i < 50; ++i) {
            index.add((InputRow)IncrementalIndexTest.getLongRow(timestamp + (long)i, 5));
        }
        for (i = 0; i < 50; ++i) {
            index.add((InputRow)IncrementalIndexTest.getLongRow(timestamp + (long)i, 5));
        }
        ArrayList<Object> queryAggregatorFactories = new ArrayList<Object>();
        queryAggregatorFactories.add(new CountAggregatorFactory("rows"));
        for (int i3 = 0; i3 < 5; ++i3) {
            queryAggregatorFactories.add(new LongSumAggregatorFactory(StringUtils.format((String)"sumResult%s", (Object[])new Object[]{i3}), StringUtils.format((String)"sumResult%s", (Object[])new Object[]{i3})));
            queryAggregatorFactories.add(new DoubleSumAggregatorFactory(StringUtils.format((String)"doubleSumResult%s", (Object[])new Object[]{i3}), StringUtils.format((String)"doubleSumResult%s", (Object[])new Object[]{i3})));
        }
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("xxx").granularity(Granularities.ALL).intervals((List)ImmutableList.of((Object)Intervals.of((String)"2000/2030"))).aggregators(queryAggregatorFactories).build();
        IncrementalIndexSegment incrementalIndexSegment = new IncrementalIndexSegment(index, null);
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner((Segment)incrementalIndexSegment), factory.getToolchest());
        List results = runner.run(QueryPlus.wrap((Query)query)).toList();
        Result result = (Result)Iterables.getOnlyElement((Iterable)results);
        boolean isRollup = index.isRollup();
        Assert.assertEquals((long)(50 * (isRollup ? 1 : 2)), (long)((TimeseriesResultValue)result.getValue()).getLongMetric("rows").intValue());
        for (int i4 = 0; i4 < 5; ++i4) {
            Assert.assertEquals((String)("Failed long sum on dimension " + i4), (long)100L, (long)((TimeseriesResultValue)result.getValue()).getLongMetric("sumResult" + i4).intValue());
            Assert.assertEquals((String)("Failed double sum on dimension " + i4), (long)100L, (long)((TimeseriesResultValue)result.getValue()).getDoubleMetric("doubleSumResult" + i4).intValue());
        }
    }

    @Test(timeout=60000L)
    public void testConcurrentAddRead() throws InterruptedException, ExecutionException {
        int dimensionCount = 5;
        ArrayList<Object> ingestAggregatorFactories = new ArrayList<Object>(6);
        ingestAggregatorFactories.add(new CountAggregatorFactory("rows"));
        for (int i = 0; i < 5; ++i) {
            ingestAggregatorFactories.add(new LongSumAggregatorFactory(StringUtils.format((String)"sumResult%s", (Object[])new Object[]{i}), StringUtils.format((String)"Dim_%s", (Object[])new Object[]{i})));
            ingestAggregatorFactories.add(new DoubleSumAggregatorFactory(StringUtils.format((String)"doubleSumResult%s", (Object[])new Object[]{i}), StringUtils.format((String)"Dim_%s", (Object[])new Object[]{i})));
        }
        ArrayList<Object> queryAggregatorFactories = new ArrayList<Object>(6);
        queryAggregatorFactories.add(new CountAggregatorFactory("rows"));
        for (int i = 0; i < 5; ++i) {
            queryAggregatorFactories.add(new LongSumAggregatorFactory(StringUtils.format((String)"sumResult%s", (Object[])new Object[]{i}), StringUtils.format((String)"sumResult%s", (Object[])new Object[]{i})));
            queryAggregatorFactories.add(new DoubleSumAggregatorFactory(StringUtils.format((String)"doubleSumResult%s", (Object[])new Object[]{i}), StringUtils.format((String)"doubleSumResult%s", (Object[])new Object[]{i})));
        }
        final IncrementalIndex index = this.indexCreator.createIndex(new Object[]{ingestAggregatorFactories.toArray(new AggregatorFactory[0])});
        int concurrentThreads = 2;
        int elementsPerThread = 10000;
        ListeningExecutorService indexExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("index-executor-%d").setPriority(1).build()));
        ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("query-executor-%d").build()));
        final long timestamp = System.currentTimeMillis();
        Interval queryInterval = Intervals.of((String)"1900-01-01T00:00:00Z/2900-01-01T00:00:00Z");
        ArrayList indexFutures = Lists.newArrayListWithExpectedSize((int)2);
        ArrayList queryFutures = Lists.newArrayListWithExpectedSize((int)2);
        IncrementalIndexSegment incrementalIndexSegment = new IncrementalIndexSegment(index, null);
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        final AtomicInteger currentlyRunning = new AtomicInteger(0);
        final AtomicInteger concurrentlyRan = new AtomicInteger(0);
        final AtomicInteger someoneRan = new AtomicInteger(0);
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch readyLatch = new CountDownLatch(4);
        AtomicInteger queriesAccumualted = new AtomicInteger(0);
        for (int j = 0; j < 2; ++j) {
            indexFutures.add(indexExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    readyLatch.countDown();
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    currentlyRunning.incrementAndGet();
                    try {
                        for (int i = 0; i < 10000; ++i) {
                            index.add((InputRow)IncrementalIndexTest.getLongRow(timestamp + (long)i, 5));
                            someoneRan.incrementAndGet();
                        }
                    }
                    catch (IndexSizeExceededException e) {
                        throw new RuntimeException(e);
                    }
                    currentlyRunning.decrementAndGet();
                }
            }));
            TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("xxx").granularity(Granularities.ALL).intervals((List)ImmutableList.of((Object)queryInterval)).aggregators(queryAggregatorFactories).build();
            queryFutures.add(queryExecutor.submit(new Runnable((QueryRunnerFactory)factory, (Segment)incrementalIndexSegment, query, currentlyRunning, queriesAccumualted, someoneRan){
                final /* synthetic */ QueryRunnerFactory val$factory;
                final /* synthetic */ Segment val$incrementalIndexSegment;
                final /* synthetic */ TimeseriesQuery val$query;
                final /* synthetic */ AtomicInteger val$currentlyRunning;
                final /* synthetic */ AtomicInteger val$queriesAccumualted;
                final /* synthetic */ AtomicInteger val$someoneRan;
                {
                    this.val$factory = queryRunnerFactory;
                    this.val$incrementalIndexSegment = segment;
                    this.val$query = timeseriesQuery;
                    this.val$currentlyRunning = atomicInteger2;
                    this.val$queriesAccumualted = atomicInteger3;
                    this.val$someoneRan = atomicInteger4;
                }

                @Override
                public void run() {
                    readyLatch.countDown();
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    while (concurrentlyRan.get() == 0) {
                        Double[] results;
                        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.val$factory.createRunner(this.val$incrementalIndexSegment), this.val$factory.getToolchest());
                        Sequence sequence = runner.run(QueryPlus.wrap((Query)this.val$query));
                        for (Double result : results = (Double[])sequence.accumulate((Object)new Double[0], (Accumulator)new Accumulator<Double[], Result<TimeseriesResultValue>>(){

                            public Double[] accumulate(Double[] accumulated, Result<TimeseriesResultValue> in) {
                                if (val$currentlyRunning.get() > 0) {
                                    concurrentlyRan.incrementAndGet();
                                }
                                val$queriesAccumualted.incrementAndGet();
                                return Lists.asList((Object)((TimeseriesResultValue)in.getValue()).getDoubleMetric("doubleSumResult0"), (Object[])accumulated).toArray(new Double[0]);
                            }
                        })) {
                            Integer maxValueExpected = this.val$someoneRan.get() + 2;
                            if (maxValueExpected <= 0) continue;
                            Assert.assertTrue((String)StringUtils.format((String)"%d >= %g >= 0 violated", (Object[])new Object[]{maxValueExpected, result}), (result >= 0.0 && result <= (double)maxValueExpected.intValue() ? 1 : 0) != 0);
                        }
                    }
                }
            }));
        }
        readyLatch.await();
        startLatch.countDown();
        ArrayList allFutures = new ArrayList(queryFutures.size() + indexFutures.size());
        allFutures.addAll(queryFutures);
        allFutures.addAll(indexFutures);
        Futures.allAsList(allFutures).get();
        Assert.assertTrue((String)"Queries ran too fast", (queriesAccumualted.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Did not hit concurrency, please try again", (concurrentlyRan.get() > 0 ? 1 : 0) != 0);
        queryExecutor.shutdown();
        indexExecutor.shutdown();
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner((Segment)incrementalIndexSegment), factory.getToolchest());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("xxx").granularity(Granularities.ALL).intervals((List)ImmutableList.of((Object)queryInterval)).aggregators(queryAggregatorFactories).build();
        List results = runner.run(QueryPlus.wrap((Query)query)).toList();
        boolean isRollup = index.isRollup();
        for (Result result : results) {
            Assert.assertEquals((long)(10000 * (isRollup ? 1 : 2)), (long)((TimeseriesResultValue)result.getValue()).getLongMetric("rows").intValue());
            for (int i = 0; i < 5; ++i) {
                Assert.assertEquals((String)StringUtils.format((String)"Failed long sum on dimension %d", (Object[])new Object[]{i}), (long)20000L, (long)((TimeseriesResultValue)result.getValue()).getLongMetric(StringUtils.format((String)"sumResult%s", (Object[])new Object[]{i})).intValue());
                Assert.assertEquals((String)StringUtils.format((String)"Failed double sum on dimension %d", (Object[])new Object[]{i}), (long)20000L, (long)((TimeseriesResultValue)result.getValue()).getDoubleMetric(StringUtils.format((String)"doubleSumResult%s", (Object[])new Object[]{i})).intValue());
            }
        }
    }

    @Test
    public void testConcurrentAdd() throws Exception {
        final IncrementalIndex index = this.indexCreator.createIndex(new Object[]{DEFAULT_AGGREGATOR_FACTORIES});
        int threadCount = 10;
        int elementsPerThread = 200;
        int dimensionCount = 5;
        ExecutorService executor = Executors.newFixedThreadPool(10);
        final long timestamp = System.currentTimeMillis();
        final CountDownLatch latch = new CountDownLatch(10);
        for (int j = 0; j < 10; ++j) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 200; ++i) {
                            index.add((InputRow)IncrementalIndexTest.getRow(timestamp + (long)i, i, 5));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    latch.countDown();
                }
            });
        }
        Assert.assertTrue((boolean)latch.await(60L, TimeUnit.SECONDS));
        boolean isRollup = index.isRollup();
        Assert.assertEquals((long)5L, (long)index.getDimensionNames().size());
        Assert.assertEquals((long)(200 * (isRollup ? 1 : 10)), (long)index.size());
        Iterator iterator = index.iterator();
        int curr = 0;
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Assert.assertEquals((long)(timestamp + (long)(isRollup ? curr : curr / 10)), (long)row.getTimestampFromEpoch());
            Assert.assertEquals((long)(isRollup ? 10L : 1L), (long)row.getMetric("count").intValue());
            ++curr;
        }
        Assert.assertEquals((long)(200 * (isRollup ? 1 : 10)), (long)curr);
    }

    @Test
    public void testgetDimensions() {
        IncrementalIndex incrementalIndex = this.indexCreator.createIndex((builder, args) -> builder.setIndexSchema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withDimensionsSpec(new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("dim0", "dim1")))).build()).setMaxRowCount(1000000).build(), new Object[0]);
        Assert.assertEquals(Arrays.asList("dim0", "dim1"), (Object)incrementalIndex.getDimensionNames());
    }

    @Test
    public void testDynamicSchemaRollup() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex((builder, args) -> builder.setSimpleTestingIndexSchema(new AggregatorFactory[0]).setMaxRowCount(10).build(), new Object[0]);
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host")));
        index.add((InputRow)new MapBasedInputRow(1481871670000L, Arrays.asList("name", "table"), (Map)ImmutableMap.of((Object)"name", (Object)"name2", (Object)"table", (Object)"table")));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host")));
        Assert.assertEquals((long)2L, (long)index.size());
    }

    @Test
    public void testSchemaRollupWithRowWithExistingMetricsAndWithoutMetric() throws IndexSizeExceededException {
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sum_of_x", "x")};
        IncrementalIndex index = this.indexCreator.createIndex(new Object[]{aggregatorFactories});
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"x", (Object)2)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"x", (Object)3)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"count", (Object)2, (Object)"sum_of_x", (Object)4)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"count", (Object)3, (Object)"sum_of_x", (Object)5)));
        Assert.assertEquals((long)(index.isRollup() ? 1L : 4L), (long)index.size());
        Iterator iterator = index.iterator();
        int rowCount = 0;
        while (iterator.hasNext()) {
            ++rowCount;
            Row row = (Row)iterator.next();
            Assert.assertEquals((long)1481871600000L, (long)row.getTimestampFromEpoch());
            if (index.isRollup()) {
                Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 7L : 4L), (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 14L : 5L), (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            if (rowCount == 1 || rowCount == 2) {
                Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)(1 + rowCount), (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            if (this.isPreserveExistingMetrics) {
                Assert.assertEquals((long)(rowCount - 1), (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)(1 + rowCount), (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
            Assert.assertEquals((Object)(NullHandling.sqlCompatible() ? null : Long.valueOf(0L)), (Object)row.getMetric("sum_of_x"));
        }
    }

    @Test
    public void testSchemaRollupWithRowWithExistingMetricsAndWithoutMetricUsingAggregatorWithDifferentReturnType() throws IndexSizeExceededException {
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new CountAggregatorFactory("count"), new FloatSumAggregatorFactory("sum_of_x", "x")};
        IncrementalIndex index = this.indexCreator.createIndex(new Object[]{aggregatorFactories});
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"x", (Object)2)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"x", (Object)3)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"count", (Object)2, (Object)"sum_of_x", (Object)4)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"count", (Object)3, (Object)"sum_of_x", (Object)5)));
        Assert.assertEquals((long)(index.isRollup() ? 1L : 4L), (long)index.size());
        Iterator iterator = index.iterator();
        int rowCount = 0;
        while (iterator.hasNext()) {
            ++rowCount;
            Row row = (Row)iterator.next();
            Assert.assertEquals((long)1481871600000L, (long)row.getTimestampFromEpoch());
            if (index.isRollup()) {
                Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 7L : 4L), (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 14L : 5L), (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            if (rowCount == 1 || rowCount == 2) {
                Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)(1 + rowCount), (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            if (this.isPreserveExistingMetrics) {
                Assert.assertEquals((long)(rowCount - 1), (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)(1 + rowCount), (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
            Assert.assertEquals((Object)(NullHandling.sqlCompatible() ? null : Float.valueOf(0.0f)), (Object)row.getMetric("sum_of_x"));
        }
    }

    @Test
    public void testSchemaRollupWithRowWithOnlyExistingMetrics() throws IndexSizeExceededException {
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sum_of_x", "x")};
        IncrementalIndex index = this.indexCreator.createIndex(new Object[]{aggregatorFactories});
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"count", (Object)2, (Object)"sum_of_x", (Object)4)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"count", (Object)3, (Object)"x", (Object)3, (Object)"sum_of_x", (Object)5)));
        Assert.assertEquals((long)(index.isRollup() ? 1L : 2L), (long)index.size());
        Iterator iterator = index.iterator();
        int rowCount = 0;
        while (iterator.hasNext()) {
            ++rowCount;
            Row row = (Row)iterator.next();
            Assert.assertEquals((long)1481871600000L, (long)row.getTimestampFromEpoch());
            if (index.isRollup()) {
                Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 5L : 2L), (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 9L : 3L), (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            if (rowCount == 1) {
                if (this.isPreserveExistingMetrics) {
                    Assert.assertEquals((long)2L, (long)row.getMetric("count").intValue());
                    Assert.assertEquals((long)4L, (long)row.getMetric("sum_of_x").intValue());
                    continue;
                }
                Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
                Assert.assertEquals((Object)(NullHandling.sqlCompatible() ? null : Long.valueOf(0L)), (Object)row.getMetric("sum_of_x"));
                continue;
            }
            Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 3L : 1L), (long)row.getMetric("count").intValue());
            Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 5L : 3L), (long)row.getMetric("sum_of_x").intValue());
        }
    }

    @Test
    public void testSchemaRollupWithRowsWithNoMetrics() throws IndexSizeExceededException {
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sum_of_x", "x")};
        IncrementalIndex index = this.indexCreator.createIndex(new Object[]{aggregatorFactories});
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"x", (Object)4)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"x", (Object)3)));
        Assert.assertEquals((long)(index.isRollup() ? 1L : 2L), (long)index.size());
        Iterator iterator = index.iterator();
        int rowCount = 0;
        while (iterator.hasNext()) {
            ++rowCount;
            Row row = (Row)iterator.next();
            Assert.assertEquals((long)1481871600000L, (long)row.getTimestampFromEpoch());
            if (index.isRollup()) {
                Assert.assertEquals((long)2L, (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)7L, (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            if (rowCount == 1) {
                Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)4L, (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
            Assert.assertEquals((long)3L, (long)row.getMetric("sum_of_x").intValue());
        }
    }

    @Test
    public void testSchemaRollupWithRowWithMixedTypeMetrics() throws IndexSizeExceededException {
        if (this.isPreserveExistingMetrics) {
            this.expectedException.expect(ParseException.class);
        }
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sum_of_x", "x")};
        IncrementalIndex index = this.indexCreator.createIndex(new Object[]{aggregatorFactories});
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"count", (Object)"not a number 1", (Object)"sum_of_x", (Object)4)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"host", (Object)"host", (Object)"count", (Object)3, (Object)"x", (Object)3, (Object)"sum_of_x", (Object)"not a number 2")));
        Assert.assertEquals((long)(index.isRollup() ? 1L : 2L), (long)index.size());
        Iterator iterator = index.iterator();
        int rowCount = 0;
        while (iterator.hasNext()) {
            ++rowCount;
            Row row = (Row)iterator.next();
            Assert.assertEquals((long)1481871600000L, (long)row.getTimestampFromEpoch());
            if (index.isRollup()) {
                Assert.assertEquals((long)2L, (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)3L, (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            if (rowCount == 1) {
                Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
                Assert.assertEquals((Object)(NullHandling.sqlCompatible() ? null : Long.valueOf(0L)), (Object)row.getMetric("sum_of_x"));
                continue;
            }
            Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
            Assert.assertEquals((long)3L, (long)row.getMetric("sum_of_x").intValue());
        }
    }

    @Test
    public void testSchemaRollupWithRowsWithNonRolledUpSameColumnName() throws IndexSizeExceededException {
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sum_of_x", "x")};
        IncrementalIndex index = this.indexCreator.createIndex(new Object[]{aggregatorFactories});
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"sum_of_x", (Object)100, (Object)"x", (Object)4)));
        index.add((InputRow)new MapBasedInputRow(1481871600000L, Arrays.asList("name", "host"), (Map)ImmutableMap.of((Object)"name", (Object)"name1", (Object)"sum_of_x", (Object)100, (Object)"x", (Object)3)));
        Assert.assertEquals((long)(index.isRollup() ? 1L : 2L), (long)index.size());
        Iterator iterator = index.iterator();
        int rowCount = 0;
        while (iterator.hasNext()) {
            ++rowCount;
            Row row = (Row)iterator.next();
            Assert.assertEquals((long)1481871600000L, (long)row.getTimestampFromEpoch());
            if (index.isRollup()) {
                Assert.assertEquals((long)2L, (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 200L : 7L), (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            if (rowCount == 1) {
                Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
                Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 100L : 4L), (long)row.getMetric("sum_of_x").intValue());
                continue;
            }
            Assert.assertEquals((long)1L, (long)row.getMetric("count").intValue());
            Assert.assertEquals((long)(this.isPreserveExistingMetrics ? 100L : 3L), (long)row.getMetric("sum_of_x").intValue());
        }
    }
}

