/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.extraction.TimeDimExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExtractionDimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.SelectorFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SelectorFilterTest
extends BaseFilterTest {
    public SelectorFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, DEFAULT_ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(SelectorFilterTest.class.getName());
    }

    @Test
    public void testWithTimeExtractionFnNull() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", null, (ExtractionFn)new TimeDimExtractionFn("yyyy-MM-dd", "yyyy-MM", true)), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim0", null, (ExtractionFn)new TimeDimExtractionFn("yyyy-MM-dd", "yyyy-MM", true)), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("timeDim", null, (ExtractionFn)new TimeDimExtractionFn("yyyy-MM-dd", "yyyy-MM", true)), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("timeDim", "2017-07", (ExtractionFn)new TimeDimExtractionFn("yyyy-MM-dd", "yyyy-MM", true)), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("timeDim", "2017-05", (ExtractionFn)new TimeDimExtractionFn("yyyy-MM-dd", "yyyy-MM", true)), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("timeDim", "2020-01", (ExtractionFn)new TimeDimExtractionFn("yyyy-MM-dd", "yyyy-MM", true)), (List<String>)ImmutableList.of((Object)"3", (Object)"5"));
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", null, null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "1", null), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testSingleValueVirtualStringColumnWithoutNulls() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim0", null, null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim0", "", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim0", "1", null), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testListFilteredVirtualColumn() {
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("allow-dim0", "1", null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("allow-dim0", "4", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("allow-dim0", null, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("deny-dim0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("deny-dim0", "4", null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("deny-dim0", null, null), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("allow-dim2", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("allow-dim2", "a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("allow-dim2", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("deny-dim2", "b", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("deny-dim2", "a", null), (List<String>)ImmutableList.of());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("deny-dim2", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5"));
        } else {
            this.assertFilterMatchesSkipVectorize((DimFilter)new SelectorDimFilter("deny-dim2", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"5"));
        }
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", null, null), (List<String>)ImmutableList.of((Object)"0"));
        } else {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", null, null), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "10", null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "2", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "1", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "abdef", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "abc", null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "ab", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testSingleValueVirtualStringColumnWithNulls() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim1", null, null), (List<String>)ImmutableList.of((Object)"0"));
        } else {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim1", null, null), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim1", "", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim1", "10", null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim1", "2", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim1", "1", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim1", "abdef", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim1", "abc", null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("vdim1", "ab", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMultiValueStringColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "", null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "", null), (List<String>)ImmutableList.of((Object)"2"));
        }
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "b", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "c", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "d", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", null, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "", null), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "c", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", null, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "", null), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "c", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testExpressionVirtualColumn() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("expr", "1.1", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("expr", "1.2", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testSelectorWithLookupExtractionFn() {
        ImmutableMap stringMap = ImmutableMap.of((Object)"1", (Object)"HELLO", (Object)"a", (Object)"HELLO", (Object)"abdef", (Object)"HELLO", (Object)"abc", (Object)"UNKNOWN");
        MapLookupExtractor mapExtractor = new MapLookupExtractor((Map)stringMap, false);
        LookupExtractionFn lookupFn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim2", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim3", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "HELLO", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim4", "UNKNOWN", (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        ImmutableMap stringMap2 = ImmutableMap.of((Object)"2", (Object)"5");
        MapLookupExtractor mapExtractor2 = new MapLookupExtractor((Map)stringMap2, false);
        LookupExtractionFn lookupFn2 = new LookupExtractionFn((LookupExtractor)mapExtractor2, true, null, Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn2), (List<String>)ImmutableList.of((Object)"2", (Object)"5"));
        ImmutableMap stringMap3 = ImmutableMap.of((Object)"1", (Object)"");
        MapLookupExtractor mapExtractor3 = new MapLookupExtractor((Map)stringMap3, false);
        LookupExtractionFn lookupFn3 = new LookupExtractionFn((LookupExtractor)mapExtractor3, false, null, Boolean.valueOf(false), Boolean.valueOf(true));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", null, (ExtractionFn)lookupFn3), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", null, (ExtractionFn)lookupFn3), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim0", "", (ExtractionFn)lookupFn3), (List<String>)ImmutableList.of((Object)"1"));
        }
        ImmutableMap stringMap4 = ImmutableMap.of((Object)"9", (Object)"4");
        MapLookupExtractor mapExtractor4 = new MapLookupExtractor((Map)stringMap4, false);
        LookupExtractionFn lookupFn4 = new LookupExtractionFn((LookupExtractor)mapExtractor4, true, null, Boolean.valueOf(false), Boolean.valueOf(true));
        ImmutableMap stringMap5 = ImmutableMap.of((Object)"5", (Object)"44");
        MapLookupExtractor mapExtractor5 = new MapLookupExtractor((Map)stringMap5, false);
        LookupExtractionFn lookupFn5 = new LookupExtractionFn((LookupExtractor)mapExtractor5, true, null, Boolean.valueOf(false), Boolean.valueOf(true));
        ImmutableMap stringMap6 = ImmutableMap.of((Object)"5", (Object)"5");
        MapLookupExtractor mapExtractor6 = new MapLookupExtractor((Map)stringMap6, false);
        LookupExtractionFn lookupFn6 = new LookupExtractionFn((LookupExtractor)mapExtractor6, true, null, Boolean.valueOf(false), Boolean.valueOf(true));
        SelectorDimFilter optFilter1 = new SelectorDimFilter("dim1", "UNKNOWN", (ExtractionFn)lookupFn);
        SelectorDimFilter optFilter2 = new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn2);
        SelectorDimFilter optFilter3 = new SelectorDimFilter("dim0", null, (ExtractionFn)lookupFn3);
        SelectorDimFilter optFilter4 = new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn4);
        SelectorDimFilter optFilter5 = new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn5);
        SelectorDimFilter optFilter6 = new SelectorDimFilter("dim0", "5", (ExtractionFn)lookupFn6);
        InDimFilter optFilter2Optimized = new InDimFilter("dim0", Arrays.asList("2", "5"), null);
        SelectorDimFilter optFilter4Optimized = new SelectorDimFilter("dim0", "5", null);
        SelectorDimFilter optFilter6Optimized = new SelectorDimFilter("dim0", "5", null);
        Assert.assertTrue((boolean)optFilter1.equals((Object)optFilter1.optimize()));
        Assert.assertTrue((boolean)optFilter2Optimized.equals((Object)optFilter2.optimize()));
        Assert.assertTrue((boolean)optFilter3.equals((Object)optFilter3.optimize()));
        Assert.assertTrue((boolean)optFilter4Optimized.equals((Object)optFilter4.optimize()));
        Assert.assertTrue((boolean)optFilter5.equals((Object)optFilter5.optimize()));
        Assert.assertTrue((boolean)optFilter6Optimized.equals((Object)optFilter6.optimize()));
        this.assertFilterMatches((DimFilter)optFilter1, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)optFilter2, (List<String>)ImmutableList.of((Object)"2", (Object)"5"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)optFilter3, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)optFilter3, (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        }
        this.assertFilterMatches((DimFilter)optFilter4, (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)optFilter5, (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)optFilter6, (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new ExtractionDimFilter("dim1", "UNKNOWN", (ExtractionFn)lookupFn, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new ExtractionDimFilter("dim0", "5", (ExtractionFn)lookupFn2, null), (List<String>)ImmutableList.of((Object)"2", (Object)"5"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new ExtractionDimFilter("dim0", null, (ExtractionFn)lookupFn3, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new ExtractionDimFilter("dim0", null, (ExtractionFn)lookupFn3, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ExtractionDimFilter("dim0", "", (ExtractionFn)lookupFn3, null), (List<String>)ImmutableList.of((Object)"1"));
        }
    }

    @Test
    public void testNumericColumnNullsAndDefaults() {
        if (this.canTestNumericNullsAsDefaultValues) {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("f0", "0", null), (List<String>)ImmutableList.of((Object)"0", (Object)"4"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("d0", "0", null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("l0", "0", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("f0", null, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("d0", null, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("l0", null, null), (List<String>)ImmutableList.of());
        } else {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("f0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("d0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("l0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("f0", null, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("d0", null, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("l0", null, null), (List<String>)ImmutableList.of((Object)"3"));
        }
    }

    @Test
    public void testVirtualNumericColumnNullsAndDefaults() {
        if (this.canTestNumericNullsAsDefaultValues) {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vf0", "0", null), (List<String>)ImmutableList.of((Object)"0", (Object)"4"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vd0", "0", null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vl0", "0", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vf0", null, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vd0", null, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vl0", null, null), (List<String>)ImmutableList.of());
        } else {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vf0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vd0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vl0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vf0", null, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vd0", null, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("vl0", null, null), (List<String>)ImmutableList.of((Object)"3"));
        }
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(SelectorFilter.class).usingGetClass().withNonnullFields(new String[]{"dimension"}).verify();
    }
}

