/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JoinableClauseTest {
    public ExpectedException expectedException = ExpectedException.none();
    private Joinable joinable;
    private JoinableClause clause;

    @Before
    public void setUp() throws Exception {
        this.joinable = new IndexedTableJoinable(JoinTestHelper.createCountriesIndexedTable());
        this.clause = new JoinableClause("j.", this.joinable, JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"\"j.x\" == y", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
    }

    @Test
    public void test_getPrefix() {
        Assert.assertEquals((Object)"j.", (Object)this.clause.getPrefix());
    }

    @Test
    public void test_getJoinable() {
        Assert.assertEquals((Object)this.joinable, (Object)this.clause.getJoinable());
    }

    @Test
    public void test_getJoinType() {
        Assert.assertEquals((Object)JoinType.LEFT, (Object)this.clause.getJoinType());
    }

    @Test
    public void test_getCondition() {
        Assert.assertEquals((Object)"\"j.x\" == y", (Object)this.clause.getCondition().getOriginalExpression());
    }

    @Test
    public void test_getAvailableColumnsPrefixed() {
        Assert.assertEquals((Object)ImmutableList.of((Object)"j.countryNumber", (Object)"j.countryIsoCode", (Object)"j.countryName"), (Object)this.clause.getAvailableColumnsPrefixed());
    }

    @Test
    public void test_includesColumn_included() {
        Assert.assertTrue((boolean)this.clause.includesColumn("j.countryNumber"));
    }

    @Test
    public void test_includesColumn_notIncluded() {
        Assert.assertFalse((boolean)this.clause.includesColumn("countryNumber"));
    }

    @Test
    public void test_unprefix_included() {
        Assert.assertEquals((Object)"countryNumber", (Object)this.clause.unprefix("j.countryNumber"));
    }

    @Test
    public void test_unprefix_notIncluded() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.clause.includesColumn("countryNumber");
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(JoinableClause.class).usingGetClass().verify();
    }
}

