/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.segment.join.NoopDataSource;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MapJoinableFactoryTest {
    @Mock
    private InlineDataSource inlineDataSource;
    @Mock(value=MockType.NICE)
    private JoinableFactory noopJoinableFactory;
    private NoopDataSource noopDataSource;
    @Mock
    private JoinConditionAnalysis condition;
    @Mock
    private Joinable mockJoinable;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private MapJoinableFactory target;

    @Before
    public void setUp() {
        this.noopDataSource = new NoopDataSource();
        this.target = new MapJoinableFactory((Set)ImmutableSet.of((Object)this.noopJoinableFactory), (Map)ImmutableMap.of(this.noopJoinableFactory.getClass(), NoopDataSource.class));
    }

    @Test
    public void testBuildDataSourceNotRegisteredShouldReturnAbsent() {
        Optional joinable = this.target.build((DataSource)this.inlineDataSource, this.condition);
        Assert.assertFalse((boolean)joinable.isPresent());
    }

    @Test
    public void testBuildDataSourceIsRegisteredAndFactoryDoesNotBuildJoinableShouldReturnAbsent() {
        EasyMock.expect((Object)this.noopJoinableFactory.build((DataSource)this.noopDataSource, this.condition)).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{this.noopJoinableFactory});
        Optional joinable = this.target.build((DataSource)this.noopDataSource, this.condition);
        Assert.assertFalse((boolean)joinable.isPresent());
    }

    @Test
    public void testBuildDataSourceIsRegisteredShouldReturnJoinableFromFactory() {
        EasyMock.expect((Object)this.noopJoinableFactory.build((DataSource)this.noopDataSource, this.condition)).andReturn(Optional.of(this.mockJoinable));
        EasyMock.replay((Object[])new Object[]{this.noopJoinableFactory});
        Optional joinable = this.target.build((DataSource)this.noopDataSource, this.condition);
        Assert.assertEquals((Object)this.mockJoinable, joinable.get());
    }

    @Test
    public void testComputeJoinCacheKey() {
        Optional<byte[]> expected = Optional.of(new byte[]{1, 2, 3});
        EasyMock.expect((Object)this.noopJoinableFactory.computeJoinCacheKey((DataSource)this.noopDataSource, this.condition)).andReturn(expected);
        EasyMock.replay((Object[])new Object[]{this.noopJoinableFactory});
        Optional actual = this.target.computeJoinCacheKey((DataSource)this.noopDataSource, this.condition);
        Assert.assertSame(expected, (Object)actual);
    }

    @Test
    public void testBuildExceptionWhenTwoJoinableFactoryForSameDataSource() {
        JoinableFactory anotherNoopJoinableFactory = (JoinableFactory)EasyMock.mock(MapJoinableFactory.class);
        this.target = new MapJoinableFactory((Set)ImmutableSet.of((Object)this.noopJoinableFactory, (Object)anotherNoopJoinableFactory), (Map)ImmutableMap.of(this.noopJoinableFactory.getClass(), NoopDataSource.class, anotherNoopJoinableFactory.getClass(), NoopDataSource.class));
        EasyMock.expect((Object)this.noopJoinableFactory.build((DataSource)this.noopDataSource, this.condition)).andReturn(Optional.of(this.mockJoinable));
        EasyMock.expect((Object)anotherNoopJoinableFactory.build((DataSource)this.noopDataSource, this.condition)).andReturn(Optional.of(this.mockJoinable));
        EasyMock.replay((Object[])new Object[]{this.noopJoinableFactory, anotherNoopJoinableFactory});
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Multiple joinable factories are valid for table[%s]", (Object[])new Object[]{this.noopDataSource}));
        this.target.build((DataSource)this.noopDataSource, this.condition);
    }

    @Test
    public void testIsDirectShouldBeFalseForNotRegistered() {
        Assert.assertFalse((boolean)this.target.isDirectlyJoinable((DataSource)this.inlineDataSource));
    }

    @Test
    public void testIsDirectlyJoinableShouldBeTrueForRegisteredThatIsJoinable() {
        EasyMock.expect((Object)this.noopJoinableFactory.isDirectlyJoinable((DataSource)this.noopDataSource)).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.noopJoinableFactory});
        Assert.assertTrue((boolean)this.target.isDirectlyJoinable((DataSource)this.noopDataSource));
    }
}

