/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.LexicographicalRangeIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.NumericRangeIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.nested.NestedDataColumnSerializer;
import org.apache.druid.segment.nested.NestedFieldLiteralColumnIndexSupplier;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.roaringbitmap.IntIterator;

public class NestedFieldLiteralColumnIndexSupplierTest
extends InitializedNullHandlingTest {
    BitmapSerdeFactory roaringFactory = new RoaringBitmapSerdeFactory(null);
    BitmapResultFactory<ImmutableBitmap> bitmapResultFactory = new DefaultBitmapResultFactory(this.roaringFactory.getBitmapFactory());
    GenericIndexed<String> globalStrings;
    FixedIndexed<Long> globalLongs;
    FixedIndexed<Double> globalDoubles;

    @Before
    public void setup() throws IOException {
        ByteBuffer stringBuffer = ByteBuffer.allocate(4096);
        ByteBuffer longBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer doubleBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        GenericIndexedWriter stringWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "strings", GenericIndexed.STRING_STRATEGY);
        stringWriter.open();
        stringWriter.write(null);
        stringWriter.write((Object)"a");
        stringWriter.write((Object)"b");
        stringWriter.write((Object)"fo");
        stringWriter.write((Object)"foo");
        stringWriter.write((Object)"fooo");
        stringWriter.write((Object)"z");
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(stringBuffer, (Serializer)stringWriter);
        FixedIndexedWriter longWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)TypeStrategies.LONG, ByteOrder.nativeOrder(), 8, true);
        longWriter.open();
        longWriter.write((Object)1L);
        longWriter.write((Object)2L);
        longWriter.write((Object)3L);
        longWriter.write((Object)5L);
        longWriter.write((Object)100L);
        longWriter.write((Object)300L);
        longWriter.write((Object)9000L);
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(longBuffer, (Serializer)longWriter);
        FixedIndexedWriter doubleWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)TypeStrategies.DOUBLE, ByteOrder.nativeOrder(), 8, true);
        doubleWriter.open();
        doubleWriter.write((Object)1.0);
        doubleWriter.write((Object)1.1);
        doubleWriter.write((Object)1.2);
        doubleWriter.write((Object)2.0);
        doubleWriter.write((Object)2.5);
        doubleWriter.write((Object)3.3);
        doubleWriter.write((Object)6.6);
        doubleWriter.write((Object)9.9);
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(doubleBuffer, (Serializer)doubleWriter);
        this.globalStrings = GenericIndexed.read((ByteBuffer)stringBuffer, (ObjectStrategy)GenericIndexed.STRING_STRATEGY);
        this.globalLongs = FixedIndexed.read((ByteBuffer)longBuffer, (TypeStrategy)TypeStrategies.LONG, (ByteOrder)ByteOrder.nativeOrder(), (int)8);
        this.globalDoubles = FixedIndexed.read((ByteBuffer)doubleBuffer, (TypeStrategy)TypeStrategies.DOUBLE, (ByteOrder)ByteOrder.nativeOrder(), (int)8);
    }

    @Test
    public void testSingleTypeStringColumnValueSetIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeStringSupplier();
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("b");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.4, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 3, 7, 8);
        columnIndex = valueSetIndex.forValue("fo");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.0, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, new int[0]);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"b", (Object)"fooo", (Object)"z")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.8, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 2, 3, 4, 5, 6, 7, 8);
    }

    @Test
    public void testSingleTypeStringColumnRangeIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeStringSupplier();
        LexicographicalRangeIndex rangeIndex = (LexicographicalRangeIndex)indexSupplier.as(LexicographicalRangeIndex.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange("f", true, "g", true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.4, (double)forRange.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 5, 9);
        forRange = rangeIndex.forRange(null, false, "g", true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.8, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 5, 7, 8, 9);
        forRange = rangeIndex.forRange("f", false, null, true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.6, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
        forRange = rangeIndex.forRange("b", true, "fooo", true);
        Assert.assertEquals((double)0.2, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 9);
        forRange = rangeIndex.forRange("b", true, "fooo", false);
        Assert.assertEquals((double)0.4, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 5, 9);
        forRange = rangeIndex.forRange(null, true, "fooo", true);
        Assert.assertEquals((double)0.6, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 3, 7, 8, 9);
        forRange = rangeIndex.forRange("b", true, null, false);
        Assert.assertEquals((double)0.6, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
        forRange = rangeIndex.forRange("b", false, null, true);
        Assert.assertEquals((double)1.0, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndex.forRange(null, true, "fooo", false);
        Assert.assertEquals((double)0.8, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 5, 7, 8, 9);
        forRange = rangeIndex.forRange(null, true, null, true);
        Assert.assertEquals((double)1.0, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndex.forRange(null, false, null, false);
        Assert.assertEquals((double)1.0, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testSingleTypeStringColumnRangeIndexWithPredicate() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeStringSupplier();
        LexicographicalRangeIndex rangeIndex = (LexicographicalRangeIndex)indexSupplier.as(LexicographicalRangeIndex.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange("f", true, "g", true, s -> !"fooo".equals(s));
        Assert.assertEquals((double)0.2, (double)forRange.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 9);
        forRange = rangeIndex.forRange("f", true, "g", true, s -> "fooo".equals(s));
        Assert.assertEquals((double)0.2, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 5);
        forRange = rangeIndex.forRange(null, false, "z", false, s -> !"fooo".equals(s));
        Assert.assertEquals((double)0.8, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 3, 4, 6, 7, 8, 9);
        forRange = rangeIndex.forRange(null, false, "z", true, s -> !"fooo".equals(s));
        Assert.assertEquals((double)0.6, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 3, 7, 8, 9);
        forRange = rangeIndex.forRange("f", true, null, true, s -> true);
        Assert.assertEquals((double)0.6, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
    }

    @Test
    public void testSingleTypeStringColumnPredicateIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeStringSupplier();
        DruidPredicateIndex predicateIndex = (DruidPredicateIndex)indexSupplier.as(DruidPredicateIndex.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, new InDimFilter.ValuesSet((Collection)ImmutableSet.of((Object)"b", (Object)"z")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.6, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 3, 4, 6, 7, 8);
    }

    @Test
    public void testSingleTypeStringColumnWithNullValueIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeStringWithNullsSupplier();
        NullValueIndex nullIndex = (NullValueIndex)indexSupplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullIndex);
        BitmapColumnIndex columnIndex = nullIndex.forNull();
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.3, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 7, 8);
    }

    @Test
    public void testSingleTypeStringColumnWithNullValueSetIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeStringWithNullsSupplier();
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("b");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.1, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 3);
        columnIndex = valueSetIndex.forValue("fo");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.0, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, new int[0]);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"b", (Object)"fooo", (Object)"z")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.5, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 3, 4, 5, 6);
    }

    @Test
    public void testSingleValueStringWithNullRangeIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeStringWithNullsSupplier();
        LexicographicalRangeIndex rangeIndex = (LexicographicalRangeIndex)indexSupplier.as(LexicographicalRangeIndex.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange("f", true, "g", true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.4, (double)forRange.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 5, 9);
        forRange = rangeIndex.forRange(null, false, "g", true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.5, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 3, 5, 9);
        forRange = rangeIndex.forRange("f", false, null, true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.6, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
        forRange = rangeIndex.forRange("b", true, "fooo", true);
        Assert.assertEquals((double)0.2, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 9);
        forRange = rangeIndex.forRange("b", true, "fooo", false);
        Assert.assertEquals((double)0.4, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 5, 9);
        forRange = rangeIndex.forRange(null, true, "fooo", true);
        Assert.assertEquals((double)0.3, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 3, 9);
        forRange = rangeIndex.forRange("b", true, null, false);
        Assert.assertEquals((double)0.6, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
        forRange = rangeIndex.forRange("b", false, null, true);
        Assert.assertEquals((double)0.7, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 3, 4, 5, 6, 9);
        forRange = rangeIndex.forRange(null, true, "fooo", false);
        Assert.assertEquals((double)0.5, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 3, 5, 9);
        forRange = rangeIndex.forRange(null, true, null, true);
        Assert.assertEquals((double)0.7, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 3, 4, 5, 6, 9);
        forRange = rangeIndex.forRange(null, false, null, false);
        Assert.assertEquals((double)0.7, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 3, 4, 5, 6, 9);
    }

    @Test
    public void testSingleValueStringWithNullPredicateIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeStringWithNullsSupplier();
        DruidPredicateIndex predicateIndex = (DruidPredicateIndex)indexSupplier.as(DruidPredicateIndex.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, new InDimFilter.ValuesSet((Collection)ImmutableSet.of((Object)"b", (Object)"z")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.3, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 3, 4, 6);
    }

    @Test
    public void testSingleTypeLongColumnValueSetIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeLongSupplier();
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("1");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.3, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 3, 9);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"1", (Object)"300", (Object)"700")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.6, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 2, 3, 7, 8, 9);
    }

    @Test
    public void testSingleTypeLongColumnRangeIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeLongSupplier();
        NumericRangeIndex rangeIndex = (NumericRangeIndex)indexSupplier.as(NumericRangeIndex.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange((Number)10L, true, (Number)400L, true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.5, (double)forRange.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 6, 7, 8);
        forRange = rangeIndex.forRange(null, true, null, true);
        Assert.assertEquals((double)1.0, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndex.forRange(null, false, null, false);
        Assert.assertEquals((double)1.0, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testSingleTypeLongColumnPredicateIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeLongSupplier();
        DruidPredicateIndex predicateIndex = (DruidPredicateIndex)indexSupplier.as(DruidPredicateIndex.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, new InDimFilter.ValuesSet((Collection)ImmutableSet.of((Object)"1", (Object)"3")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.5, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 3, 4, 5, 9);
    }

    @Test
    public void testSingleTypeLongColumnWithNullValueIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeLongSupplierWithNull();
        NullValueIndex nullIndex = (NullValueIndex)indexSupplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullIndex);
        BitmapColumnIndex columnIndex = nullIndex.forNull();
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.3, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 5, 8);
    }

    @Test
    public void testSingleTypeLongColumnWithNullValueSetIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeLongSupplierWithNull();
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("3");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.1, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 4);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"1", (Object)"3", (Object)"300")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.5, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 3, 4, 7, 9);
    }

    @Test
    public void testSingleValueLongWithNullRangeIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeLongSupplierWithNull();
        NumericRangeIndex rangeIndex = (NumericRangeIndex)indexSupplier.as(NumericRangeIndex.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange((Number)100, false, (Number)700, true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.3, (double)forRange.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 6, 7);
        forRange = rangeIndex.forRange(null, true, null, true);
        Assert.assertEquals((double)0.7, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 3, 4, 6, 7, 9);
        forRange = rangeIndex.forRange(null, false, null, false);
        Assert.assertEquals((double)0.7, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 3, 4, 6, 7, 9);
    }

    @Test
    public void testSingleValueLongWithNullPredicateIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeLongSupplierWithNull();
        DruidPredicateIndex predicateIndex = (DruidPredicateIndex)indexSupplier.as(DruidPredicateIndex.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, new InDimFilter.ValuesSet((Collection)ImmutableSet.of((Object)"3", (Object)"100")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.3, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 4, 6);
    }

    @Test
    public void testSingleTypeDoubleColumnValueSetIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeDoubleSupplier();
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("1.2");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.3, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 4, 7);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"1.2", (Object)"3.3", (Object)"6.6")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.7, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 3, 4, 5, 6, 7, 9);
    }

    @Test
    public void testSingleTypeDoubleColumnRangeIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeDoubleSupplier();
        NumericRangeIndex rangeIndex = (NumericRangeIndex)indexSupplier.as(NumericRangeIndex.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange((Number)1.0, true, (Number)5.0, true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.9, (double)forRange.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 6, 7, 8, 9);
        forRange = rangeIndex.forRange((Number)1.1, false, (Number)3.3, false);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.9, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 6, 7, 8, 9);
        forRange = rangeIndex.forRange((Number)1.1, true, (Number)3.3, true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.6, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 3, 4, 6, 7, 9);
        forRange = rangeIndex.forRange(null, true, null, true);
        Assert.assertEquals((double)1.0, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndex.forRange(null, false, null, false);
        Assert.assertEquals((double)1.0, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testSingleTypeDoubleColumnPredicateIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeDoubleSupplier();
        DruidPredicateIndex predicateIndex = (DruidPredicateIndex)indexSupplier.as(DruidPredicateIndex.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, new InDimFilter.ValuesSet((Collection)ImmutableSet.of((Object)"1.2", (Object)"3.3", (Object)"5.0")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.6, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 3, 4, 6, 7, 9);
    }

    @Test
    public void testSingleTypeDoubleColumnWithNullValueIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeDoubleSupplierWithNull();
        NullValueIndex nullIndex = (NullValueIndex)indexSupplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullIndex);
        BitmapColumnIndex columnIndex = nullIndex.forNull();
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.3, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 3, 6);
    }

    @Test
    public void testSingleTypeDoubleColumnWithNullValueSetIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeDoubleSupplierWithNull();
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("6.6");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.1, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 5);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"1.2", (Object)"3.3", (Object)"7.7")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.4, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 4, 7, 9);
    }

    @Test
    public void testSingleValueDoubleWithNullRangeIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeDoubleSupplierWithNull();
        NumericRangeIndex rangeIndex = (NumericRangeIndex)indexSupplier.as(NumericRangeIndex.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange((Number)1.1, false, (Number)5.0, true);
        Assert.assertNotNull((Object)forRange);
        Assert.assertEquals((double)0.6, (double)forRange.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 4, 7, 8, 9);
        forRange = rangeIndex.forRange(null, true, null, true);
        Assert.assertEquals((double)0.7, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 7, 8, 9);
        forRange = rangeIndex.forRange(null, false, null, false);
        Assert.assertEquals((double)0.7, (double)forRange.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 7, 8, 9);
    }

    @Test
    public void testSingleValueDoubleWithNullPredicateIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeSingleTypeDoubleSupplierWithNull();
        DruidPredicateIndex predicateIndex = (DruidPredicateIndex)indexSupplier.as(DruidPredicateIndex.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, new InDimFilter.ValuesSet((Collection)ImmutableSet.of((Object)"1.2", (Object)"3.3")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.4, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 4, 7, 9);
    }

    @Test
    public void testVariantNullValueIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeVariantSupplierWithNull();
        NullValueIndex nullIndex = (NullValueIndex)indexSupplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullIndex);
        BitmapColumnIndex columnIndex = nullIndex.forNull();
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.2, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 7);
    }

    @Test
    public void testVariantValueSetIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeVariantSupplierWithNull();
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("b");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.2, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 9);
        columnIndex = valueSetIndex.forValue("1");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.2, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 5);
        columnIndex = valueSetIndex.forValue("1.1");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.1, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 8);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"b", (Object)"300", (Object)"9.9", (Object)"1.6")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.4, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 3, 4, 9);
    }

    @Test
    public void testVariantRangeIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeVariantSupplierWithNull();
        LexicographicalRangeIndex rangeIndex = (LexicographicalRangeIndex)indexSupplier.as(LexicographicalRangeIndex.class);
        Assert.assertNull((Object)rangeIndex);
        NumericRangeIndex numericRangeIndex = (NumericRangeIndex)indexSupplier.as(NumericRangeIndex.class);
        Assert.assertNull((Object)numericRangeIndex);
    }

    @Test
    public void testVariantPredicateIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeVariantSupplierWithNull();
        DruidPredicateIndex predicateIndex = (DruidPredicateIndex)indexSupplier.as(DruidPredicateIndex.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, new InDimFilter.ValuesSet((Collection)ImmutableSet.of((Object)"b", (Object)"z", (Object)"9.9", (Object)"300")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.5, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 1, 3, 4, 6, 9);
    }

    @Test
    public void testDictionaryEncodedStringValueIndex() throws IOException {
        NestedFieldLiteralColumnIndexSupplier indexSupplier = this.makeVariantSupplierWithNull();
        DictionaryEncodedStringValueIndex lowLevelIndex = (DictionaryEncodedStringValueIndex)indexSupplier.as(DictionaryEncodedStringValueIndex.class);
        Assert.assertNotNull((Object)lowLevelIndex);
        Assert.assertNotNull((Object)indexSupplier.as(DictionaryEncodedValueIndex.class));
        Assert.assertNull((Object)lowLevelIndex.getValue(0));
        Assert.assertEquals((Object)"b", (Object)lowLevelIndex.getValue(1));
        Assert.assertEquals((Object)"z", (Object)lowLevelIndex.getValue(2));
        Assert.assertEquals((Object)"1", (Object)lowLevelIndex.getValue(3));
        Assert.assertEquals((Object)"300", (Object)lowLevelIndex.getValue(4));
        Assert.assertEquals((Object)"1.1", (Object)lowLevelIndex.getValue(5));
        Assert.assertEquals((Object)"9.9", (Object)lowLevelIndex.getValue(6));
    }

    private NestedFieldLiteralColumnIndexSupplier makeSingleTypeStringSupplier() throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)2);
        bitmapWriter.write((Object)this.fillBitmap(1, 3, 7, 8));
        localDictionaryWriter.write((Object)4);
        bitmapWriter.write((Object)this.fillBitmap(0, 9));
        localDictionaryWriter.write((Object)5);
        bitmapWriter.write((Object)this.fillBitmap(2, 5));
        localDictionaryWriter.write((Object)6);
        bitmapWriter.write((Object)this.fillBitmap(4, 6));
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        FixedIndexed dictionary = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldLiteralColumnIndexSupplier(new NestedLiteralTypeInfo.TypeSet(new NestedLiteralTypeInfo.MutableTypeSet().add(ColumnType.STRING).getByteValue()), this.roaringFactory.getBitmapFactory(), bitmaps, dictionary, this.globalStrings, this.globalLongs, this.globalDoubles);
    }

    private NestedFieldLiteralColumnIndexSupplier makeSingleTypeStringWithNullsSupplier() throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)0);
        bitmapWriter.write((Object)this.fillBitmap(1, 7, 8));
        localDictionaryWriter.write((Object)2);
        bitmapWriter.write((Object)this.fillBitmap(3));
        localDictionaryWriter.write((Object)4);
        bitmapWriter.write((Object)this.fillBitmap(0, 9));
        localDictionaryWriter.write((Object)5);
        bitmapWriter.write((Object)this.fillBitmap(2, 5));
        localDictionaryWriter.write((Object)6);
        bitmapWriter.write((Object)this.fillBitmap(4, 6));
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        FixedIndexed dictionary = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldLiteralColumnIndexSupplier(new NestedLiteralTypeInfo.TypeSet(new NestedLiteralTypeInfo.MutableTypeSet().add(ColumnType.STRING).getByteValue()), this.roaringFactory.getBitmapFactory(), bitmaps, dictionary, this.globalStrings, this.globalLongs, this.globalDoubles);
    }

    private NestedFieldLiteralColumnIndexSupplier makeSingleTypeLongSupplier() throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)7);
        bitmapWriter.write((Object)this.fillBitmap(1, 3, 9));
        localDictionaryWriter.write((Object)9);
        bitmapWriter.write((Object)this.fillBitmap(4, 5));
        localDictionaryWriter.write((Object)11);
        bitmapWriter.write((Object)this.fillBitmap(0, 6));
        localDictionaryWriter.write((Object)12);
        bitmapWriter.write((Object)this.fillBitmap(2, 7, 8));
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        FixedIndexed dictionary = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldLiteralColumnIndexSupplier(new NestedLiteralTypeInfo.TypeSet(new NestedLiteralTypeInfo.MutableTypeSet().add(ColumnType.LONG).getByteValue()), this.roaringFactory.getBitmapFactory(), bitmaps, dictionary, this.globalStrings, this.globalLongs, this.globalDoubles);
    }

    private NestedFieldLiteralColumnIndexSupplier makeSingleTypeLongSupplierWithNull() throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)0);
        bitmapWriter.write((Object)this.fillBitmap(2, 5, 8));
        localDictionaryWriter.write((Object)7);
        bitmapWriter.write((Object)this.fillBitmap(1, 3, 9));
        localDictionaryWriter.write((Object)9);
        bitmapWriter.write((Object)this.fillBitmap(4));
        localDictionaryWriter.write((Object)11);
        bitmapWriter.write((Object)this.fillBitmap(0, 6));
        localDictionaryWriter.write((Object)12);
        bitmapWriter.write((Object)this.fillBitmap(7));
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        FixedIndexed dictionary = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldLiteralColumnIndexSupplier(new NestedLiteralTypeInfo.TypeSet(new NestedLiteralTypeInfo.MutableTypeSet().add(ColumnType.LONG).getByteValue()), this.roaringFactory.getBitmapFactory(), bitmaps, dictionary, this.globalStrings, this.globalLongs, this.globalDoubles);
    }

    private NestedFieldLiteralColumnIndexSupplier makeSingleTypeDoubleSupplier() throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)15);
        bitmapWriter.write((Object)this.fillBitmap(0, 1, 8));
        localDictionaryWriter.write((Object)16);
        bitmapWriter.write((Object)this.fillBitmap(2, 4, 7));
        localDictionaryWriter.write((Object)19);
        bitmapWriter.write((Object)this.fillBitmap(3, 6, 9));
        localDictionaryWriter.write((Object)20);
        bitmapWriter.write((Object)this.fillBitmap(5));
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        FixedIndexed dictionary = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldLiteralColumnIndexSupplier(new NestedLiteralTypeInfo.TypeSet(new NestedLiteralTypeInfo.MutableTypeSet().add(ColumnType.DOUBLE).getByteValue()), this.roaringFactory.getBitmapFactory(), bitmaps, dictionary, this.globalStrings, this.globalLongs, this.globalDoubles);
    }

    private NestedFieldLiteralColumnIndexSupplier makeSingleTypeDoubleSupplierWithNull() throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)0);
        bitmapWriter.write((Object)this.fillBitmap(1, 3, 6));
        localDictionaryWriter.write((Object)15);
        bitmapWriter.write((Object)this.fillBitmap(0, 8));
        localDictionaryWriter.write((Object)16);
        bitmapWriter.write((Object)this.fillBitmap(2, 4, 7));
        localDictionaryWriter.write((Object)19);
        bitmapWriter.write((Object)this.fillBitmap(9));
        localDictionaryWriter.write((Object)20);
        bitmapWriter.write((Object)this.fillBitmap(5));
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        FixedIndexed dictionary = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldLiteralColumnIndexSupplier(new NestedLiteralTypeInfo.TypeSet(new NestedLiteralTypeInfo.MutableTypeSet().add(ColumnType.DOUBLE).getByteValue()), this.roaringFactory.getBitmapFactory(), bitmaps, dictionary, this.globalStrings, this.globalLongs, this.globalDoubles);
    }

    private NestedFieldLiteralColumnIndexSupplier makeVariantSupplierWithNull() throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)0);
        bitmapWriter.write((Object)this.fillBitmap(2, 7));
        localDictionaryWriter.write((Object)2);
        bitmapWriter.write((Object)this.fillBitmap(1, 9));
        localDictionaryWriter.write((Object)6);
        bitmapWriter.write((Object)this.fillBitmap(6));
        localDictionaryWriter.write((Object)7);
        bitmapWriter.write((Object)this.fillBitmap(0, 5));
        localDictionaryWriter.write((Object)12);
        bitmapWriter.write((Object)this.fillBitmap(4));
        localDictionaryWriter.write((Object)15);
        bitmapWriter.write((Object)this.fillBitmap(8));
        localDictionaryWriter.write((Object)21);
        bitmapWriter.write((Object)this.fillBitmap(3));
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldLiteralColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        FixedIndexed dictionary = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)NestedDataColumnSerializer.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldLiteralColumnIndexSupplier(new NestedLiteralTypeInfo.TypeSet(new NestedLiteralTypeInfo.MutableTypeSet().add(ColumnType.STRING).add(ColumnType.LONG).add(ColumnType.DOUBLE).getByteValue()), this.roaringFactory.getBitmapFactory(), bitmaps, dictionary, this.globalStrings, this.globalLongs, this.globalDoubles);
    }

    private ImmutableBitmap fillBitmap(int ... rows) {
        MutableBitmap bitmap = this.roaringFactory.getBitmapFactory().makeEmptyMutableBitmap();
        for (int i : rows) {
            bitmap.add(i);
        }
        return this.roaringFactory.getBitmapFactory().makeImmutableBitmap(bitmap);
    }

    void checkBitmap(ImmutableBitmap bitmap, int ... expectedRows) {
        IntIterator iterator = bitmap.iterator();
        for (int i : expectedRows) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((long)i, (long)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    static void writeToBuffer(final ByteBuffer buffer, Serializer serializer) throws IOException {
        WritableByteChannel channel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int size = src.remaining();
                buffer.put(src);
                return size;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }
        };
        serializer.writeTo(channel, null);
        buffer.position(0);
    }
}

