/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class NestedPathFinderTest {
    private static final Map<String, Object> NESTER = ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)"y", (Object)ImmutableMap.of((Object)"a", (Object)"hello", (Object)"b", (Object)"world"), (Object)"z", (Object)"foo", (Object)"[sneaky]", (Object)"bar", (Object)"[also_sneaky]", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"a", (Object)"x"), (Object)ImmutableMap.of((Object)"b", (Object)"y", (Object)"c", (Object)"z")));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testParseJqPath() {
        List pathParts = NestedPathFinder.parseJqPath((String)".");
        Assert.assertEquals((long)0L, (long)pathParts.size());
        pathParts = NestedPathFinder.parseJqPath((String)".z");
        Assert.assertEquals((long)1L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"z", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertEquals((Object)".\"z\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".\"z\"");
        Assert.assertEquals((long)1L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"z", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertEquals((Object)".\"z\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".[\"z\"]");
        Assert.assertEquals((long)1L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"z", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertEquals((Object)".\"z\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".x[1]");
        Assert.assertEquals((long)2L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1]", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".\"x\"[1]");
        Assert.assertEquals((long)2L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1]", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".[\"x\"][1]");
        Assert.assertEquals((long)2L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1]", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".[\"x\"][\"1\"]");
        Assert.assertEquals((long)2L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathField));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\".\"1\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".x[1].foo.bar");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"foo", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)"bar", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1].\"foo\".\"bar\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".x[1].\"foo\".bar");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"foo", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)"bar", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1].\"foo\".\"bar\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".[\"x\"][1].\"foo\"[\"bar\"]");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"foo", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)"bar", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1].\"foo\".\"bar\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".[\"x\"]?[1]?.foo?.\"bar\"?");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"foo", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)"bar", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1].\"foo\".\"bar\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".\"x\"[\"1\"].\"foo\".\"bar\"");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathField));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"foo", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)"bar", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\".\"1\".\"foo\".\"bar\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".[\"x.y.z]?[\\\"]][]\"]?[\"13234.12[]][23\"].\"f?o.o\"?[\".b?.a.r.\"]");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x.y.z]?[\\\"]][]", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathField));
        Assert.assertEquals((Object)"13234.12[]][23", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"f?o.o", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)".b?.a.r.", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x.y.z]?[\\\"]][]\".\"13234.12[]][23\".\"f?o.o\".\".b?.a.r.\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
    }

    @Test
    public void testParseJsonPath() {
        List pathParts = NestedPathFinder.parseJsonPath((String)"$.");
        Assert.assertEquals((long)0L, (long)pathParts.size());
        pathParts = NestedPathFinder.parseJsonPath((String)"$");
        Assert.assertEquals((long)0L, (long)pathParts.size());
        pathParts = NestedPathFinder.parseJsonPath((String)"$.z");
        Assert.assertEquals((long)1L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"z", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertEquals((Object)".\"z\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$.z", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$['z']");
        Assert.assertEquals((long)1L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"z", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertEquals((Object)".\"z\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$.z", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$.x[1]");
        Assert.assertEquals((long)2L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1]", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$.x[1]", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$.x[-1]");
        Assert.assertEquals((long)2L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"-1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[-1]", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$.x[-1]", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$['x'][1]");
        Assert.assertEquals((long)2L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1]", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$.x[1]", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$['x']['1']");
        Assert.assertEquals((long)2L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathField));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\".\"1\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$.x.1", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$.x[1].foo.bar");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"foo", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)"bar", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1].\"foo\".\"bar\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$.x[1].foo.bar", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$.x[1]['foo'].bar");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"foo", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)"bar", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1].\"foo\".\"bar\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$.x[1].foo.bar", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$['x'][1].foo['bar']");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathArrayElement));
        Assert.assertEquals((Object)"1", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"foo", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)"bar", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x\"[1].\"foo\".\"bar\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$.x[1].foo.bar", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$['x.y.z][\\']][]']['13234.12[]][23']['fo.o']['.b.a.r.']");
        Assert.assertEquals((long)4L, (long)pathParts.size());
        Assert.assertTrue((boolean)(pathParts.get(0) instanceof NestedPathField));
        Assert.assertEquals((Object)"x.y.z][\\']][]", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(1) instanceof NestedPathField));
        Assert.assertEquals((Object)"13234.12[]][23", (Object)((NestedPathPart)pathParts.get(1)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(2) instanceof NestedPathField));
        Assert.assertEquals((Object)"fo.o", (Object)((NestedPathPart)pathParts.get(2)).getPartIdentifier());
        Assert.assertTrue((boolean)(pathParts.get(3) instanceof NestedPathField));
        Assert.assertEquals((Object)".b.a.r.", (Object)((NestedPathPart)pathParts.get(3)).getPartIdentifier());
        Assert.assertEquals((Object)".\"x.y.z][\\']][]\".\"13234.12[]][23\".\"fo.o\".\".b.a.r.\"", (Object)NestedPathFinder.toNormalizedJqPath((List)pathParts));
        Assert.assertEquals((Object)"$['x.y.z][\\']][]']['13234.12[]][23']['fo.o']['.b.a.r.']", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
        pathParts = NestedPathFinder.parseJsonPath((String)"$['hell'o']");
        Assert.assertEquals((long)1L, (long)pathParts.size());
        Assert.assertEquals((Object)"hell'o", (Object)((NestedPathPart)pathParts.get(0)).getPartIdentifier());
        Assert.assertEquals((Object)"$['hell'o']", (Object)NestedPathFinder.toNormalizedJsonPath((List)pathParts));
    }

    @Test
    public void testBadFormatMustStartWithDot() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Bad format, 'x.y' is not a valid 'jq' path: must start with '.'");
        NestedPathFinder.parseJqPath((String)"x.y");
    }

    @Test
    public void testBadFormatNoDot() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage(".\"x\"\"y\"' is not a valid 'jq' path: path parts must be separated with '.'");
        NestedPathFinder.parseJqPath((String)".\"x\"\"y\"");
    }

    @Test
    public void testBadFormatWithDot2() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Bad format, '..\"x\"' is not a valid 'jq' path: path parts separated by '.' must not be empty");
        NestedPathFinder.parseJqPath((String)"..\"x\"");
    }

    @Test
    public void testBadFormatWithDot3() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Bad format, '.x.[1]' is not a valid 'jq' path: invalid position 3 for '[', must not follow '.' or must be contained with '\"'");
        NestedPathFinder.parseJqPath((String)".x.[1]");
    }

    @Test
    public void testBadFormatWithDot4() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Bad format, '.x[1].[2]' is not a valid 'jq' path: invalid position 6 for '[', must not follow '.' or must be contained with '\"'");
        NestedPathFinder.parseJqPath((String)".x[1].[2]");
    }

    @Test
    public void testBadFormatNotANumber() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Bad format, '.x[.1]' is not a valid 'jq' path: expected number for array specifier got .1 instead. Use \"\" if this value was meant to be a field name");
        NestedPathFinder.parseJqPath((String)".x[.1]");
    }

    @Test
    public void testBadFormatUnclosedArray() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Bad format, '.x[1' is not a valid 'jq' path: unterminated '['");
        NestedPathFinder.parseJqPath((String)".x[1");
    }

    @Test
    public void testBadFormatUnclosedArray2() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Bad format, '.x[\"1\"' is not a valid 'jq' path: unterminated '['");
        NestedPathFinder.parseJqPath((String)".x[\"1\"");
    }

    @Test
    public void testBadFormatUnclosedQuote() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Bad format, '.x.\"1' is not a valid 'jq' path: unterminated '\"'");
        NestedPathFinder.parseJqPath((String)".x.\"1");
    }

    @Test
    public void testBadFormatUnclosedQuote2() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Bad format, '.x[\"1]' is not a valid 'jq' path: unterminated '\"'");
        NestedPathFinder.parseJqPath((String)".x[\"1]");
    }

    @Test
    public void testPathSplitter() {
        List pathParts = NestedPathFinder.parseJqPath((String)".");
        Assert.assertEquals(NESTER, (Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertNull((Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".z");
        Assert.assertEquals((Object)"foo", (Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertEquals((Object)"foo", (Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".x");
        Assert.assertEquals((Object)NESTER.get("x"), (Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertNull((Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".x[1]");
        Assert.assertEquals((Object)"b", (Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertEquals((Object)"b", (Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".x[-1]");
        Assert.assertEquals((Object)"c", (Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertEquals((Object)"c", (Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".x[-2]");
        Assert.assertEquals((Object)"b", (Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertEquals((Object)"b", (Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".x[-4]");
        Assert.assertNull((Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertNull((Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".x[1].y.z");
        Assert.assertNull((Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertNull((Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".y.a");
        Assert.assertEquals((Object)"hello", (Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertEquals((Object)"hello", (Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".y[1]");
        Assert.assertNull((Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertNull((Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".\"[sneaky]\"");
        Assert.assertEquals((Object)"bar", (Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertEquals((Object)"bar", (Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
        pathParts = NestedPathFinder.parseJqPath((String)".\"[also_sneaky]\"[1].c");
        Assert.assertEquals((Object)"z", (Object)NestedPathFinder.find(NESTER, (List)pathParts));
        Assert.assertEquals((Object)"z", (Object)NestedPathFinder.findStringLiteral(NESTER, (List)pathParts));
    }
}

