/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.druid.segment.vector.BitmapVectorOffset;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitmapVectorOffsetTest {
    private static final int VECTOR_SIZE = 128;
    private static final int ROWS = 16384;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testContiguousGetOffsetsIsExplode() {
        MutableRoaringBitmap wrapped = new MutableRoaringBitmap();
        for (int i = 0; i < 16384; ++i) {
            wrapped.add(i);
        }
        WrappedImmutableRoaringBitmap bitmap = new WrappedImmutableRoaringBitmap(wrapped.toImmutableRoaringBitmap());
        BitmapVectorOffset offset = new BitmapVectorOffset(128, (ImmutableBitmap)bitmap, 0, 16384);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("is contiguous");
        offset.getOffsets();
    }

    @Test
    public void testNotContiguousGetStartOffsetIsExplode() {
        MutableRoaringBitmap wrapped = new MutableRoaringBitmap();
        for (int i = 0; i < 16384; ++i) {
            if (i % 2 == 0) continue;
            wrapped.add(i);
        }
        WrappedImmutableRoaringBitmap bitmap = new WrappedImmutableRoaringBitmap(wrapped.toImmutableRoaringBitmap());
        BitmapVectorOffset offset = new BitmapVectorOffset(128, (ImmutableBitmap)bitmap, 0, 16384);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("not contiguous");
        offset.getStartOffset();
    }

    @Test
    public void testContiguous() {
        MutableRoaringBitmap wrapped = new MutableRoaringBitmap();
        for (int i = 0; i < 16384; ++i) {
            wrapped.add(i);
        }
        WrappedImmutableRoaringBitmap bitmap = new WrappedImmutableRoaringBitmap(wrapped.toImmutableRoaringBitmap());
        for (int startOffset = 0; startOffset < 16384; ++startOffset) {
            BitmapVectorOffset offset = new BitmapVectorOffset(128, (ImmutableBitmap)bitmap, startOffset, 16384);
            while (!offset.isDone()) {
                if (offset.getCurrentVectorSize() > 1) {
                    Assert.assertTrue((boolean)offset.isContiguous());
                }
                offset.advance();
            }
        }
    }

    @Test
    public void testNeverContiguous() {
        MutableRoaringBitmap wrapped = new MutableRoaringBitmap();
        for (int i = 0; i < 16384; ++i) {
            if (i % 2 == 0) continue;
            wrapped.add(i);
        }
        WrappedImmutableRoaringBitmap bitmap = new WrappedImmutableRoaringBitmap(wrapped.toImmutableRoaringBitmap());
        for (int startOffset = 0; startOffset < 16384; ++startOffset) {
            BitmapVectorOffset offset = new BitmapVectorOffset(128, (ImmutableBitmap)bitmap, startOffset, 16384);
            while (!offset.isDone()) {
                Assert.assertFalse((boolean)offset.isContiguous());
                offset.advance();
            }
        }
    }

    @Test
    public void testSometimesContiguous() {
        MutableRoaringBitmap wrapped = new MutableRoaringBitmap();
        for (int i = 0; i < 16257; ++i) {
            int set = ThreadLocalRandom.current().nextInt(0, 16384);
            while (wrapped.contains(set)) {
                set = ThreadLocalRandom.current().nextInt(0, 16384);
            }
            wrapped.add(set);
        }
        WrappedImmutableRoaringBitmap bitmap = new WrappedImmutableRoaringBitmap(wrapped.toImmutableRoaringBitmap());
        int contiguousCount = 0;
        int nonContiguousCount = 0;
        int noContiguous = 0;
        int allContiguous = 0;
        for (int startOffset = 0; startOffset < 16384; ++startOffset) {
            BitmapVectorOffset offset = new BitmapVectorOffset(128, (ImmutableBitmap)bitmap, startOffset, 16384);
            boolean none = true;
            boolean all = true;
            while (!offset.isDone()) {
                if (offset.isContiguous()) {
                    ++contiguousCount;
                    none = false;
                } else {
                    ++nonContiguousCount;
                    all = false;
                }
                offset.advance();
            }
            if (none) {
                ++noContiguous;
            }
            if (!all) continue;
            ++allContiguous;
        }
        Assert.assertTrue((contiguousCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((nonContiguousCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((noContiguous > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)allContiguous);
    }
}

