/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorColumnIndexSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.apache.druid.segment.virtual.VirtualizedColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ListFilteredVirtualColumnSelectorTest
extends InitializedNullHandlingTest {
    private static final String COLUMN_NAME = "x";
    private static final String NON_EXISTENT_COLUMN_NAME = "nope";
    private static final String ALLOW_VIRTUAL_NAME = "allowed";
    private static final String DENY_VIRTUAL_NAME = "no-stairway";
    private final RowSignature rowSignature = RowSignature.builder().addTimeColumn().addDimensions((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"x"))).build();

    @Test
    public void testListFilteredVirtualColumnNilDimensionSelector() {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn(ALLOW_VIRTUAL_NAME, (DimensionSpec)new DefaultDimensionSpec(NON_EXISTENT_COLUMN_NAME, NON_EXISTENT_COLUMN_NAME, ColumnType.STRING), (Set)ImmutableSet.of((Object)"a", (Object)"b"), Boolean.valueOf(true));
        VirtualizedColumnSelectorFactory selectorFactory = this.makeSelectorFactory(virtualColumn);
        DimensionSelector selector = selectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)ALLOW_VIRTUAL_NAME));
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void testListFilteredVirtualColumnNilColumnValueSelector() {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn(ALLOW_VIRTUAL_NAME, (DimensionSpec)new DefaultDimensionSpec(NON_EXISTENT_COLUMN_NAME, NON_EXISTENT_COLUMN_NAME, ColumnType.STRING), (Set)ImmutableSet.of((Object)"a", (Object)"b"), Boolean.valueOf(true));
        VirtualizedColumnSelectorFactory selectorFactory = this.makeSelectorFactory(virtualColumn);
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(ALLOW_VIRTUAL_NAME);
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void testListFilteredVirtualColumnAllowListDimensionSelector() {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn(ALLOW_VIRTUAL_NAME, (DimensionSpec)new DefaultDimensionSpec(COLUMN_NAME, COLUMN_NAME, ColumnType.STRING), (Set)ImmutableSet.of((Object)"a", (Object)"b"), Boolean.valueOf(true));
        VirtualizedColumnSelectorFactory selectorFactory = this.makeSelectorFactory(virtualColumn);
        DimensionSelector selector = selectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)ALLOW_VIRTUAL_NAME));
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)selector.getObject());
        this.assertCapabilities(selectorFactory, ALLOW_VIRTUAL_NAME);
    }

    @Test
    public void testListFilteredVirtualColumnAllowListColumnValueSelector() {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn(ALLOW_VIRTUAL_NAME, (DimensionSpec)new DefaultDimensionSpec(COLUMN_NAME, COLUMN_NAME, ColumnType.STRING), (Set)ImmutableSet.of((Object)"a", (Object)"b"), Boolean.valueOf(true));
        VirtualizedColumnSelectorFactory selectorFactory = this.makeSelectorFactory(virtualColumn);
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(ALLOW_VIRTUAL_NAME);
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)selector.getObject());
        this.assertCapabilities(selectorFactory, ALLOW_VIRTUAL_NAME);
    }

    @Test
    public void testListFilteredVirtualColumnDenyListDimensionSelector() {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn(DENY_VIRTUAL_NAME, (DimensionSpec)new DefaultDimensionSpec(COLUMN_NAME, COLUMN_NAME, ColumnType.STRING), (Set)ImmutableSet.of((Object)"a", (Object)"b"), Boolean.valueOf(false));
        VirtualizedColumnSelectorFactory selectorFactory = this.makeSelectorFactory(virtualColumn);
        DimensionSelector selector = selectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)DENY_VIRTUAL_NAME));
        Assert.assertEquals((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)selector.getObject());
        this.assertCapabilities(selectorFactory, DENY_VIRTUAL_NAME);
    }

    @Test
    public void testListFilteredVirtualColumnDenyListColumnValueSelector() {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn(DENY_VIRTUAL_NAME, (DimensionSpec)new DefaultDimensionSpec(COLUMN_NAME, COLUMN_NAME, ColumnType.STRING), (Set)ImmutableSet.of((Object)"a", (Object)"b"), Boolean.valueOf(false));
        VirtualizedColumnSelectorFactory selectorFactory = this.makeSelectorFactory(virtualColumn);
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(DENY_VIRTUAL_NAME);
        Assert.assertEquals((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)selector.getObject());
        this.assertCapabilities(selectorFactory, DENY_VIRTUAL_NAME);
    }

    @Test
    public void testFilterListFilteredVirtualColumnAllowIndex() {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn(ALLOW_VIRTUAL_NAME, (DimensionSpec)new DefaultDimensionSpec(COLUMN_NAME, COLUMN_NAME, ColumnType.STRING), (Set)ImmutableSet.of((Object)"b", (Object)"c"), Boolean.valueOf(true));
        ColumnSelector selector = (ColumnSelector)EasyMock.createMock(ColumnSelector.class);
        ColumnHolder holder = (ColumnHolder)EasyMock.createMock(ColumnHolder.class);
        ColumnHolder timeHolder = (ColumnHolder)EasyMock.createMock(ColumnHolder.class);
        DictionaryEncodedStringValueIndex index = (DictionaryEncodedStringValueIndex)EasyMock.createMock(DictionaryEncodedStringValueIndex.class);
        ImmutableBitmap bitmap = (ImmutableBitmap)EasyMock.createMock(ImmutableBitmap.class);
        BitmapFactory bitmapFactory = (BitmapFactory)EasyMock.createMock(BitmapFactory.class);
        ColumnIndexSupplier indexSupplier = (ColumnIndexSupplier)EasyMock.createMock(ColumnIndexSupplier.class);
        EasyMock.expect((Object)selector.getColumnHolder(COLUMN_NAME)).andReturn((Object)holder).atLeastOnce();
        EasyMock.expect((Object)selector.getColumnHolder("__time")).andReturn((Object)timeHolder).atLeastOnce();
        EasyMock.expect((Object)timeHolder.getLength()).andReturn((Object)10).anyTimes();
        EasyMock.expect((Object)selector.getColumnCapabilities(COLUMN_NAME)).andReturn((Object)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasBitmapIndexes(true)).anyTimes();
        EasyMock.expect((Object)holder.getIndexSupplier()).andReturn((Object)indexSupplier).atLeastOnce();
        EasyMock.expect((Object)indexSupplier.as(DictionaryEncodedStringValueIndex.class)).andReturn((Object)index).atLeastOnce();
        EasyMock.expect((Object)index.getCardinality()).andReturn((Object)3).atLeastOnce();
        EasyMock.expect((Object)index.getValue(0)).andReturn((Object)"a").atLeastOnce();
        EasyMock.expect((Object)index.getValue(1)).andReturn((Object)"b").atLeastOnce();
        EasyMock.expect((Object)index.getValue(2)).andReturn((Object)"c").atLeastOnce();
        EasyMock.expect((Object)index.getBitmap(2)).andReturn((Object)bitmap).once();
        EasyMock.replay((Object[])new Object[]{selector, holder, timeHolder, indexSupplier, index, bitmap, bitmapFactory});
        ColumnSelectorColumnIndexSelector bitmapIndexSelector = new ColumnSelectorColumnIndexSelector((BitmapFactory)new RoaringBitmapFactory(), VirtualColumns.create(Collections.singletonList(virtualColumn)), selector);
        SelectorFilter filter = new SelectorFilter(ALLOW_VIRTUAL_NAME, "a");
        Assert.assertNotNull((Object)filter.getBitmapColumnIndex((ColumnIndexSelector)bitmapIndexSelector));
        DictionaryEncodedStringValueIndex listFilteredIndex = (DictionaryEncodedStringValueIndex)bitmapIndexSelector.getIndexSupplier(ALLOW_VIRTUAL_NAME).as(DictionaryEncodedStringValueIndex.class);
        Assert.assertEquals((long)2L, (long)listFilteredIndex.getCardinality());
        Assert.assertEquals((Object)"b", (Object)listFilteredIndex.getValue(0));
        Assert.assertEquals((Object)"c", (Object)listFilteredIndex.getValue(1));
        Assert.assertEquals((Object)bitmap, (Object)listFilteredIndex.getBitmap(1));
        EasyMock.verify((Object[])new Object[]{selector, holder, timeHolder, indexSupplier, index, bitmap, bitmapFactory});
    }

    @Test
    public void testFilterListFilteredVirtualColumnDenyIndex() {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn(DENY_VIRTUAL_NAME, (DimensionSpec)new DefaultDimensionSpec(COLUMN_NAME, COLUMN_NAME, ColumnType.STRING), (Set)ImmutableSet.of((Object)"a", (Object)"b"), Boolean.valueOf(false));
        ColumnSelector selector = (ColumnSelector)EasyMock.createMock(ColumnSelector.class);
        ColumnHolder holder = (ColumnHolder)EasyMock.createMock(ColumnHolder.class);
        ColumnHolder timeHolder = (ColumnHolder)EasyMock.createMock(ColumnHolder.class);
        DictionaryEncodedStringValueIndex index = (DictionaryEncodedStringValueIndex)EasyMock.createMock(DictionaryEncodedStringValueIndex.class);
        ImmutableBitmap bitmap = (ImmutableBitmap)EasyMock.createMock(ImmutableBitmap.class);
        ColumnIndexSupplier indexSupplier = (ColumnIndexSupplier)EasyMock.createMock(ColumnIndexSupplier.class);
        BitmapFactory bitmapFactory = (BitmapFactory)EasyMock.createMock(BitmapFactory.class);
        EasyMock.expect((Object)selector.getColumnHolder(COLUMN_NAME)).andReturn((Object)holder).atLeastOnce();
        EasyMock.expect((Object)selector.getColumnHolder("__time")).andReturn((Object)timeHolder).atLeastOnce();
        EasyMock.expect((Object)timeHolder.getLength()).andReturn((Object)10).anyTimes();
        EasyMock.expect((Object)selector.getColumnCapabilities(COLUMN_NAME)).andReturn((Object)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasBitmapIndexes(true)).anyTimes();
        EasyMock.expect((Object)holder.getIndexSupplier()).andReturn((Object)indexSupplier).atLeastOnce();
        EasyMock.expect((Object)indexSupplier.as(DictionaryEncodedStringValueIndex.class)).andReturn((Object)index).atLeastOnce();
        EasyMock.expect((Object)index.getCardinality()).andReturn((Object)3).atLeastOnce();
        EasyMock.expect((Object)index.getValue(0)).andReturn((Object)"a").atLeastOnce();
        EasyMock.expect((Object)index.getValue(1)).andReturn((Object)"b").atLeastOnce();
        EasyMock.expect((Object)index.getValue(2)).andReturn((Object)"c").atLeastOnce();
        EasyMock.expect((Object)index.getBitmap(0)).andReturn((Object)bitmap).once();
        EasyMock.replay((Object[])new Object[]{selector, holder, timeHolder, indexSupplier, index, bitmap, bitmapFactory});
        ColumnSelectorColumnIndexSelector bitmapIndexSelector = new ColumnSelectorColumnIndexSelector((BitmapFactory)new RoaringBitmapFactory(), VirtualColumns.create(Collections.singletonList(virtualColumn)), selector);
        SelectorFilter filter = new SelectorFilter(DENY_VIRTUAL_NAME, "c");
        Assert.assertNotNull((Object)filter.getBitmapColumnIndex((ColumnIndexSelector)bitmapIndexSelector));
        DictionaryEncodedStringValueIndex listFilteredIndex = (DictionaryEncodedStringValueIndex)bitmapIndexSelector.getIndexSupplier(DENY_VIRTUAL_NAME).as(DictionaryEncodedStringValueIndex.class);
        Assert.assertEquals((long)1L, (long)listFilteredIndex.getCardinality());
        Assert.assertEquals((Object)bitmap, (Object)listFilteredIndex.getBitmap(1));
        EasyMock.verify((Object[])new Object[]{selector, holder, timeHolder, indexSupplier, index, bitmap, bitmapFactory});
    }

    private void assertCapabilities(VirtualizedColumnSelectorFactory selectorFactory, String columnName) {
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(columnName);
        Assert.assertNotNull((Object)capabilities);
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertTrue((boolean)capabilities.hasMultipleValues().isMaybeTrue());
    }

    private VirtualizedColumnSelectorFactory makeSelectorFactory(ListFilteredVirtualColumn virtualColumn) {
        VirtualizedColumnSelectorFactory selectorFactory = new VirtualizedColumnSelectorFactory((ColumnSelectorFactory)RowBasedColumnSelectorFactory.create((RowAdapter)RowAdapters.standardRow(), () -> new MapBasedRow(0L, (Map)ImmutableMap.of((Object)COLUMN_NAME, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"))), (ColumnInspector)this.rowSignature, (boolean)false, (boolean)false), VirtualColumns.create((List)ImmutableList.of((Object)virtualColumn)));
        return selectorFactory;
    }
}

