/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.base.Predicate;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;

public class StringFieldReader
implements FieldReader {
    private final boolean asArray;

    StringFieldReader(boolean asArray) {
        this.asArray = asArray;
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer) {
        return new Selector(memory, fieldPointer, null, this.asArray);
    }

    @Override
    public DimensionSelector makeDimensionSelector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn) {
        if (this.asArray) {
            throw new ISE("Cannot call makeDimensionSelector on field of type [%s]", new Object[]{ColumnType.STRING_ARRAY});
        }
        return new Selector(memory, fieldPointer, extractionFn, false);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    private static class Selector
    implements DimensionSelector {
        private final Memory memory;
        private final ReadableFieldPointer fieldPointer;
        @Nullable
        private final ExtractionFn extractionFn;
        private final boolean asArray;
        private long currentFieldPosition = -1L;
        private final RangeIndexedInts indexedInts = new RangeIndexedInts();
        private final List<ByteBuffer> currentUtf8Strings = new ArrayList<ByteBuffer>();

        private Selector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn, boolean asArray) {
            this.memory = memory;
            this.fieldPointer = fieldPointer;
            this.extractionFn = extractionFn;
            this.asArray = asArray;
        }

        @Override
        @Nullable
        public Object getObject() {
            List<ByteBuffer> currentStrings = this.computeCurrentUtf8Strings();
            int size = currentStrings.size();
            if (size == 0) {
                return this.asArray ? Collections.emptyList() : null;
            }
            if (size == 1) {
                return this.asArray ? Collections.singletonList(this.lookupName(0)) : this.lookupName(0);
            }
            ArrayList<String> strings = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                strings.add(this.lookupName(i));
            }
            return strings;
        }

        @Override
        public IndexedInts getRow() {
            this.indexedInts.setSize(this.computeCurrentUtf8Strings().size());
            return this.indexedInts;
        }

        @Override
        @Nullable
        public String lookupName(int id) {
            ByteBuffer byteBuffer = this.computeCurrentUtf8Strings().get(id);
            String s = byteBuffer != null ? StringUtils.fromUtf8((ByteBuffer)byteBuffer.duplicate()) : null;
            return this.extractionFn == null ? s : this.extractionFn.apply(s);
        }

        @Override
        public boolean supportsLookupNameUtf8() {
            return this.extractionFn == null;
        }

        @Override
        @Nullable
        public ByteBuffer lookupNameUtf8(int id) {
            if (this.extractionFn != null) {
                throw new ISE("Cannot use lookupNameUtf8 on this selector", new Object[0]);
            }
            return this.computeCurrentUtf8Strings().get(id);
        }

        @Override
        public int getValueCardinality() {
            return -1;
        }

        @Override
        public boolean nameLookupPossibleInAdvance() {
            return false;
        }

        @Override
        @Nullable
        public IdLookup idLookup() {
            return null;
        }

        @Override
        public ValueMatcher makeValueMatcher(@Nullable String value) {
            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
        }

        @Override
        public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
        }

        @Override
        public Class<?> classOfObject() {
            return Object.class;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        private List<ByteBuffer> computeCurrentUtf8Strings() {
            long fieldPosition = this.fieldPointer.position();
            if (fieldPosition != this.currentFieldPosition) {
                this.updateCurrentUtf8Strings(fieldPosition);
            }
            this.currentFieldPosition = fieldPosition;
            return this.currentUtf8Strings;
        }

        private void updateCurrentUtf8Strings(long fieldPosition) {
            this.currentUtf8Strings.clear();
            long position = fieldPosition;
            long limit = this.memory.getCapacity();
            boolean rowTerminatorSeen = false;
            while (position < limit && !rowTerminatorSeen) {
                byte kind = this.memory.getByte(position);
                rowTerminatorSeen = false;
                ++position;
                block0 : switch (kind) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        rowTerminatorSeen = true;
                        break;
                    }
                    case 2: {
                        this.currentUtf8Strings.add(null);
                        break;
                    }
                    case 3: {
                        long i = position;
                        while (true) {
                            if (i >= limit) {
                                throw new ISE("Value overrun", new Object[0]);
                            }
                            byte b = this.memory.getByte(i);
                            if (b == 0) {
                                int len = Ints.checkedCast((long)(i - position));
                                ByteBuffer buf = FrameReaderUtils.readByteBuffer(this.memory, position, len);
                                this.currentUtf8Strings.add(buf);
                                position += (long)len;
                                break block0;
                            }
                            ++i;
                        }
                    }
                    default: {
                        throw new ISE("Invalid value start byte [%s]", new Object[]{kind});
                    }
                }
            }
            if (!rowTerminatorSeen) {
                throw new ISE("Unexpected end of field", new Object[0]);
            }
        }
    }
}

