/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;

public class FrameChannelMuxer
implements FrameProcessor<Long> {
    private final List<ReadableFrameChannel> inputChannels;
    private final WritableFrameChannel outputChannel;
    private final IntSet remainingChannels = new IntOpenHashSet();
    private long rowsRead = 0L;

    public FrameChannelMuxer(List<ReadableFrameChannel> inputChannels, WritableFrameChannel outputChannel) {
        this.inputChannels = inputChannels;
        this.outputChannel = outputChannel;
    }

    @Override
    public List<ReadableFrameChannel> inputChannels() {
        return this.inputChannels;
    }

    @Override
    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    @Override
    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        if (this.remainingChannels.isEmpty()) {
            for (int i = 0; i < this.inputChannels.size(); ++i) {
                ReadableFrameChannel channel = this.inputChannels.get(i);
                if (channel.isFinished()) continue;
                this.remainingChannels.add(i);
            }
        }
        if (!readableInputs.isEmpty()) {
            int channelIdx = ThreadLocalRandom.current().nextInt(readableInputs.size());
            int i = 0;
            IntIterator iterator = readableInputs.iterator();
            while (iterator.hasNext()) {
                int channelNumber = iterator.nextInt();
                ReadableFrameChannel channel = this.inputChannels.get(channelNumber);
                if (channel.isFinished()) {
                    this.remainingChannels.remove(channelNumber);
                } else if (i == channelIdx) {
                    Frame frame = channel.read();
                    this.outputChannel.write(frame);
                    this.rowsRead += (long)frame.numRows();
                }
                ++i;
            }
        }
        if (this.remainingChannels.isEmpty()) {
            return ReturnOrAwait.returnObject(this.rowsRead);
        }
        return ReturnOrAwait.awaitAny(this.remainingChannels);
    }

    @Override
    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), new Closeable[0]);
    }
}

