/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import java.util.ArrayList;
import java.util.List;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.FieldWriters;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.RowBasedFrameWriter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CloseableUtils;

public class RowBasedFrameWriterFactory
implements FrameWriterFactory {
    private final MemoryAllocator allocator;
    private final RowSignature signature;
    private final List<SortColumn> sortColumns;

    public RowBasedFrameWriterFactory(MemoryAllocator allocator, RowSignature signature, List<SortColumn> sortColumns) {
        this.allocator = allocator;
        this.signature = signature;
        this.sortColumns = sortColumns;
        FrameWriterUtils.verifySortColumns(sortColumns, signature);
    }

    @Override
    public FrameWriter newFrameWriter(ColumnSelectorFactory columnSelectorFactory) {
        AppendableMemory rowOrderMemory = this.sortColumns.isEmpty() ? null : AppendableMemory.create(this.allocator);
        AppendableMemory rowOffsetMemory = AppendableMemory.create(this.allocator);
        AppendableMemory dataMemory = AppendableMemory.create(this.allocator, 8192);
        return new RowBasedFrameWriter(this.signature, this.sortColumns, this.makeFieldWriters(columnSelectorFactory), FrameReaderUtils.makeRowMemorySupplier(columnSelectorFactory, this.signature), rowOrderMemory, rowOffsetMemory, dataMemory);
    }

    @Override
    public long allocatorCapacity() {
        return this.allocator.capacity();
    }

    private List<FieldWriter> makeFieldWriters(ColumnSelectorFactory columnSelectorFactory) {
        ArrayList<FieldWriter> fieldWriters = new ArrayList<FieldWriter>();
        try {
            for (int i = 0; i < this.signature.size(); ++i) {
                String column = this.signature.getColumnName(i);
                ColumnType columnType = this.signature.getColumnType(i).orElse(null);
                fieldWriters.add(FieldWriters.create(columnSelectorFactory, column, columnType));
            }
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch((Throwable)e, () -> CloseableUtils.closeAll((Iterable)fieldWriters));
        }
        return fieldWriters;
    }
}

