/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.HashJoinEngine;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.PostJoinCursor;
import org.apache.druid.segment.join.filter.JoinFilterAnalyzer;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysisKey;
import org.apache.druid.segment.join.filter.JoinFilterSplit;
import org.apache.druid.segment.vector.VectorCursor;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class HashJoinSegmentStorageAdapter
implements StorageAdapter {
    private final StorageAdapter baseAdapter;
    @Nullable
    private final Filter baseFilter;
    private final List<JoinableClause> clauses;
    private final JoinFilterPreAnalysis joinFilterPreAnalysis;

    HashJoinSegmentStorageAdapter(StorageAdapter baseAdapter, List<JoinableClause> clauses, JoinFilterPreAnalysis joinFilterPreAnalysis) {
        this(baseAdapter, null, clauses, joinFilterPreAnalysis);
    }

    HashJoinSegmentStorageAdapter(StorageAdapter baseAdapter, @Nullable Filter baseFilter, List<JoinableClause> clauses, JoinFilterPreAnalysis joinFilterPreAnalysis) {
        this.baseAdapter = baseAdapter;
        this.baseFilter = baseFilter;
        this.clauses = clauses;
        this.joinFilterPreAnalysis = joinFilterPreAnalysis;
    }

    @Override
    public Interval getInterval() {
        return this.baseAdapter.getInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        LinkedHashSet<String> availableDimensions = new LinkedHashSet<String>();
        this.baseAdapter.getAvailableDimensions().forEach(availableDimensions::add);
        for (JoinableClause clause : this.clauses) {
            availableDimensions.addAll(clause.getAvailableColumnsPrefixed());
        }
        return new ListIndexed<String>(Lists.newArrayList(availableDimensions));
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return this.baseAdapter.getAvailableMetrics();
    }

    @Override
    public int getDimensionCardinality(String column) {
        Optional<JoinableClause> maybeClause = this.getClauseForColumn(column);
        if (maybeClause.isPresent()) {
            JoinableClause clause = maybeClause.get();
            return clause.getJoinable().getCardinality(clause.unprefix(column));
        }
        return this.baseAdapter.getDimensionCardinality(column);
    }

    @Override
    public DateTime getMinTime() {
        return this.baseAdapter.getMinTime();
    }

    @Override
    public DateTime getMaxTime() {
        return this.baseAdapter.getMaxTime();
    }

    @Override
    @Nullable
    public Comparable getMinValue(String column) {
        if (this.isBaseColumn(column)) {
            return this.baseAdapter.getMinValue(column);
        }
        return null;
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String column) {
        if (this.isBaseColumn(column)) {
            return this.baseAdapter.getMaxValue(column);
        }
        return null;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        Optional<JoinableClause> maybeClause = this.getClauseForColumn(column);
        if (maybeClause.isPresent()) {
            JoinableClause clause = maybeClause.get();
            return clause.getJoinable().getColumnCapabilities(clause.unprefix(column));
        }
        return this.baseAdapter.getColumnCapabilities(column);
    }

    @Override
    public int getNumRows() {
        throw new UnsupportedOperationException("Cannot retrieve number of rows from join segment");
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.baseAdapter.getMaxIngestedEventTime();
    }

    @Override
    public Metadata getMetadata() {
        throw new UnsupportedOperationException("Cannot retrieve metadata from join segment");
    }

    @Override
    public boolean hasBuiltInFilters() {
        return this.baseFilter != null || this.clauses.stream().anyMatch(clause -> clause.getJoinType() == JoinType.INNER && !clause.getCondition().isAlwaysTrue());
    }

    @Override
    public boolean canVectorize(@Nullable Filter filter, VirtualColumns virtualColumns, boolean descending) {
        return this.clauses.isEmpty() && this.baseAdapter.canVectorize(this.baseFilterAnd(filter), virtualColumns, descending);
    }

    @Override
    @Nullable
    public VectorCursor makeVectorCursor(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, boolean descending, int vectorSize, @Nullable QueryMetrics<?> queryMetrics) {
        if (!this.canVectorize(filter, virtualColumns, descending)) {
            throw new ISE("Cannot vectorize. Check 'canVectorize' before calling 'makeVectorCursor'.", new Object[0]);
        }
        assert (this.clauses.isEmpty());
        return this.baseAdapter.makeVectorCursor(this.baseFilterAnd(filter), interval, virtualColumns, descending, vectorSize, queryMetrics);
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, @Nonnull Interval interval, @Nonnull VirtualColumns virtualColumns, @Nonnull Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        JoinFilterPreAnalysisKey keyCached;
        Filter combinedFilter = this.baseFilterAnd(filter);
        if (this.clauses.isEmpty()) {
            return this.baseAdapter.makeCursors(combinedFilter, interval, virtualColumns, gran, descending, queryMetrics);
        }
        JoinFilterPreAnalysisKey keyIn = new JoinFilterPreAnalysisKey(this.joinFilterPreAnalysis.getKey().getRewriteConfig(), this.clauses, virtualColumns, combinedFilter);
        if (!keyIn.equals(keyCached = this.joinFilterPreAnalysis.getKey())) {
            throw new ISE("Pre-analysis mismatch, cannot execute query", new Object[0]);
        }
        ArrayList<VirtualColumn> preJoinVirtualColumns = new ArrayList<VirtualColumn>();
        ArrayList<VirtualColumn> postJoinVirtualColumns = new ArrayList<VirtualColumn>();
        this.determineBaseColumnsWithPreAndPostJoinVirtualColumns(virtualColumns, preJoinVirtualColumns, postJoinVirtualColumns);
        JoinFilterSplit joinFilterSplit = JoinFilterAnalyzer.splitFilter(this.joinFilterPreAnalysis, this.baseFilter);
        preJoinVirtualColumns.addAll(joinFilterSplit.getPushDownVirtualColumns());
        Sequence<Cursor> baseCursorSequence = this.baseAdapter.makeCursors(joinFilterSplit.getBaseTableFilter().isPresent() ? joinFilterSplit.getBaseTableFilter().get() : null, interval, VirtualColumns.create(preJoinVirtualColumns), gran, descending, queryMetrics);
        Closer joinablesCloser = Closer.create();
        return Sequences.map(baseCursorSequence, cursor -> {
            assert (cursor != null);
            Cursor retVal = cursor;
            for (JoinableClause clause : this.clauses) {
                retVal = HashJoinEngine.makeJoinCursor(retVal, clause, descending, joinablesCloser);
            }
            return PostJoinCursor.wrap(retVal, VirtualColumns.create(postJoinVirtualColumns), joinFilterSplit.getJoinTableFilter().orElse(null));
        }).withBaggage((Closeable)joinablesCloser);
    }

    public boolean isBaseColumn(String column) {
        return !this.getClauseForColumn(column).isPresent();
    }

    public Set<String> determineBaseColumnsWithPreAndPostJoinVirtualColumns(VirtualColumns virtualColumns, @Nullable List<VirtualColumn> preJoinVirtualColumns, @Nullable List<VirtualColumn> postJoinVirtualColumns) {
        HashSet<String> baseColumns = new HashSet<String>(this.baseAdapter.getRowSignature().getColumnNames());
        for (VirtualColumn virtualColumn : virtualColumns.getVirtualColumns()) {
            if (baseColumns.containsAll(virtualColumn.requiredColumns())) {
                baseColumns.add(virtualColumn.getOutputName());
                if (preJoinVirtualColumns == null) continue;
                preJoinVirtualColumns.add(virtualColumn);
                continue;
            }
            if (postJoinVirtualColumns == null) continue;
            postJoinVirtualColumns.add(virtualColumn);
        }
        return baseColumns;
    }

    private Optional<JoinableClause> getClauseForColumn(String column) {
        return Lists.reverse(this.clauses).stream().filter(clause -> clause.includesColumn(column)).findFirst();
    }

    @Nullable
    private Filter baseFilterAnd(@Nullable Filter other) {
        return Filters.maybeAnd(Arrays.asList(this.baseFilter, other)).orElse(null);
    }
}

