/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ByteBufferWriter;
import org.apache.druid.segment.data.ColumnarDoublesSerializer;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.FixedIndexedIntWriter;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.data.VSizeColumnarIntsSerializer;
import org.apache.druid.segment.nested.GlobalDictionaryIdLookup;
import org.apache.druid.segment.nested.LocalDimensionDictionary;
import org.apache.druid.segment.nested.NestedDataColumnMetadata;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataProcessor;
import org.apache.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class NestedDataColumnSerializer
implements GenericColumnSerializer<StructuredData> {
    private static final Logger log = new Logger(NestedDataColumnSerializer.class);
    public static final IntTypeStrategy INT_TYPE_STRATEGY = new IntTypeStrategy();
    public static final String STRING_DICTIONARY_FILE_NAME = "__stringDictionary";
    public static final String LONG_DICTIONARY_FILE_NAME = "__longDictionary";
    public static final String DOUBLE_DICTIONARY_FILE_NAME = "__doubleDictionary";
    public static final String RAW_FILE_NAME = "__raw";
    public static final String NULL_BITMAP_FILE_NAME = "__nullIndex";
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final IndexSpec indexSpec;
    private final Closer closer;
    private final StructuredDataProcessor fieldProcessor = new StructuredDataProcessor(){

        @Override
        public int processLiteralField(String fieldName, Object fieldValue) {
            GlobalDictionaryEncodedFieldColumnWriter writer = (GlobalDictionaryEncodedFieldColumnWriter)NestedDataColumnSerializer.this.fieldWriters.get(fieldName);
            if (writer != null) {
                try {
                    ExprEval eval = ExprEval.bestEffortOf((Object)fieldValue);
                    writer.addValue(eval.value());
                    return 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(":(");
                }
            }
            return 0;
        }
    };
    private byte[] metadataBytes;
    private GlobalDictionaryIdLookup globalDictionaryIdLookup;
    private SortedMap<String, NestedLiteralTypeInfo.MutableTypeSet> fields;
    private GenericIndexedWriter<String> fieldsWriter;
    private NestedLiteralTypeInfo.Writer fieldsInfoWriter;
    private GenericIndexedWriter<String> dictionaryWriter;
    private FixedIndexedWriter<Long> longDictionaryWriter;
    private FixedIndexedWriter<Double> doubleDictionaryWriter;
    private CompressedVariableSizedBlobColumnSerializer rawWriter;
    private ByteBufferWriter<ImmutableBitmap> nullBitmapWriter;
    private MutableBitmap nullRowsBitmap;
    private Map<String, GlobalDictionaryEncodedFieldColumnWriter<?>> fieldWriters;
    private int rowCount = 0;
    private boolean closedForWrite = false;

    public NestedDataColumnSerializer(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ProgressIndicator progressIndicator, Closer closer) {
        this.name = name;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.closer = closer;
        this.globalDictionaryIdLookup = new GlobalDictionaryIdLookup();
    }

    @Override
    public void open() throws IOException {
        this.fieldsWriter = this.createGenericIndexedWriter(GenericIndexed.STRING_STRATEGY, this.segmentWriteOutMedium);
        this.fieldsInfoWriter = new NestedLiteralTypeInfo.Writer(this.segmentWriteOutMedium);
        this.fieldsInfoWriter.open();
        this.dictionaryWriter = this.createGenericIndexedWriter(GenericIndexed.STRING_STRATEGY, this.segmentWriteOutMedium);
        this.longDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.LONG.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.longDictionaryWriter.open();
        this.doubleDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.DOUBLE.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.doubleDictionaryWriter.open();
        this.rawWriter = new CompressedVariableSizedBlobColumnSerializer(NestedDataColumnSerializer.getInternalFileName(this.name, RAW_FILE_NAME), this.segmentWriteOutMedium, this.indexSpec.getJsonCompression() != null ? this.indexSpec.getJsonCompression() : CompressionStrategy.LZ4);
        this.rawWriter.open();
        this.nullBitmapWriter = new ByteBufferWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.nullBitmapWriter.open();
        this.nullRowsBitmap = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
    }

    public void serializeFields(SortedMap<String, NestedLiteralTypeInfo.MutableTypeSet> fields) throws IOException {
        this.fields = fields;
        this.fieldWriters = Maps.newHashMapWithExpectedSize((int)fields.size());
        for (Map.Entry<String, NestedLiteralTypeInfo.MutableTypeSet> field : fields.entrySet()) {
            this.fieldsWriter.write(field.getKey());
            this.fieldsInfoWriter.write(field.getValue());
            ColumnType type = field.getValue().getSingleType();
            GlobalDictionaryEncodedFieldColumnWriter writer = type != null ? (Types.is((TypeSignature)type, (TypeDescriptor)ValueType.STRING) ? new StringFieldColumnWriter() : (Types.is((TypeSignature)type, (TypeDescriptor)ValueType.LONG) ? new LongFieldColumnWriter() : new DoubleFieldColumnWriter())) : new VariantLiteralFieldColumnWriter();
            writer.open();
            this.fieldWriters.put(field.getKey(), writer);
        }
    }

    public void serializeStringDictionary(Iterable<String> dictionaryValues) throws IOException {
        this.dictionaryWriter.write(null);
        this.globalDictionaryIdLookup.addString(null);
        for (String value : dictionaryValues) {
            if (NullHandling.emptyToNullIfNeeded((String)value) == null) continue;
            this.dictionaryWriter.write(value);
            value = NullHandling.emptyToNullIfNeeded((String)value);
            this.globalDictionaryIdLookup.addString(value);
        }
    }

    public void serializeLongDictionary(Iterable<Long> dictionaryValues) throws IOException {
        for (Long value : dictionaryValues) {
            if (value == null) continue;
            this.longDictionaryWriter.write(value);
            this.globalDictionaryIdLookup.addLong(value);
        }
    }

    public void serializeDoubleDictionary(Iterable<Double> dictionaryValues) throws IOException {
        for (Double value : dictionaryValues) {
            if (value == null) continue;
            this.doubleDictionaryWriter.write(value);
            this.globalDictionaryIdLookup.addDouble(value);
        }
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        StructuredData data = (StructuredData)selector.getObject();
        if (data == null) {
            this.nullRowsBitmap.add(this.rowCount);
        }
        this.rawWriter.addValue(NestedDataComplexTypeSerde.INSTANCE.toBytes(data));
        if (data != null) {
            StructuredDataProcessor.ProcessResults processed = this.fieldProcessor.processFields(data.getValue());
            Set<String> set = processed.getLiteralFields();
            for (String field : this.fields.keySet()) {
                if (set.contains(field)) continue;
                this.fieldWriters.get(field).addValue(null);
            }
        } else {
            for (String field : this.fields.keySet()) {
                this.fieldWriters.get(field).addValue(null);
            }
        }
        ++this.rowCount;
    }

    @Override
    public long getSerializedSize() throws IOException {
        if (!this.closedForWrite) {
            this.closedForWrite = true;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IndexMerger.SERIALIZER_UTILS.writeString((OutputStream)baos, NestedDataComplexTypeSerde.OBJECT_MAPPER.writeValueAsString((Object)new NestedDataColumnMetadata(ByteOrder.nativeOrder(), this.indexSpec.getBitmapSerdeFactory(), this.name, !this.nullRowsBitmap.isEmpty())));
            this.metadataBytes = baos.toByteArray();
            this.nullBitmapWriter.write(this.nullRowsBitmap);
        }
        long size = 1L;
        size += (long)this.metadataBytes.length;
        if (this.fieldsWriter != null) {
            size += this.fieldsWriter.getSerializedSize();
        }
        if (this.fieldsInfoWriter != null) {
            size += this.fieldsInfoWriter.getSerializedSize();
        }
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        channel.write(ByteBuffer.wrap(new byte[]{3}));
        channel.write(ByteBuffer.wrap(this.metadataBytes));
        this.fieldsWriter.writeTo(channel, smoosher);
        this.fieldsInfoWriter.writeTo(channel, smoosher);
        this.writeInternal(smoosher, this.dictionaryWriter, STRING_DICTIONARY_FILE_NAME);
        this.writeInternal(smoosher, this.longDictionaryWriter, LONG_DICTIONARY_FILE_NAME);
        this.writeInternal(smoosher, this.doubleDictionaryWriter, DOUBLE_DICTIONARY_FILE_NAME);
        this.writeInternal(smoosher, this.rawWriter, RAW_FILE_NAME);
        if (!this.nullRowsBitmap.isEmpty()) {
            this.writeInternal(smoosher, this.nullBitmapWriter, NULL_BITMAP_FILE_NAME);
        }
        if (channel instanceof SmooshedWriter) {
            channel.close();
        }
        for (Map.Entry<String, NestedLiteralTypeInfo.MutableTypeSet> field : this.fields.entrySet()) {
            GlobalDictionaryEncodedFieldColumnWriter<?> writer = this.fieldWriters.remove(field.getKey());
            writer.writeTo(field.getKey(), smoosher);
        }
        log.info("Column [%s] serialized successfully with [%d] nested columns.", new Object[]{this.name, this.fields.size()});
    }

    private void writeInternal(FileSmoosher smoosher, Serializer serializer, String fileName) throws IOException {
        String internalName = NestedDataColumnSerializer.getInternalFileName(this.name, fileName);
        try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(internalName, serializer.getSerializedSize());){
            serializer.writeTo((WritableByteChannel)smooshChannel, smoosher);
        }
    }

    private <T> GenericIndexedWriter<T> createGenericIndexedWriter(ObjectStrategy<T> objectStrategy, SegmentWriteOutMedium writeOutMedium) throws IOException {
        GenericIndexedWriter<T> writer = new GenericIndexedWriter<T>(writeOutMedium, this.name, objectStrategy);
        writer.open();
        return writer;
    }

    public static String getFieldFileName(String fileNameBase, String field) {
        return StringUtils.format((String)"%s_%s", (Object[])new Object[]{fileNameBase, field});
    }

    public static String getInternalFileName(String fileNameBase, String field) {
        return StringUtils.format((String)"%s.%s", (Object[])new Object[]{fileNameBase, field});
    }

    private static final class IntTypeStrategy
    implements TypeStrategy<Integer> {
        private IntTypeStrategy() {
        }

        public int estimateSizeBytes(Integer value) {
            return 4;
        }

        public Integer read(ByteBuffer buffer) {
            return buffer.getInt();
        }

        public boolean readRetainsBufferReference() {
            return false;
        }

        public int write(ByteBuffer buffer, Integer value, int maxSizeBytes) {
            TypeStrategies.checkMaxSize((int)buffer.remaining(), (int)maxSizeBytes, (TypeSignature)ColumnType.LONG);
            int sizeBytes = 4;
            int remaining = maxSizeBytes - 4;
            if (remaining >= 0) {
                buffer.putInt(value);
                return 4;
            }
            return remaining;
        }

        public int compare(Integer o1, Integer o2) {
            return Integer.compare(o1, o2);
        }
    }

    private final class VariantLiteralFieldColumnWriter
    extends GlobalDictionaryEncodedFieldColumnWriter<Object> {
        private VariantLiteralFieldColumnWriter() {
        }

        @Override
        int lookupGlobalId(Object value) {
            if (value == null) {
                return 0;
            }
            if (value instanceof Long) {
                return NestedDataColumnSerializer.this.globalDictionaryIdLookup.lookupLong((Long)value);
            }
            if (value instanceof Double) {
                return NestedDataColumnSerializer.this.globalDictionaryIdLookup.lookupDouble((Double)value);
            }
            return NestedDataColumnSerializer.this.globalDictionaryIdLookup.lookupString(String.valueOf(value));
        }

        @Override
        void writeColumnTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
            this.writeLongAndDoubleColumnLength(channel, 0, 0);
            this.encodedValueSerializer.writeTo(channel, smoosher);
        }
    }

    private final class DoubleFieldColumnWriter
    extends GlobalDictionaryEncodedFieldColumnWriter<Double> {
        private ColumnarDoublesSerializer doublesSerializer;

        private DoubleFieldColumnWriter() {
        }

        @Override
        int lookupGlobalId(Double value) {
            return NestedDataColumnSerializer.this.globalDictionaryIdLookup.lookupDouble(value);
        }

        @Override
        void openColumnSerializer(String field, SegmentWriteOutMedium medium, int maxId) throws IOException {
            super.openColumnSerializer(field, medium, maxId);
            this.doublesSerializer = CompressionFactory.getDoubleSerializer(field, medium, StringUtils.format((String)"%s.double_column", (Object[])new Object[]{NestedDataColumnSerializer.this.name}), ByteOrder.nativeOrder(), NestedDataColumnSerializer.this.indexSpec.getDimensionCompression());
            this.doublesSerializer.open();
        }

        @Override
        void serializeRow(int globalId, int localId) throws IOException {
            super.serializeRow(globalId, localId);
            Double d = NestedDataColumnSerializer.this.globalDictionaryIdLookup.lookupDouble(globalId);
            if (d == null) {
                this.doublesSerializer.add(0.0);
            } else {
                this.doublesSerializer.add(d);
            }
        }

        @Override
        void writeColumnTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
            this.writeLongAndDoubleColumnLength(channel, 0, Ints.checkedCast((long)this.doublesSerializer.getSerializedSize()));
            this.doublesSerializer.writeTo(channel, smoosher);
            this.encodedValueSerializer.writeTo(channel, smoosher);
        }

        @Override
        long getSerializedColumnSize() throws IOException {
            return super.getSerializedColumnSize() + this.doublesSerializer.getSerializedSize();
        }
    }

    private final class LongFieldColumnWriter
    extends GlobalDictionaryEncodedFieldColumnWriter<Long> {
        private ColumnarLongsSerializer longsSerializer;

        private LongFieldColumnWriter() {
        }

        @Override
        int lookupGlobalId(Long value) {
            return NestedDataColumnSerializer.this.globalDictionaryIdLookup.lookupLong(value);
        }

        @Override
        void openColumnSerializer(String field, SegmentWriteOutMedium medium, int maxId) throws IOException {
            super.openColumnSerializer(field, medium, maxId);
            this.longsSerializer = CompressionFactory.getLongSerializer(field, medium, StringUtils.format((String)"%s.long_column", (Object[])new Object[]{NestedDataColumnSerializer.this.name}), ByteOrder.nativeOrder(), NestedDataColumnSerializer.this.indexSpec.getLongEncoding(), NestedDataColumnSerializer.this.indexSpec.getDimensionCompression());
            this.longsSerializer.open();
        }

        @Override
        void serializeRow(int globalId, int localId) throws IOException {
            super.serializeRow(globalId, localId);
            Long l = NestedDataColumnSerializer.this.globalDictionaryIdLookup.lookupLong(globalId);
            if (l == null) {
                this.longsSerializer.add(0L);
            } else {
                this.longsSerializer.add(l);
            }
        }

        @Override
        void writeColumnTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
            this.writeLongAndDoubleColumnLength(channel, Ints.checkedCast((long)this.longsSerializer.getSerializedSize()), 0);
            this.longsSerializer.writeTo(channel, smoosher);
            this.encodedValueSerializer.writeTo(channel, smoosher);
        }

        @Override
        long getSerializedColumnSize() throws IOException {
            return super.getSerializedColumnSize() + this.longsSerializer.getSerializedSize();
        }
    }

    private final class StringFieldColumnWriter
    extends GlobalDictionaryEncodedFieldColumnWriter<String> {
        private StringFieldColumnWriter() {
        }

        @Override
        String processValue(Object value) {
            return String.valueOf(value);
        }

        @Override
        int lookupGlobalId(String value) {
            return NestedDataColumnSerializer.this.globalDictionaryIdLookup.lookupString(value);
        }

        @Override
        void writeColumnTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
            this.writeLongAndDoubleColumnLength(channel, 0, 0);
            this.encodedValueSerializer.writeTo(channel, smoosher);
        }
    }

    abstract class GlobalDictionaryEncodedFieldColumnWriter<T> {
        protected final LocalDimensionDictionary localDictionary = new LocalDimensionDictionary();
        protected FixedIndexedIntWriter intermediateValueWriter;
        protected int flags = 0;
        protected DictionaryEncodedColumnPartSerde.VERSION version = null;
        protected SingleValueColumnarIntsSerializer encodedValueSerializer;

        GlobalDictionaryEncodedFieldColumnWriter() {
        }

        T processValue(Object value) {
            return (T)value;
        }

        abstract int lookupGlobalId(T var1);

        abstract void writeColumnTo(WritableByteChannel var1, FileSmoosher var2) throws IOException;

        void openColumnSerializer(String field, SegmentWriteOutMedium medium, int maxId) throws IOException {
            if (NestedDataColumnSerializer.this.indexSpec.getDimensionCompression() != CompressionStrategy.UNCOMPRESSED) {
                this.version = DictionaryEncodedColumnPartSerde.VERSION.COMPRESSED;
                this.encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(field, medium, NestedDataColumnSerializer.this.name, maxId, NestedDataColumnSerializer.this.indexSpec.getDimensionCompression());
            } else {
                this.encodedValueSerializer = new VSizeColumnarIntsSerializer(medium, maxId);
                this.version = DictionaryEncodedColumnPartSerde.VERSION.UNCOMPRESSED_SINGLE_VALUE;
            }
            this.encodedValueSerializer.open();
        }

        void serializeRow(int globalId, int localId) throws IOException {
            this.encodedValueSerializer.addValue(localId);
        }

        long getSerializedColumnSize() throws IOException {
            return 8L + this.encodedValueSerializer.getSerializedSize();
        }

        public void open() throws IOException {
            this.intermediateValueWriter = new FixedIndexedIntWriter(NestedDataColumnSerializer.this.segmentWriteOutMedium, false);
            this.intermediateValueWriter.open();
        }

        public void writeLongAndDoubleColumnLength(WritableByteChannel channel, int longLength, int doubleLength) throws IOException {
            ByteBuffer intBuffer = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
            intBuffer.position(0);
            intBuffer.putInt(longLength);
            intBuffer.flip();
            Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)intBuffer);
            intBuffer.position(0);
            intBuffer.limit(intBuffer.capacity());
            intBuffer.putInt(doubleLength);
            intBuffer.flip();
            Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)intBuffer);
        }

        public void addValue(Object val) throws IOException {
            T value = this.processValue(val);
            int globalId = this.lookupGlobalId(value);
            int localId = this.localDictionary.add(globalId);
            this.intermediateValueWriter.write(localId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(String field, FileSmoosher smoosher) throws IOException {
            SegmentWriteOutMedium tmpWriteoutMedium = NestedDataColumnSerializer.this.segmentWriteOutMedium.makeChildWriteOutMedium();
            final FixedIndexedIntWriter sortedDictionaryWriter = new FixedIndexedIntWriter(tmpWriteoutMedium, true);
            sortedDictionaryWriter.open();
            final GenericIndexedWriter bitmapIndexWriter = NestedDataColumnSerializer.this.createGenericIndexedWriter(NestedDataColumnSerializer.this.indexSpec.getBitmapSerdeFactory().getObjectStrategy(), tmpWriteoutMedium);
            bitmapIndexWriter.setObjectsNotSorted();
            Int2IntOpenHashMap globalToUnsorted = this.localDictionary.getGlobalIdToLocalId();
            int[] unsortedToGlobal = new int[this.localDictionary.size()];
            IntIterator intIterator = globalToUnsorted.keySet().iterator();
            while (intIterator.hasNext()) {
                int key;
                unsortedToGlobal[globalToUnsorted.get((int)key)] = key = ((Integer)intIterator.next()).intValue();
            }
            int[] sortedGlobal = new int[unsortedToGlobal.length];
            System.arraycopy(unsortedToGlobal, 0, sortedGlobal, 0, unsortedToGlobal.length);
            IntArrays.unstableSort((int[])sortedGlobal);
            int[] unsortedToSorted = new int[unsortedToGlobal.length];
            MutableBitmap[] bitmaps = new MutableBitmap[sortedGlobal.length];
            for (int index = 0; index < sortedGlobal.length; ++index) {
                int globalId = sortedGlobal[index];
                sortedDictionaryWriter.write(globalId);
                int unsortedId = globalToUnsorted.get(globalId);
                unsortedToSorted[unsortedId] = index;
                bitmaps[index] = NestedDataColumnSerializer.this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
            }
            this.openColumnSerializer(field, tmpWriteoutMedium, sortedGlobal[sortedGlobal.length - 1]);
            IntIterator rows = this.intermediateValueWriter.getIterator();
            int rowCount = 0;
            while (rows.hasNext()) {
                int unsortedLocalId = rows.nextInt();
                int globalId = unsortedToGlobal[unsortedLocalId];
                int sortedLocalId = unsortedToSorted[unsortedLocalId];
                this.serializeRow(globalId, sortedLocalId);
                bitmaps[sortedLocalId].add(rowCount++);
            }
            for (MutableBitmap bitmap : bitmaps) {
                bitmapIndexWriter.write(NestedDataColumnSerializer.this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap(bitmap));
            }
            Serializer fieldSerializer = new Serializer(){

                @Override
                public long getSerializedSize() throws IOException {
                    return 5L + sortedDictionaryWriter.getSerializedSize() + bitmapIndexWriter.getSerializedSize() + GlobalDictionaryEncodedFieldColumnWriter.this.getSerializedColumnSize();
                }

                @Override
                public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                    Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)ByteBuffer.wrap(new byte[]{GlobalDictionaryEncodedFieldColumnWriter.this.version.asByte()}));
                    channel.write(ByteBuffer.wrap(Ints.toByteArray((int)GlobalDictionaryEncodedFieldColumnWriter.this.flags)));
                    sortedDictionaryWriter.writeTo(channel, smoosher);
                    GlobalDictionaryEncodedFieldColumnWriter.this.writeColumnTo(channel, smoosher);
                    bitmapIndexWriter.writeTo(channel, smoosher);
                }
            };
            String fieldName = NestedDataColumnSerializer.getFieldFileName(NestedDataColumnSerializer.this.name, field);
            long size = fieldSerializer.getSerializedSize();
            log.debug("Column [%s] serializing [%s] field of size [%d].", new Object[]{NestedDataColumnSerializer.this.name, field, size});
            try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(fieldName, size);){
                fieldSerializer.writeTo((WritableByteChannel)smooshChannel, smoosher);
            }
            finally {
                tmpWriteoutMedium.close();
            }
        }
    }
}

