/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.io.Closeable;
import java.io.IOException;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorSelectorUtils;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.utils.CloseableUtils;
import org.roaringbitmap.PeekableIntIterator;

public class NestedFieldLiteralDictionaryEncodedColumn
implements DictionaryEncodedColumn<String> {
    private final NestedLiteralTypeInfo.TypeSet types;
    @Nullable
    private final ColumnType singleType;
    private final ColumnarLongs longsColumn;
    private final ColumnarDoubles doublesColumn;
    private final ColumnarInts column;
    private final GenericIndexed<String> globalDictionary;
    private final FixedIndexed<Long> globalLongDictionary;
    private final FixedIndexed<Double> globalDoubleDictionary;
    private final FixedIndexed<Integer> dictionary;
    private final ImmutableBitmap nullBitmap;
    private final int adjustLongId;
    private final int adjustDoubleId;

    public NestedFieldLiteralDictionaryEncodedColumn(NestedLiteralTypeInfo.TypeSet types, ColumnarLongs longsColumn, ColumnarDoubles doublesColumn, ColumnarInts column, GenericIndexed<String> globalDictionary, FixedIndexed<Long> globalLongDictionary, FixedIndexed<Double> globalDoubleDictionary, FixedIndexed<Integer> dictionary, ImmutableBitmap nullBitmap) {
        this.types = types;
        this.singleType = types.getSingleType();
        this.longsColumn = longsColumn;
        this.doublesColumn = doublesColumn;
        this.column = column;
        this.globalDictionary = globalDictionary;
        this.globalLongDictionary = globalLongDictionary;
        this.globalDoubleDictionary = globalDoubleDictionary;
        this.dictionary = dictionary;
        this.nullBitmap = nullBitmap;
        this.adjustLongId = globalDictionary.size();
        this.adjustDoubleId = this.adjustLongId + globalLongDictionary.size();
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return false;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        throw new IllegalStateException("Multi-value row not supported");
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        int globalId = this.dictionary.get(id);
        if (globalId < this.globalDictionary.size()) {
            return this.globalDictionary.get(globalId);
        }
        if (globalId < this.adjustLongId + this.globalLongDictionary.size()) {
            return String.valueOf(this.globalLongDictionary.get(globalId - this.adjustLongId));
        }
        return String.valueOf(this.globalDoubleDictionary.get(globalId - this.adjustDoubleId));
    }

    @Override
    public int lookupId(String name) {
        return this.dictionary.indexOf(this.getIdFromGlobalDictionary(name));
    }

    @Override
    public int getCardinality() {
        return this.dictionary.size();
    }

    private int getIdFromGlobalDictionary(@Nullable String val) {
        if (val == null) {
            return 0;
        }
        if (this.singleType != null) {
            switch ((ValueType)this.singleType.getType()) {
                case LONG: {
                    return this.globalLongDictionary.indexOf(GuavaUtils.tryParseLong((String)val));
                }
                case DOUBLE: {
                    return this.globalDoubleDictionary.indexOf(Doubles.tryParse((String)val));
                }
            }
            return this.globalDictionary.indexOf(val);
        }
        int candidate = this.globalDictionary.indexOf(val);
        if (candidate < 0) {
            candidate = this.globalLongDictionary.indexOf(GuavaUtils.tryParseLong((String)val));
        }
        if (candidate < 0) {
            candidate = this.globalDoubleDictionary.indexOf(Doubles.tryParse((String)val));
        }
        return candidate;
    }

    @Override
    public DimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
        class StringDimensionSelector
        extends AbstractDimensionSelector
        implements SingleValueHistoricalDimensionSelector,
        IdLookup {
            private final SingleIndexedInt row = new SingleIndexedInt();

            StringDimensionSelector() {
            }

            @Override
            public IndexedInts getRow() {
                this.row.setValue(this.getRowValue());
                return this.row;
            }

            public int getRowValue() {
                return NestedFieldLiteralDictionaryEncodedColumn.this.column.get(offset.getOffset());
            }

            @Override
            public float getFloat() {
                int localId = this.getRowValue();
                int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                if (globalId == 0) {
                    assert (NullHandling.replaceWithDefault());
                    return 0.0f;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                    Float f = Floats.tryParse((String)((String)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                    return f == null ? 0.0f : f.floatValue();
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                    return ((Long)NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId)).floatValue();
                }
                return ((Double)NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId)).floatValue();
            }

            @Override
            public double getDouble() {
                int localId = this.getRowValue();
                int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                if (globalId == 0) {
                    assert (NullHandling.replaceWithDefault());
                    return 0.0;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                    Double d = Doubles.tryParse((String)((String)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                    return d == null ? 0.0 : d;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                    return ((Long)NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId)).doubleValue();
                }
                return (Double)NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId);
            }

            @Override
            public long getLong() {
                int localId = this.getRowValue();
                int globalId = (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(localId);
                if (globalId == 0) {
                    assert (NullHandling.replaceWithDefault());
                    return 0L;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId) {
                    Long l = GuavaUtils.tryParseLong((String)((String)NestedFieldLiteralDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                    return l == null ? 0L : l;
                }
                if (globalId < NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId) {
                    return (Long)NestedFieldLiteralDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustLongId);
                }
                return ((Double)NestedFieldLiteralDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldLiteralDictionaryEncodedColumn.this.adjustDoubleId)).longValue();
            }

            @Override
            public boolean isNull() {
                return (Integer)NestedFieldLiteralDictionaryEncodedColumn.this.dictionary.get(this.getRowValue()) == 0;
            }

            @Override
            public IndexedInts getRow(int offset2) {
                this.row.setValue(this.getRowValue(offset2));
                return this.row;
            }

            @Override
            public int getRowValue(int offset2) {
                return NestedFieldLiteralDictionaryEncodedColumn.this.column.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (extractionFn == null) {
                    final int valueId = this.lookupId(value);
                    if (valueId >= 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches() {
                                return this.getRowValue() == valueId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", NestedFieldLiteralDictionaryEncodedColumn.this);
                            }
                        };
                    }
                    return BooleanValueMatcher.of(false);
                }
                return this.makeValueMatcher((Predicate<String>)Predicates.equalTo((Object)value));
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final BitSet checkedIds = new BitSet(NestedFieldLiteralDictionaryEncodedColumn.this.getCardinality());
                final BitSet matchingIds = new BitSet(NestedFieldLiteralDictionaryEncodedColumn.this.getCardinality());
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        int id = this.getRowValue();
                        if (checkedIds.get(id)) {
                            return matchingIds.get(id);
                        }
                        boolean matches = predicate.apply((Object)this.lookupName(id));
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                        return matches;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", NestedFieldLiteralDictionaryEncodedColumn.this);
                    }
                };
            }

            @Override
            public Object getObject() {
                return NestedFieldLiteralDictionaryEncodedColumn.this.lookupName(this.getRowValue());
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", NestedFieldLiteralDictionaryEncodedColumn.this.column);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }

            @Override
            public int getValueCardinality() {
                return NestedFieldLiteralDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            public String lookupName(int id) {
                String value = NestedFieldLiteralDictionaryEncodedColumn.this.lookupName(id);
                return extractionFn == null ? value : extractionFn.apply(value);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return extractionFn == null ? this : null;
            }

            @Override
            public int lookupId(String name) {
                if (extractionFn == null) {
                    return NestedFieldLiteralDictionaryEncodedColumn.this.lookupId(name);
                }
                throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
            }
        }
        return new StringDimensionSelector();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        if (this.singleType != null) {
            if (Types.is((TypeSignature)this.singleType, (TypeDescriptor)ValueType.LONG)) {
                return new LongColumnSelector(){
                    private PeekableIntIterator nullIterator;
                    private int nullMark;
                    private int offsetMark;
                    {
                        this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        this.nullMark = -1;
                        this.offsetMark = -1;
                    }

                    @Override
                    public long getLong() {
                        return NestedFieldLiteralDictionaryEncodedColumn.this.longsColumn.get(offset.getOffset());
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("longColumn", NestedFieldLiteralDictionaryEncodedColumn.this.longsColumn);
                        inspector.visit("nullBitmap", NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap);
                    }

                    @Override
                    public boolean isNull() {
                        int i = offset.getOffset();
                        if (i < this.offsetMark) {
                            this.nullMark = -1;
                            this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        }
                        this.offsetMark = i;
                        if (this.nullMark < i) {
                            this.nullIterator.advanceIfNeeded(this.offsetMark);
                            if (this.nullIterator.hasNext()) {
                                this.nullMark = this.nullIterator.next();
                            }
                        }
                        return this.nullMark == this.offsetMark;
                    }
                };
            }
            if (Types.is((TypeSignature)this.singleType, (TypeDescriptor)ValueType.DOUBLE)) {
                return new DoubleColumnSelector(){
                    private PeekableIntIterator nullIterator;
                    private int nullMark;
                    private int offsetMark;
                    {
                        this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        this.nullMark = -1;
                        this.offsetMark = -1;
                    }

                    @Override
                    public double getDouble() {
                        return NestedFieldLiteralDictionaryEncodedColumn.this.doublesColumn.get(offset.getOffset());
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("doubleColumn", NestedFieldLiteralDictionaryEncodedColumn.this.doublesColumn);
                        inspector.visit("nullBitmap", NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap);
                    }

                    @Override
                    public boolean isNull() {
                        int i = offset.getOffset();
                        if (i < this.offsetMark) {
                            this.nullMark = -1;
                            this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        }
                        this.offsetMark = i;
                        if (this.nullMark < i) {
                            this.nullIterator.advanceIfNeeded(this.offsetMark);
                            if (this.nullIterator.hasNext()) {
                                this.nullMark = this.nullIterator.next();
                            }
                        }
                        return this.nullMark == this.offsetMark;
                    }
                };
            }
        }
        return this.makeDimensionSelector(offset, null);
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        class QueryableSingleValueDimensionVectorSelector
        implements SingleValueDimensionVectorSelector,
        IdLookup {
            private final int[] vector;
            private int id;

            QueryableSingleValueDimensionVectorSelector() {
                this.vector = new int[offset.getMaxVectorSize()];
                this.id = -1;
            }

            @Override
            public int[] getRowVector() {
                if (this.id == offset.getId()) {
                    return this.vector;
                }
                if (offset.isContiguous()) {
                    NestedFieldLiteralDictionaryEncodedColumn.this.column.get(this.vector, offset.getStartOffset(), offset.getCurrentVectorSize());
                } else {
                    NestedFieldLiteralDictionaryEncodedColumn.this.column.get(this.vector, offset.getOffsets(), offset.getCurrentVectorSize());
                }
                this.id = offset.getId();
                return this.vector;
            }

            @Override
            public int getValueCardinality() {
                return NestedFieldLiteralDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return NestedFieldLiteralDictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return this;
            }

            @Override
            public int lookupId(@Nullable String name) {
                return NestedFieldLiteralDictionaryEncodedColumn.this.lookupId(name);
            }

            @Override
            public int getCurrentVectorSize() {
                return offset.getCurrentVectorSize();
            }

            @Override
            public int getMaxVectorSize() {
                return offset.getMaxVectorSize();
            }
        }
        return new QueryableSingleValueDimensionVectorSelector();
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(ReadableVectorOffset vectorOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        class DictionaryEncodedStringSingleValueVectorObjectSelector
        implements VectorObjectSelector {
            private final int[] vector;
            private final String[] strings;
            private int id;

            DictionaryEncodedStringSingleValueVectorObjectSelector() {
                this.vector = new int[offset.getMaxVectorSize()];
                this.strings = new String[offset.getMaxVectorSize()];
                this.id = -1;
            }

            @Override
            public Object[] getObjectVector() {
                if (this.id == offset.getId()) {
                    return this.strings;
                }
                if (offset.isContiguous()) {
                    NestedFieldLiteralDictionaryEncodedColumn.this.column.get(this.vector, offset.getStartOffset(), offset.getCurrentVectorSize());
                } else {
                    NestedFieldLiteralDictionaryEncodedColumn.this.column.get(this.vector, offset.getOffsets(), offset.getCurrentVectorSize());
                }
                for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                    this.strings[i] = NestedFieldLiteralDictionaryEncodedColumn.this.lookupName(this.vector[i]);
                }
                this.id = offset.getId();
                return this.strings;
            }

            @Override
            public int getMaxVectorSize() {
                return offset.getMaxVectorSize();
            }

            @Override
            public int getCurrentVectorSize() {
                return offset.getCurrentVectorSize();
            }
        }
        return new DictionaryEncodedStringSingleValueVectorObjectSelector();
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        if (this.singleType != null) {
            if (Types.is((TypeSignature)this.singleType, (TypeDescriptor)ValueType.LONG)) {
                return new BaseLongVectorValueSelector(offset){
                    private final long[] valueVector;
                    @Nullable
                    private boolean[] nullVector;
                    private int id;
                    @Nullable
                    private PeekableIntIterator nullIterator;
                    private int offsetMark;
                    {
                        this.valueVector = new long[this.offset.getMaxVectorSize()];
                        this.nullVector = null;
                        this.id = -1;
                        this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        this.offsetMark = -1;
                    }

                    @Override
                    public long[] getLongVector() {
                        this.computeVectorsIfNeeded();
                        return this.valueVector;
                    }

                    @Override
                    @Nullable
                    public boolean[] getNullVector() {
                        this.computeVectorsIfNeeded();
                        return this.nullVector;
                    }

                    private void computeVectorsIfNeeded() {
                        if (this.id == this.offset.getId()) {
                            return;
                        }
                        if (this.offset.isContiguous()) {
                            if (this.offset.getStartOffset() < this.offsetMark) {
                                this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                            NestedFieldLiteralDictionaryEncodedColumn.this.longsColumn.get(this.valueVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                        } else {
                            int[] offsets = this.offset.getOffsets();
                            if (offsets[offsets.length - 1] < this.offsetMark) {
                                this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = offsets[offsets.length - 1];
                            NestedFieldLiteralDictionaryEncodedColumn.this.longsColumn.get(this.valueVector, offsets, this.offset.getCurrentVectorSize());
                        }
                        this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                        this.id = this.offset.getId();
                    }
                };
            }
            if (Types.is((TypeSignature)this.singleType, (TypeDescriptor)ValueType.DOUBLE)) {
                return new BaseDoubleVectorValueSelector(offset){
                    private final double[] valueVector;
                    @Nullable
                    private boolean[] nullVector;
                    private int id;
                    @Nullable
                    private PeekableIntIterator nullIterator;
                    private int offsetMark;
                    {
                        this.valueVector = new double[this.offset.getMaxVectorSize()];
                        this.nullVector = null;
                        this.id = -1;
                        this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap != null ? NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator() : null;
                        this.offsetMark = -1;
                    }

                    @Override
                    public double[] getDoubleVector() {
                        this.computeVectorsIfNeeded();
                        return this.valueVector;
                    }

                    @Override
                    @Nullable
                    public boolean[] getNullVector() {
                        this.computeVectorsIfNeeded();
                        return this.nullVector;
                    }

                    private void computeVectorsIfNeeded() {
                        if (this.id == this.offset.getId()) {
                            return;
                        }
                        if (this.offset.isContiguous()) {
                            if (this.offset.getStartOffset() < this.offsetMark) {
                                this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                            NestedFieldLiteralDictionaryEncodedColumn.this.doublesColumn.get(this.valueVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                        } else {
                            int[] offsets = this.offset.getOffsets();
                            if (offsets[offsets.length - 1] < this.offsetMark) {
                                this.nullIterator = NestedFieldLiteralDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = offsets[offsets.length - 1];
                            NestedFieldLiteralDictionaryEncodedColumn.this.doublesColumn.get(this.valueVector, offsets, this.offset.getCurrentVectorSize());
                        }
                        this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                        this.id = this.offset.getId();
                    }
                };
            }
            throw new UOE("Cannot make vector value selector for [%s] typed nested field", new Object[]{this.types});
        }
        throw new UOE("Cannot make vector value selector for variant typed [%s] nested field", new Object[]{this.types});
    }

    @Override
    public void close() throws IOException {
        CloseableUtils.closeAll((Closeable)this.column, (Closeable[])new Closeable[]{this.longsColumn, this.doublesColumn});
    }
}

