/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class NestedLiteralTypeInfo {
    private static final byte STRING_MASK = 1;
    private static final byte LONG_MASK = 4;
    private static final byte DOUBLE_MASK = 8;
    private final ByteBuffer buffer;
    private final int startOffset;

    public static NestedLiteralTypeInfo read(ByteBuffer buffer, int length) {
        NestedLiteralTypeInfo typeInfo = new NestedLiteralTypeInfo(buffer);
        buffer.position(buffer.position() + length);
        return typeInfo;
    }

    public NestedLiteralTypeInfo(ByteBuffer buffer) {
        this.buffer = buffer;
        this.startOffset = buffer.position();
    }

    public TypeSet getTypes(int fieldIndex) {
        return new TypeSet(this.buffer.get(this.startOffset + fieldIndex));
    }

    @Nullable
    private static ColumnType getSingleType(byte types) {
        int count = 0;
        ColumnType singleType = null;
        if ((types & 1) > 0) {
            singleType = ColumnType.STRING;
            ++count;
        }
        if ((types & 4) > 0) {
            singleType = ColumnType.LONG;
            ++count;
        }
        if ((types & 8) > 0) {
            singleType = ColumnType.DOUBLE;
            ++count;
        }
        return count == 1 ? singleType : null;
    }

    private static Set<ColumnType> convertToActualSet(byte types) {
        HashSet theTypes = Sets.newHashSetWithExpectedSize((int)4);
        if ((types & 1) > 0) {
            theTypes.add(ColumnType.STRING);
        }
        if ((types & 4) > 0) {
            theTypes.add(ColumnType.LONG);
        }
        if ((types & 8) > 0) {
            theTypes.add(ColumnType.DOUBLE);
        }
        return theTypes;
    }

    public static class Writer
    implements Serializer {
        private final SegmentWriteOutMedium segmentWriteOutMedium;
        @Nullable
        private WriteOutBytes valuesOut = null;
        private int numWritten = 0;

        public Writer(SegmentWriteOutMedium segmentWriteOutMedium) {
            this.segmentWriteOutMedium = segmentWriteOutMedium;
        }

        public void open() throws IOException {
            this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        }

        public void write(MutableTypeSet types) throws IOException {
            this.valuesOut.write(types.getByteValue());
            ++this.numWritten;
        }

        @Override
        public long getSerializedSize() {
            return this.numWritten;
        }

        @Override
        public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
            this.valuesOut.writeTo(channel);
        }
    }

    public static class MutableTypeSet {
        private byte types;

        public MutableTypeSet() {
            this(0);
        }

        public MutableTypeSet(byte types) {
            this.types = types;
        }

        public MutableTypeSet add(ColumnType type) {
            switch ((ValueType)type.getType()) {
                case STRING: {
                    this.types = (byte)(this.types | 1);
                    break;
                }
                case LONG: {
                    this.types = (byte)(this.types | 4);
                    break;
                }
                case DOUBLE: {
                    this.types = (byte)(this.types | 8);
                    break;
                }
                default: {
                    throw new ISE("Unsupported nested type: [%s]", new Object[]{type.asTypeString()});
                }
            }
            return this;
        }

        public MutableTypeSet merge(byte other) {
            this.types = (byte)(this.types | other);
            return this;
        }

        @Nullable
        public ColumnType getSingleType() {
            return NestedLiteralTypeInfo.getSingleType(this.types);
        }

        public boolean isEmpty() {
            return this.types == 0;
        }

        public byte getByteValue() {
            return this.types;
        }

        public String toString() {
            return NestedLiteralTypeInfo.convertToActualSet(this.types).toString();
        }
    }

    public static class TypeSet {
        private final byte types;

        public TypeSet(byte types) {
            this.types = types;
        }

        @Nullable
        public ColumnType getSingleType() {
            return NestedLiteralTypeInfo.getSingleType(this.types);
        }

        public byte getByteValue() {
            return this.types;
        }

        public String toString() {
            return NestedLiteralTypeInfo.convertToActualSet(this.types).toString();
        }
    }
}

