/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class KeyTestUtils {
    private KeyTestUtils() {
    }

    public static RowSignature createKeySignature(List<SortColumn> sortColumns, ColumnInspector inspector) {
        RowSignature.Builder builder = RowSignature.builder();
        for (SortColumn sortColumn : sortColumns) {
            ColumnCapabilities capabilities = inspector.getColumnCapabilities(sortColumn.columnName());
            ColumnType columnType = Optional.ofNullable(capabilities).map(ColumnCapabilities::toColumnType).orElse(null);
            builder.add(sortColumn.columnName(), columnType);
        }
        return builder.build();
    }

    public static RowKey createKey(RowSignature keySignature, Object ... objects) {
        RowBasedColumnSelectorFactory columnSelectorFactory = RowBasedColumnSelectorFactory.create(columnName -> {
            int idx = keySignature.indexOf(columnName);
            if (idx < 0) {
                return arr -> null;
            }
            return arr -> arr[idx];
        }, () -> objects, (ColumnInspector)keySignature, (boolean)true, (boolean)false);
        FrameWriterFactory writerFactory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED, (MemoryAllocator)HeapMemoryAllocator.unlimited(), (RowSignature)keySignature, Collections.emptyList());
        try (FrameWriter writer = writerFactory.newFrameWriter((ColumnSelectorFactory)columnSelectorFactory);){
            writer.addSelection();
            Frame frame = Frame.wrap((byte[])writer.toByteArray());
            Memory dataRegion = frame.region(1);
            byte[] keyBytes = new byte[(int)dataRegion.getCapacity()];
            dataRegion.copyTo(0L, WritableMemory.writableWrap((byte[])keyBytes), 0L, (long)keyBytes.length);
            RowKey rowKey = RowKey.wrap((byte[])keyBytes);
            return rowKey;
        }
    }
}

