/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongMinAggregationTest {
    private LongMinAggregatorFactory longMinAggFactory;
    private LongMinAggregatorFactory longMinVectorAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private VectorColumnSelectorFactory vectorColumnSelectorFactory;
    private TestLongColumnSelector selector;
    private final long[] values = new long[]{-9223372036854775802L, -9223372036854775803L, -9223372036854775806L, -9223372036854775805L};
    private final long[] longValues1 = new long[]{5L, 2L, 4L, 100L, 1L, 5L, -2L, -3L, 0L, 55L};

    public LongMinAggregationTest() throws Exception {
        String aggSpecJson = "{\"type\": \"longMin\", \"name\": \"billy\", \"fieldName\": \"nilly\"}";
        this.longMinAggFactory = (LongMinAggregatorFactory)TestHelper.makeJsonMapper().readValue(aggSpecJson, LongMinAggregatorFactory.class);
        String vectorAggSpecJson = "{\"type\": \"longMin\", \"name\": \"lng\", \"fieldName\": \"lngFld\"}";
        this.longMinVectorAggFactory = (LongMinAggregatorFactory)TestHelper.makeJsonMapper().readValue(vectorAggSpecJson, LongMinAggregatorFactory.class);
    }

    @Before
    public void setup() {
        NullHandling.initializeForTests();
        this.selector = new TestLongColumnSelector(this.values);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.selector);
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("nilly")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
        VectorValueSelector vectorValueSelector = (VectorValueSelector)EasyMock.createMock(VectorValueSelector.class);
        EasyMock.expect((Object)vectorValueSelector.getLongVector()).andReturn((Object)this.longValues1).anyTimes();
        EasyMock.expect((Object)vectorValueSelector.getNullVector()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{vectorValueSelector});
        this.vectorColumnSelectorFactory = (VectorColumnSelectorFactory)EasyMock.createMock(VectorColumnSelectorFactory.class);
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.getColumnCapabilities("lngFld")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ColumnType.LONG).setDictionaryEncoded(true)).anyTimes();
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.makeValueSelector("lngFld")).andReturn((Object)vectorValueSelector).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.vectorColumnSelectorFactory});
    }

    @Test
    public void testLongMinAggregator() {
        Aggregator agg = this.longMinAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        Assert.assertEquals((long)this.values[2], (long)((Long)agg.get()));
        Assert.assertEquals((long)this.values[2], (long)agg.getLong());
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testLongMinBufferAggregator() {
        BufferAggregator agg = this.longMinAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[9]);
        agg.init(buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        Assert.assertEquals((long)this.values[2], (long)((Long)agg.get(buffer, 0)));
        Assert.assertEquals((long)this.values[2], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testLongMinVectorAggregator() {
        Assert.assertTrue((boolean)this.longMinVectorAggFactory.canVectorize((ColumnInspector)this.vectorColumnSelectorFactory));
        VectorValueSelector vectorValueSelector = this.longMinVectorAggFactory.vectorSelector(this.vectorColumnSelectorFactory);
        Assert.assertEquals((Object)this.longValues1, (Object)vectorValueSelector.getLongVector());
        VectorAggregator vectorAggregator = this.longMinVectorAggFactory.factorizeVector(this.vectorColumnSelectorFactory);
        ByteBuffer buf = ByteBuffer.allocate(this.longMinAggFactory.getMaxIntermediateSizeWithNulls() * 2);
        vectorAggregator.init(buf, 0);
        vectorAggregator.aggregate(buf, 0, 0, 3);
        Assert.assertEquals((long)this.longValues1[1], (long)((Long)vectorAggregator.get(buf, 0)));
        vectorAggregator.aggregate(buf, 1, 0, 3);
        Assert.assertEquals((long)this.longValues1[1], (long)((Long)vectorAggregator.get(buf, 1)));
        vectorAggregator.aggregate(buf, 2, 3, 7);
        Assert.assertEquals((long)this.longValues1[6], (long)((Long)vectorAggregator.get(buf, 2)));
        vectorAggregator.aggregate(buf, 0, 0, 10);
        Assert.assertEquals((long)this.longValues1[7], (long)((Long)vectorAggregator.get(buf, 0)));
    }

    @Test
    public void testCombine() {
        Assert.assertEquals((Object)-9223372036854775803L, (Object)this.longMinAggFactory.combine((Object)-9223372036854775800L, (Object)-9223372036854775803L));
    }

    @Test
    public void testEqualsAndHashCode() {
        LongMinAggregatorFactory one = new LongMinAggregatorFactory("name1", "fieldName1");
        LongMinAggregatorFactory oneMore = new LongMinAggregatorFactory("name1", "fieldName1");
        LongMinAggregatorFactory two = new LongMinAggregatorFactory("name2", "fieldName2");
        Assert.assertEquals((long)one.hashCode(), (long)oneMore.hashCode());
        Assert.assertTrue((boolean)one.equals((Object)oneMore));
        Assert.assertFalse((boolean)one.equals((Object)two));
    }

    private void aggregate(TestLongColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestLongColumnSelector selector, BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }
}

