/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.GuiceExprMacroTable;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

public abstract class MacroTestBase
extends InitializedNullHandlingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ExprMacroTable.ExprMacro macro;

    protected MacroTestBase(ExprMacroTable.ExprMacro macro) {
        this.macro = macro;
    }

    protected void expectException(Class<? extends Throwable> type, String message) {
        this.expectedException.expect(type);
        this.expectedException.expectMessage(message);
    }

    protected Expr apply(List<Expr> args) {
        return this.macro.apply(args);
    }

    protected ExprEval<?> eval(String expression, Expr.ObjectBinding bindings) {
        class WrappedExprMacro
        implements ExprMacroTable.ExprMacro {
            private final AtomicLong calls = new AtomicLong();

            WrappedExprMacro() {
            }

            public String name() {
                return MacroTestBase.this.macro.name();
            }

            public Expr apply(List<Expr> args) {
                this.calls.incrementAndGet();
                return MacroTestBase.this.macro.apply(args);
            }
        }
        WrappedExprMacro wrappedMacro = new WrappedExprMacro();
        GuiceExprMacroTable macroTable = new GuiceExprMacroTable((Set)ImmutableSet.of((Object)wrappedMacro));
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)macroTable);
        Assert.assertTrue((String)"Calls made to macro.apply", (wrappedMacro.calls.get() > 0L ? 1 : 0) != 0);
        return expr.eval(bindings);
    }
}

