/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionProcessingException;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.NestedDataExpressions;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class NestedDataExpressionsTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final ExprMacroTable MACRO_TABLE = new ExprMacroTable((List)ImmutableList.of((Object)new NestedDataExpressions.JsonPathsExprMacro(), (Object)new NestedDataExpressions.JsonKeysExprMacro(), (Object)new NestedDataExpressions.JsonObjectExprMacro(), (Object)new NestedDataExpressions.JsonValueExprMacro(), (Object)new NestedDataExpressions.JsonQueryExprMacro(), (Object)new NestedDataExpressions.ToJsonStringExprMacro(JSON_MAPPER), (Object)new NestedDataExpressions.ParseJsonExprMacro(JSON_MAPPER), (Object)new NestedDataExpressions.TryParseJsonExprMacro(JSON_MAPPER)));
    private static final Map<String, Object> NEST = ImmutableMap.of((Object)"x", (Object)100L, (Object)"y", (Object)200L, (Object)"z", (Object)300L);
    private static final Map<String, Object> NESTER = ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)"y", (Object)ImmutableMap.of((Object)"a", (Object)"hello", (Object)"b", (Object)"world"));
    Expr.ObjectBinding inputBindings = InputBindings.withTypedSuppliers((Map)new ImmutableMap.Builder().put((Object)"nest", (Object)new Pair((Object)NestedDataExpressions.TYPE, () -> NEST)).put((Object)"nestWrapped", (Object)new Pair((Object)NestedDataExpressions.TYPE, () -> new StructuredData(NEST))).put((Object)"nester", (Object)new Pair((Object)NestedDataExpressions.TYPE, () -> NESTER)).put((Object)"string", (Object)new Pair((Object)ExpressionType.STRING, () -> "abcdef")).put((Object)"long", (Object)new Pair((Object)ExpressionType.LONG, () -> 1234L)).put((Object)"double", (Object)new Pair((Object)ExpressionType.DOUBLE, () -> 1.234)).put((Object)"nullString", (Object)new Pair((Object)ExpressionType.STRING, () -> null)).put((Object)"nullLong", (Object)new Pair((Object)ExpressionType.LONG, () -> null)).put((Object)"nullDouble", (Object)new Pair((Object)ExpressionType.DOUBLE, () -> null)).build());

    @Test
    public void testJsonObjectExpression() {
        Expr expr = Parser.parse((String)"json_object('x',100,'y',200,'z',300)", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals(NEST, (Object)eval.value());
        expr = Parser.parse((String)"json_object('x',array('a','b','c'),'y',json_object('a','hello','b','world'))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b", "c"}, (Object[])((Object[])((Map)eval.value()).get("x")));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)"hello", (Object)"b", (Object)"world"), ((Map)eval.value()).get("y"));
    }

    @Test
    public void testJsonKeysExpression() {
        Expr expr = Parser.parse((String)"json_keys(nest, '$.')", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"x", "y", "z"}, (Object[])((Object[])eval.value()));
        expr = Parser.parse((String)"json_keys(nester, '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"0", "1", "2"}, (Object[])((Object[])eval.value()));
        expr = Parser.parse((String)"json_keys(nester, '$.y')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"a", "b"}, (Object[])((Object[])eval.value()));
        expr = Parser.parse((String)"json_keys(nester, '$.x.a')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_keys(nester, '$.x.a.b')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
    }

    @Test
    public void testJsonPathsExpression() {
        Expr expr = Parser.parse((String)"json_paths(nest)", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"$.y", "$.z", "$.x"}, (Object[])((Object[])eval.value()));
        expr = Parser.parse((String)"json_paths(nester)", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)eval.type());
        Assert.assertArrayEquals((Object[])new Object[]{"$.x[0]", "$.x[1]", "$.x[2]", "$.y.b", "$.y.a"}, (Object[])((Object[])eval.value()));
    }

    @Test
    public void testJsonValueExpression() {
        Expr expr = Parser.parse((String)"json_value(nest, '$.x')", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(nester, '$.x[1]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"b", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, '$.x[23]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(nester, '$.x[1].b')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(nester, '$.y[1]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(nester, '$.y.a')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"hello", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, '$.y.a', 'LONG')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)NullHandling.defaultLongValue(), (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nester, '$.y.a.b.c[12]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_value(long, '$')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)1234L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"json_value(long, '$', 'STRING')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"1234", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nest, '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nest, '$.x', 'DOUBLE')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100.0, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)eval.type());
        expr = Parser.parse((String)"json_value(nest, '$.x', 'STRING')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"100", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
    }

    @Test
    public void testJsonQueryExpression() {
        Expr expr = Parser.parse((String)"json_query(nest, '$.x')", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100L, (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"json_query(nester, '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)NESTER.get("x"), (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"json_query(nester, '$.x[1]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"b", (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"json_query(nester, '$.x[23]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_query(nester, '$.x[1].b')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_query(nester, '$.y[1]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_query(nester, '$.y.a')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"hello", (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"json_query(nester, '$.y.a.b.c[12]')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertNull((Object)eval.value());
        expr = Parser.parse((String)"json_query(long, '$')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)1234L, (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
    }

    @Test
    public void testParseJsonTryParseJson() throws JsonProcessingException {
        Expr expr = Parser.parse((String)"parse_json(null)", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals(null, (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('null')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals(null, (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        Assert.assertThrows(ExpressionProcessingException.class, () -> Parser.parse((String)"parse_json('{')", (ExprMacroTable)MACRO_TABLE));
        expr = Parser.parse((String)"try_parse_json('{')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals(null, (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        Assert.assertThrows(ExpressionProcessingException.class, () -> Parser.parse((String)"parse_json('hello world')", (ExprMacroTable)MACRO_TABLE));
        expr = Parser.parse((String)"try_parse_json('hello world')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals(null, (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('\"hello world\"')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"hello world", (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('1')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)1, (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('true')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)true, (Object)eval.value());
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"parse_json('{\"foo\":1}')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"foo\":1}", (Object)JSON_MAPPER.writeValueAsString(eval.value()));
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
    }

    @Test
    public void testToJsonStringParseJson() {
        Expr expr = Parser.parse((String)"to_json_string(nest)", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"x\":100,\"y\":200,\"z\":300}", (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.type());
        expr = Parser.parse((String)"parse_json(to_json_string(nest))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        for (String key : NEST.keySet()) {
            Map val = (Map)eval.value();
            Assert.assertEquals((Object)NEST.get(key), (Object)((Integer)val.get(key)).longValue());
        }
        Assert.assertEquals((Object)NestedDataExpressions.TYPE, (Object)eval.type());
        expr = Parser.parse((String)"json_value(parse_json('{\"x\":100,\"y\":200,\"z\":300}'), '$.x')", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)100L, (Object)eval.value());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        expr = Parser.parse((String)"to_json_string(json_object('x', nestWrapped))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"x\":{\"x\":100,\"y\":200,\"z\":300}}", (Object)eval.value());
        expr = Parser.parse((String)"to_json_string(json_object('xs', array(nest, nestWrapped)))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)"{\"xs\":[{\"x\":100,\"y\":200,\"z\":300},{\"x\":100,\"y\":200,\"z\":300}]}", (Object)eval.value());
    }
}

