/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceAnalysisTest {
    private static final List<Interval> MILLENIUM_INTERVALS = ImmutableList.of((Object)Intervals.of((String)"2000/3000"));
    private static final TableDataSource TABLE_FOO = new TableDataSource("foo");
    private static final TableDataSource TABLE_BAR = new TableDataSource("bar");
    private static final LookupDataSource LOOKUP_LOOKYLOO = new LookupDataSource("lookyloo");
    private static final InlineDataSource INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[0]), (RowSignature)RowSignature.builder().add("column", ColumnType.STRING).build());

    @Test
    public void testTable() {
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)TABLE_FOO);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
    }

    @Test
    public void testUnion() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)unionDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)unionDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)unionDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.of(unionDataSource), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
    }

    @Test
    public void testQueryOnTable() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.subquery((DataSource)TABLE_FOO);
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)queryDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isQuery());
        Assert.assertEquals((Object)queryDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.of(new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
    }

    @Test
    public void testQueryOnUnion() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        QueryDataSource queryDataSource = DataSourceAnalysisTest.subquery((DataSource)unionDataSource);
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)queryDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isQuery());
        Assert.assertEquals((Object)queryDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)unionDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.of(unionDataSource), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.of(new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
    }

    @Test
    public void testLookup() {
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)LOOKUP_LOOKYLOO);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isConcreteTableBased());
        Assert.assertTrue((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
    }

    @Test
    public void testQueryOnLookup() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO);
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)queryDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isConcreteTableBased());
        Assert.assertTrue((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isQuery());
        Assert.assertEquals((Object)queryDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.of(new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
    }

    @Test
    public void testInline() {
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)INLINE);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isConcreteTableBased());
        Assert.assertTrue((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)INLINE, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)INLINE, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
    }

    @Test
    public void testJoinSimpleLeftLeaning() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER), (DataSource)INLINE, "2.", JoinType.LEFT), (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), "3.", JoinType.FULL);
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)joinDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)joinDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1.")), (Object)new PreJoinableClause("2.", (DataSource)INLINE, JoinType.LEFT, DataSourceAnalysisTest.joinClause("2.")), (Object)new PreJoinableClause("3.", (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), JoinType.FULL, DataSourceAnalysisTest.joinClause("3."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
    }

    @Test
    public void testJoinSimpleLeftLeaningWithLeftFilter() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance()), (DataSource)INLINE, "2.", JoinType.LEFT), (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), "3.", JoinType.FULL);
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)joinDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)joinDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals((Object)TrueDimFilter.instance(), analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1.")), (Object)new PreJoinableClause("2.", (DataSource)INLINE, JoinType.LEFT, DataSourceAnalysisTest.joinClause("2.")), (Object)new PreJoinableClause("3.", (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), JoinType.FULL, DataSourceAnalysisTest.joinClause("3."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
    }

    @Test
    public void testJoinSimpleRightLeaning() {
        JoinDataSource rightLeaningJoinStack = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)DataSourceAnalysisTest.join((DataSource)INLINE, (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), "1.", JoinType.LEFT), "2.", JoinType.FULL);
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)rightLeaningJoinStack, "3.", JoinType.RIGHT);
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)joinDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)joinDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("3.", (DataSource)rightLeaningJoinStack, JoinType.RIGHT, DataSourceAnalysisTest.joinClause("3."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
    }

    @Test
    public void testJoinSimpleRightLeaningWithLeftFilter() {
        JoinDataSource rightLeaningJoinStack = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)DataSourceAnalysisTest.join((DataSource)INLINE, (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), "1.", JoinType.LEFT), "2.", JoinType.FULL);
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)rightLeaningJoinStack, "3.", JoinType.RIGHT, (DimFilter)TrueDimFilter.instance());
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)joinDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)joinDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals((Object)TrueDimFilter.instance(), analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("3.", (DataSource)rightLeaningJoinStack, JoinType.RIGHT, DataSourceAnalysisTest.joinClause("3."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
    }

    @Test
    public void testJoinOverTableSubquery() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)DataSourceAnalysisTest.subquery((DataSource)TABLE_FOO), "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance());
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)joinDataSource);
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)joinDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TrueDimFilter.instance(), analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)DataSourceAnalysisTest.subquery((DataSource)TABLE_FOO), JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
    }

    @Test
    public void testJoinTableUnionToLookup() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)unionDataSource, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)joinDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)joinDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals(Optional.of(unionDataSource), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals((Object)unionDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
    }

    @Test
    public void testJoinUnderTopLevelSubqueries() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.subquery((DataSource)DataSourceAnalysisTest.subquery((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance())));
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)queryDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isQuery());
        Assert.assertEquals((Object)queryDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TrueDimFilter.instance(), analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(DataSourceAnalysisTest.subquery((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance())).getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.of(new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
    }

    @Test
    public void testJoinLookupToLookup() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)joinDataSource);
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isConcreteTableBased());
        Assert.assertTrue((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)joinDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
    }

    @Test
    public void testJoinLookupToTable() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)TABLE_FOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)joinDataSource);
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isConcreteTableBased());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isQuery());
        Assert.assertEquals((Object)joinDataSource, (Object)analysis.getDataSource());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)TABLE_FOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(DataSourceAnalysis.class).usingGetClass().withNonnullFields(new String[]{"dataSource"}).withIgnoredFields(new String[]{"baseDataSource", "baseQuery", "preJoinableClauses", "joinBaseTableFilter"}).verify();
    }

    private static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, JoinType joinType, DimFilter dimFilter) {
        return JoinDataSource.create((DataSource)left, (DataSource)right, (String)rightPrefix, (String)DataSourceAnalysisTest.joinClause(rightPrefix).getOriginalExpression(), (JoinType)joinType, (DimFilter)dimFilter, (ExprMacroTable)ExprMacroTable.nil());
    }

    private static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, JoinType joinType) {
        return DataSourceAnalysisTest.join(left, right, rightPrefix, joinType, null);
    }

    private static JoinConditionAnalysis joinClause(String rightPrefix) {
        return JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"x == \"%sx\"", (Object[])new Object[]{rightPrefix}), (String)rightPrefix, (ExprMacroTable)ExprMacroTable.nil());
    }

    private static QueryDataSource subquery(DataSource dataSource) {
        return new QueryDataSource((Query)GroupByQuery.builder().setDataSource(dataSource).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)).setGranularity(Granularities.ALL).build());
    }
}

