/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ScanResultValueTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final long TIME_1_LONG = 1234567890000L;
    private static final long TIME_2_LONG = 9876543210000L;
    private static final int TIME_3_INT = Integer.MAX_VALUE;
    private static ScanResultValue compactedListSRVLongTimestamp;
    private static ScanResultValue listSRVLongTimestamp;
    private static ScanResultValue compactedListSRVIntegerTimestamp;
    private static ScanResultValue listSRVIntegerTimestamp;

    @BeforeClass
    public static void setup() {
        String segmentId = "some_segment_id";
        ArrayList<String> columns = new ArrayList<String>(Arrays.asList("__time", "name", "count"));
        ArrayList<Serializable> event = new ArrayList<Serializable>(Arrays.asList(1234567890000L, "Feridun", 4));
        ArrayList<Serializable> event2 = new ArrayList<Serializable>(Arrays.asList(9876543210000L, "Justin", 6));
        List<List> events = Arrays.asList(event, event2);
        compactedListSRVLongTimestamp = new ScanResultValue(segmentId, columns, events);
        ArrayList<Serializable> eventInt = new ArrayList<Serializable>(Arrays.asList(Integer.MAX_VALUE, "Feridun", 4));
        List<List> eventsInt = Arrays.asList(eventInt, event2);
        compactedListSRVIntegerTimestamp = new ScanResultValue(segmentId, columns, eventsInt);
        HashMap<String, Object> eventMap1 = new HashMap<String, Object>();
        eventMap1.put("__time", 1234567890000L);
        eventMap1.put("name", "Feridun");
        eventMap1.put("count", 4);
        HashMap<String, Object> eventMap2 = new HashMap<String, Object>();
        eventMap2.put("__time", 9876543210000L);
        eventMap2.put("name", "Justin");
        eventMap2.put("count", 6);
        List<Map> eventMaps = Arrays.asList(eventMap1, eventMap2);
        listSRVLongTimestamp = new ScanResultValue(segmentId, columns, eventMaps);
        HashMap<String, Object> eventMap3 = new HashMap<String, Object>();
        eventMap3.put("__time", Integer.MAX_VALUE);
        eventMap3.put("name", "Justin");
        eventMap3.put("count", 6);
        List<Map> eventMapsInt = Arrays.asList(eventMap3, eventMap2);
        listSRVIntegerTimestamp = new ScanResultValue(segmentId, columns, eventMapsInt);
    }

    @Test
    public void testSerdeScanResultValueCompactedList() throws IOException {
        String serialized = JSON_MAPPER.writeValueAsString((Object)compactedListSRVLongTimestamp);
        ScanResultValue deserialized = (ScanResultValue)JSON_MAPPER.readValue(serialized, ScanResultValue.class);
        Assert.assertEquals((Object)compactedListSRVLongTimestamp, (Object)deserialized);
    }

    @Test
    public void testSerdeScanResultValueNonCompactedList() throws IOException {
        String serialized = JSON_MAPPER.writeValueAsString((Object)listSRVLongTimestamp);
        ScanResultValue deserialized = (ScanResultValue)JSON_MAPPER.readValue(serialized, ScanResultValue.class);
        Assert.assertEquals((Object)listSRVLongTimestamp, (Object)deserialized);
    }

    @Test
    public void testGetFirstEventTimestampCompactedList() {
        long timestamp = compactedListSRVLongTimestamp.getFirstEventTimestamp(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST);
        Assert.assertEquals((long)1234567890000L, (long)timestamp);
        long timestampInt = compactedListSRVIntegerTimestamp.getFirstEventTimestamp(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)timestampInt);
    }

    @Test
    public void testGetFirstEventTimestampNonCompactedList() {
        long timestamp = listSRVLongTimestamp.getFirstEventTimestamp(ScanQuery.ResultFormat.RESULT_FORMAT_LIST);
        Assert.assertEquals((long)1234567890000L, (long)timestamp);
        long timestampInt = listSRVIntegerTimestamp.getFirstEventTimestamp(ScanQuery.ResultFormat.RESULT_FORMAT_LIST);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)timestampInt);
    }

    @Test
    public void testToSingleEventScanResultValues() {
        List compactedListScanResultValues = compactedListSRVLongTimestamp.toSingleEventScanResultValues();
        for (ScanResultValue srv : compactedListScanResultValues) {
            List events = (List)srv.getEvents();
            Assert.assertEquals((long)1L, (long)events.size());
        }
        List listScanResultValues = listSRVLongTimestamp.toSingleEventScanResultValues();
        for (ScanResultValue srv : listScanResultValues) {
            List events = (List)srv.getEvents();
            Assert.assertEquals((long)1L, (long)events.size());
        }
    }
}

