/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.VSizeLongSerde;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class VSizeLongSerdeTest {
    public static void testSerde(int numBits, long[] values) throws IOException {
        boolean bufferOffset = true;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        outStream.write(175);
        ByteBuffer buffer = ByteBuffer.allocate(VSizeLongSerde.getSerializedSize((int)numBits, (int)values.length) + 1);
        buffer.rewind();
        buffer.put(0, (byte)-81);
        VSizeLongSerde.LongSerializer streamSer = VSizeLongSerde.getSerializer((int)numBits, (OutputStream)outStream);
        VSizeLongSerde.LongSerializer bufferSer = VSizeLongSerde.getSerializer((int)numBits, (ByteBuffer)buffer, (int)1);
        for (long value : values) {
            streamSer.write(value);
            bufferSer.write(value);
        }
        streamSer.close();
        bufferSer.close();
        ByteBuffer bufferFromStream = ByteBuffer.wrap(outStream.toByteArray());
        Assert.assertEquals((String)StringUtils.format((String)"Serialized size (stream, numBits = %d)", (Object[])new Object[]{numBits}), (long)VSizeLongSerde.getSerializedSize((int)numBits, (int)values.length), (long)(bufferFromStream.capacity() - 1));
        Assert.assertEquals((String)StringUtils.format((String)"Serialized size (buffer, numBits = %d)", (Object[])new Object[]{numBits}), (long)VSizeLongSerde.getSerializedSize((int)numBits, (int)values.length), (long)(buffer.position() - 1));
        Assert.assertArrayEquals((String)StringUtils.format((String)"Stream and buffer serialized images are equal (numBits = %d)", (Object[])new Object[]{numBits}), (byte[])bufferFromStream.array(), (byte[])buffer.array());
        VSizeLongSerde.LongDeserializer deserializer = VSizeLongSerde.getDeserializer((int)numBits, (ByteBuffer)buffer, (int)1);
        VSizeLongSerdeTest.testGetSingleRow(deserializer, numBits, values);
        VSizeLongSerdeTest.testContiguousGetSingleRow(deserializer, numBits, values);
        VSizeLongSerdeTest.testContiguousGetWholeRegion(deserializer, numBits, values);
        VSizeLongSerdeTest.testNoncontiguousGetSingleRow(deserializer, numBits, values);
        VSizeLongSerdeTest.testNoncontiguousGetEveryOtherValue(deserializer, numBits, values);
        VSizeLongSerdeTest.testNoncontiguousGetEveryOtherValueWithLimit(deserializer, numBits, values);
    }

    private static void testGetSingleRow(VSizeLongSerde.LongDeserializer deserializer, int numBits, long[] values) {
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((String)StringUtils.format((String)"Deserializer (testGetSingleRow, numBits = %d, position = %d)", (Object[])new Object[]{numBits, i}), (long)values[i], (long)deserializer.get(i));
        }
    }

    private static void testContiguousGetSingleRow(VSizeLongSerde.LongDeserializer deserializer, int numBits, long[] values) {
        boolean outPosition = true;
        long[] out = new long[values.length + 1];
        for (int i = 0; i < values.length; ++i) {
            Arrays.fill(out, -1L);
            deserializer.getDelta(out, 1, i, 1, 0L);
            Assert.assertEquals((String)StringUtils.format((String)"Deserializer (testContiguousGetSingleRow, numBits = %d, position = %d)", (Object[])new Object[]{numBits, i}), (long)values[i], (long)out[1]);
        }
    }

    private static void testContiguousGetWholeRegion(VSizeLongSerde.LongDeserializer deserializer, int numBits, long[] values) {
        boolean outPosition = true;
        long[] out = new long[values.length + 1];
        Arrays.fill(out, -1L);
        deserializer.getDelta(out, 1, 0, values.length, 0L);
        Assert.assertArrayEquals((String)StringUtils.format((String)"Deserializer (testContiguousGetWholeRegion, numBits = %d)", (Object[])new Object[]{numBits}), (long[])values, (long[])Arrays.stream(out).skip(1L).toArray());
    }

    private static void testNoncontiguousGetSingleRow(VSizeLongSerde.LongDeserializer deserializer, int numBits, long[] values) {
        boolean indexOffset = true;
        boolean outPosition = true;
        long[] out = new long[values.length + 1];
        int[] indexes = new int[values.length + 1];
        for (int i = 0; i < values.length; ++i) {
            Arrays.fill(out, -1L);
            Arrays.fill(indexes, -1);
            indexes[1] = i + 1;
            deserializer.getDelta(out, 1, indexes, 1, 1, values.length, 0L);
            Assert.assertEquals((String)StringUtils.format((String)"Deserializer (testNoncontiguousGetSingleRow, numBits = %d, position = %d)", (Object[])new Object[]{numBits, i}), (long)values[i], (long)out[1]);
        }
    }

    private static void testNoncontiguousGetEveryOtherValue(VSizeLongSerde.LongDeserializer deserializer, int numBits, long[] values) {
        boolean indexOffset = true;
        boolean outPosition = true;
        long[] out = new long[values.length + 1];
        long[] expectedOut = new long[values.length + 1];
        int[] indexes = new int[values.length + 1];
        Arrays.fill(out, -1L);
        Arrays.fill(expectedOut, -1L);
        Arrays.fill(indexes, -1);
        int cnt = 0;
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 != 0) continue;
            indexes[1 + i / 2] = i + 1;
            expectedOut[1 + i / 2] = values[i];
            ++cnt;
        }
        deserializer.getDelta(out, 1, indexes, cnt, 1, values.length, 0L);
        Assert.assertArrayEquals((String)StringUtils.format((String)"Deserializer (testNoncontiguousGetEveryOtherValue, numBits = %d)", (Object[])new Object[]{numBits}), (long[])expectedOut, (long[])out);
    }

    private static void testNoncontiguousGetEveryOtherValueWithLimit(VSizeLongSerde.LongDeserializer deserializer, int numBits, long[] values) {
        boolean indexOffset = true;
        boolean outPosition = true;
        long[] out = new long[values.length + 1];
        long[] expectedOut = new long[values.length + 1];
        int[] indexes = new int[values.length + 1];
        int limit = values.length - 2;
        Arrays.fill(out, -1L);
        Arrays.fill(expectedOut, -1L);
        Arrays.fill(indexes, -1);
        int cnt = 0;
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 != 0) continue;
            indexes[1 + i / 2] = i + 1;
            if (i < limit) {
                expectedOut[1 + i / 2] = values[i];
            }
            ++cnt;
        }
        int ret = deserializer.getDelta(out, 1, indexes, cnt, 1, limit, 0L);
        Assert.assertArrayEquals((String)StringUtils.format((String)"Deserializer (testNoncontiguousGetEveryOtherValue, numBits = %d)", (Object[])new Object[]{numBits}), (long[])expectedOut, (long[])out);
        Assert.assertEquals((long)Math.max(0, cnt - 1), (long)ret);
    }

    public static class SpecificValuesTest {
        private final long[] values0 = new long[]{0L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 0L, 0L, 1L, 1L};
        private final long[] values1 = new long[]{0L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 0L, 0L, 1L, 1L};
        private final long[] values2 = new long[]{12L, 5L, 2L, 9L, 3L, 2L, 5L, 1L, 0L, 6L, 13L, 10L, 15L};
        private final long[] values3 = new long[]{1L, 1L, 1L, 1L, 1L, 11L, 11L, 11L, 11L};
        private final long[] values4 = new long[]{200L, 200L, 200L, 401L, 200L, 301L, 200L, 200L, 200L, 404L, 200L, 200L, 200L, 200L};
        private final long[] values5 = new long[]{123L, 632L, 12L, 39L, 536L, 0L, 1023L, 52L, 777L, 526L, 214L, 562L, 823L, 346L};
        private final long[] values6 = new long[]{1000000L, 1000001L, 1000002L, 1000003L, 1000004L, 1000005L, 1000006L, 1000007L, 1000008L};

        @Test
        public void testGetBitsForMax() {
            Assert.assertEquals((long)1L, (long)VSizeLongSerde.getBitsForMax((long)1L));
            Assert.assertEquals((long)1L, (long)VSizeLongSerde.getBitsForMax((long)2L));
            Assert.assertEquals((long)2L, (long)VSizeLongSerde.getBitsForMax((long)3L));
            Assert.assertEquals((long)4L, (long)VSizeLongSerde.getBitsForMax((long)16L));
            Assert.assertEquals((long)8L, (long)VSizeLongSerde.getBitsForMax((long)200L));
            Assert.assertEquals((long)12L, (long)VSizeLongSerde.getBitsForMax((long)999L));
            Assert.assertEquals((long)24L, (long)VSizeLongSerde.getBitsForMax((long)12345678L));
            Assert.assertEquals((long)32L, (long)VSizeLongSerde.getBitsForMax((long)Integer.MAX_VALUE));
            Assert.assertEquals((long)64L, (long)VSizeLongSerde.getBitsForMax((long)Long.MAX_VALUE));
        }

        @Test
        public void testSerdeValues() throws IOException {
            for (int i : VSizeLongSerde.SUPPORTED_SIZES) {
                VSizeLongSerdeTest.testSerde(i, this.values0);
                if (i >= 1) {
                    VSizeLongSerdeTest.testSerde(i, this.values1);
                }
                if (i >= 4) {
                    VSizeLongSerdeTest.testSerde(i, this.values2);
                    VSizeLongSerdeTest.testSerde(i, this.values3);
                }
                if (i >= 9) {
                    VSizeLongSerdeTest.testSerde(i, this.values4);
                }
                if (i >= 10) {
                    VSizeLongSerdeTest.testSerde(i, this.values5);
                }
                if (i < 20) continue;
                VSizeLongSerdeTest.testSerde(i, this.values6);
            }
        }

        @Test
        public void testSerdeLoop() throws IOException {
            long[] zeroTo256 = this.generateSequentialLongs(0L, 256L);
            long[] zeroTo50000 = this.generateSequentialLongs(0L, 50000L);
            for (int i : VSizeLongSerde.SUPPORTED_SIZES) {
                if (i >= 8) {
                    VSizeLongSerdeTest.testSerde(i, zeroTo256);
                }
                if (i < 16) continue;
                VSizeLongSerdeTest.testSerde(i, zeroTo50000);
            }
        }

        private long[] generateSequentialLongs(long start, long end) {
            long[] values = new long[Ints.checkedCast((long)(end - start))];
            for (int i = 0; i < values.length; ++i) {
                values[i] = start + (long)i;
            }
            return values;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class EveryLittleBitTest {
        private final int numBits;

        public EveryLittleBitTest(int numBits) {
            this.numBits = numBits;
        }

        /*
         * Exception decompiling
         */
        @Parameterized.Parameters(name="numBits={0}")
        public static Collection<Object[]> data() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Test
        public void testEveryPowerOfTwo() throws IOException {
            int numLongs = Math.min(64, this.numBits);
            long[] longs = new long[numLongs];
            for (int bit = 0; bit < numLongs; ++bit) {
                longs[bit] = 1L << bit;
            }
            VSizeLongSerdeTest.testSerde(this.numBits, longs);
        }

        @Test
        public void testEveryPowerOfTwoMinusOne() throws IOException {
            int numLongs = Math.min(64, this.numBits + 1);
            long[] longs = new long[numLongs];
            for (int bit = 0; bit < numLongs; ++bit) {
                longs[bit] = (1L << bit) - 1L;
            }
            VSizeLongSerdeTest.testSerde(this.numBits, longs);
        }
    }
}

