/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilters;
import org.apache.druid.query.filter.ExtractionDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.serde.DictionaryEncodedStringIndexSupplier;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExtractionDimFilterTest
extends InitializedNullHandlingTest {
    private static final Map<String, String> EXTRACTION_VALUES = ImmutableMap.of((Object)"foo1", (Object)"extractDimVal");
    private final BitmapFactory factory;
    private final BitmapSerdeFactory serdeFactory;
    private final ImmutableBitmap foo1BitMap;
    private final ColumnIndexSelector BITMAP_INDEX_SELECTOR = new ColumnIndexSelector(){

        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.STRING).setHasMultipleValues(true).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true);
        }

        public int getNumRows() {
            return 1;
        }

        public BitmapFactory getBitmapFactory() {
            return ExtractionDimFilterTest.this.factory;
        }

        public ColumnIndexSupplier getIndexSupplier(String column) {
            if ("foo".equals(column)) {
                return new DictionaryEncodedStringIndexSupplier(ExtractionDimFilterTest.this.factory, GenericIndexed.fromIterable(Collections.singletonList("foo1"), (ObjectStrategy)GenericIndexed.STRING_STRATEGY), GenericIndexed.fromIterable(Collections.singletonList(ByteBuffer.wrap(StringUtils.toUtf8((String)"foo1"))), (ObjectStrategy)GenericIndexed.BYTE_BUFFER_STRATEGY), GenericIndexed.fromIterable(Collections.singletonList(ExtractionDimFilterTest.this.foo1BitMap), (ObjectStrategy)ExtractionDimFilterTest.this.serdeFactory.getObjectStrategy()), null);
            }
            return null;
        }
    };
    private static final ExtractionFn DIM_EXTRACTION_FN = new DimExtractionFn(){

        public byte[] getCacheKey() {
            return new byte[0];
        }

        public String apply(String dimValue) {
            String retval = (String)EXTRACTION_VALUES.get(dimValue);
            return retval == null ? dimValue : retval;
        }

        public boolean preservesOrdering() {
            return false;
        }

        public ExtractionFn.ExtractionType getExtractionType() {
            return ExtractionFn.ExtractionType.MANY_TO_ONE;
        }
    };

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{new ConciseBitmapFactory(), new ConciseBitmapSerdeFactory()}, (Object)new Object[]{new RoaringBitmapFactory(), new RoaringBitmapSerdeFactory(null)});
    }

    public ExtractionDimFilterTest(BitmapFactory bitmapFactory, BitmapSerdeFactory bitmapSerdeFactory) {
        MutableBitmap mutableBitmap = bitmapFactory.makeEmptyMutableBitmap();
        mutableBitmap.add(1);
        this.foo1BitMap = bitmapFactory.makeImmutableBitmap(mutableBitmap);
        this.factory = bitmapFactory;
        this.serdeFactory = bitmapSerdeFactory;
    }

    @Test
    public void testEmpty() {
        Filter extractionFilter = new SelectorDimFilter("foo", "NFDJUKFNDSJFNS", DIM_EXTRACTION_FN).toFilter();
        ImmutableBitmap immutableBitmap = Filters.computeDefaultBitmapResults((Filter)extractionFilter, (ColumnIndexSelector)this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNull() {
        Filter extractionFilter = new SelectorDimFilter("FDHJSFFHDS", "extractDimVal", DIM_EXTRACTION_FN).toFilter();
        ImmutableBitmap immutableBitmap = Filters.computeDefaultBitmapResults((Filter)extractionFilter, (ColumnIndexSelector)this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNormal() {
        Filter extractionFilter = new SelectorDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN).toFilter();
        ImmutableBitmap immutableBitmap = Filters.computeDefaultBitmapResults((Filter)extractionFilter, (ColumnIndexSelector)this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)1L, (long)immutableBitmap.size());
    }

    @Test
    public void testOr() {
        Assert.assertEquals((long)1L, (long)Filters.computeDefaultBitmapResults((Filter)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})), (ColumnIndexSelector)this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.computeDefaultBitmapResults((Filter)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null), new ExtractionDimFilter("foo", "DOES NOT EXIST", DIM_EXTRACTION_FN, null)})), (ColumnIndexSelector)this.BITMAP_INDEX_SELECTOR).size());
    }

    @Test
    public void testAnd() {
        Assert.assertEquals((long)1L, (long)Filters.computeDefaultBitmapResults((Filter)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})), (ColumnIndexSelector)this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.computeDefaultBitmapResults((Filter)Filters.toFilter((DimFilter)DimFilters.and((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null), new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})), (ColumnIndexSelector)this.BITMAP_INDEX_SELECTOR).size());
    }

    @Test
    public void testNot() {
        Assert.assertEquals((long)1L, (long)Filters.computeDefaultBitmapResults((Filter)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})), (ColumnIndexSelector)this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.computeDefaultBitmapResults((Filter)Filters.toFilter((DimFilter)DimFilters.not((DimFilter)new ExtractionDimFilter("foo", "DOES NOT EXIST", DIM_EXTRACTION_FN, null))), (ColumnIndexSelector)this.BITMAP_INDEX_SELECTOR).size());
    }
}

