/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.config.NullHandlingTest;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.TestQuery;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.join.HashJoinSegment;
import org.apache.druid.segment.join.InlineJoinableFactory;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.NoopDataSource;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.join.lookup.LookupJoinable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;
import org.apache.druid.timeline.SegmentId;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class JoinableFactoryWrapperTest
extends NullHandlingTest {
    public static final JoinableFactoryWrapper NOOP_JOINABLE_FACTORY_WRAPPER = new JoinableFactoryWrapper((JoinableFactory)NoopJoinableFactory.INSTANCE);
    private static final Map<String, String> TEST_LOOKUP = ImmutableMap.builder().put((Object)"MX", (Object)"Mexico").put((Object)"NO", (Object)"Norway").put((Object)"SV", (Object)"El Salvador").put((Object)"US", (Object)"United States").put((Object)"", (Object)"Empty key").build();
    private static final Set<String> TEST_LOOKUP_KEYS = NullHandling.sqlCompatible() ? TEST_LOOKUP.keySet() : Sets.difference(TEST_LOOKUP.keySet(), Collections.singleton(""));
    private static final InlineDataSource INDEXED_TABLE_DS = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"Mexico"}, (Object)new Object[]{"Norway"}, (Object)new Object[]{"El Salvador"}, (Object)new Object[]{"United States"}, (Object)new Object[]{"United States"}), (RowSignature)RowSignature.builder().add("country", ColumnType.STRING).build());
    private static final InlineDataSource NULL_INDEXED_TABLE_DS = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null}), (RowSignature)RowSignature.builder().add("nullCol", ColumnType.STRING).build());
    private static final IndexedTable TEST_INDEXED_TABLE = new RowBasedIndexedTable(INDEXED_TABLE_DS.getRowsAsList(), INDEXED_TABLE_DS.rowAdapter(), INDEXED_TABLE_DS.getRowSignature(), (Set)ImmutableSet.of((Object)"country"), DateTimes.nowUtc().toString());
    private static final IndexedTable TEST_NULL_INDEXED_TABLE = new RowBasedIndexedTable(NULL_INDEXED_TABLE_DS.getRowsAsList(), NULL_INDEXED_TABLE_DS.rowAdapter(), NULL_INDEXED_TABLE_DS.getRowSignature(), (Set)ImmutableSet.of((Object)"nullCol"), DateTimes.nowUtc().toString());
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void test_createSegmentMapFn_noClauses() {
        Function segmentMapFn = NOOP_JOINABLE_FACTORY_WRAPPER.createSegmentMapFn(null, (List)ImmutableList.of(), new AtomicLong(), null);
        Assert.assertSame(Function.identity(), (Object)segmentMapFn);
    }

    @Test
    public void test_createSegmentMapFn_unusableClause() {
        PreJoinableClause clause = this.makePreJoinableClause((DataSource)INDEXED_TABLE_DS, "country == \"j.country\"", "j.", JoinType.LEFT);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("dataSource is not joinable");
        Function ignored = NOOP_JOINABLE_FACTORY_WRAPPER.createSegmentMapFn(null, (List)ImmutableList.of((Object)clause), new AtomicLong(), null);
    }

    @Test
    public void test_createSegmentMapFn_usableClause() {
        PreJoinableClause clause = this.makePreJoinableClause((DataSource)INDEXED_TABLE_DS, "country == \"j.country\"", "j.", JoinType.LEFT);
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new InlineJoinableFactory());
        Function segmentMapFn = joinableFactoryWrapper.createSegmentMapFn(null, (List)ImmutableList.of((Object)clause), new AtomicLong(), (Query)new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, new HashMap()));
        Assert.assertNotSame(Function.identity(), (Object)segmentMapFn);
    }

    @Test
    public void test_createSegmentMapFn_usableClause_joinToFilterEnabled() throws IOException {
        PreJoinableClause clause = this.makePreJoinableClause((DataSource)INDEXED_TABLE_DS, "country == \"j.country\"", "j.", JoinType.INNER);
        TestQuery queryWithRequiredColumnsAndJoinFilterRewrite = (TestQuery)new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, new HashMap()).withOverriddenContext((Map)ImmutableMap.of((Object)"enableRewriteJoinToFilter", (Object)"true"));
        queryWithRequiredColumnsAndJoinFilterRewrite.setRequiredColumns((Set<String>)ImmutableSet.of((Object)"country"));
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new InlineJoinableFactory());
        Function segmentMapFn = joinableFactoryWrapper.createSegmentMapFn(null, (List)ImmutableList.of((Object)clause), new AtomicLong(), (Query)queryWithRequiredColumnsAndJoinFilterRewrite);
        ReferenceCountingSegment baseSegmentReference = ReferenceCountingSegment.wrapRootGenerationSegment((Segment)new QueryableIndexSegment(JoinTestHelper.createFactIndexBuilder(this.temporaryFolder.newFolder()).buildMMappedIndex(), SegmentId.dummy((String)"facts")));
        Assert.assertNotSame(Function.identity(), (Object)segmentMapFn);
        SegmentReference joinSegmentReference = (SegmentReference)segmentMapFn.apply(baseSegmentReference);
        Assert.assertTrue((boolean)(joinSegmentReference instanceof HashJoinSegment));
        HashJoinSegment hashJoinSegment = (HashJoinSegment)joinSegmentReference;
        Assert.assertEquals((Object)hashJoinSegment.getBaseFilter(), (Object)new InDimFilter("country", INDEXED_TABLE_DS.getRowsAsList().stream().map(row -> row[0].toString()).collect(Collectors.toSet())));
        Assert.assertEquals((long)hashJoinSegment.getClauses().size(), (long)1L);
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_noClauses() {
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        NoopDataSource dataSource = new NoopDataSource();
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.emptyList());
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty());
        EasyMock.expect((Object)analysis.getDataSource()).andReturn((Object)dataSource);
        EasyMock.replay((Object[])new Object[]{analysis});
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"No join clauses to build the cache key for data source [%s]", (Object[])new Object[]{dataSource}));
        joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_noHashJoin() {
        PreJoinableClause clause1 = this.makeGlobalPreJoinableClause("dataSource_1", "x == \"j.x\"", "j.");
        PreJoinableClause clause2 = this.makeGlobalPreJoinableClause("dataSource_2", "x != \"h.x\"", "h.");
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Arrays.asList(clause1, clause2)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.of(TrueDimFilter.instance())).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        Optional cacheKey = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertFalse((boolean)cacheKey.isPresent());
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_cachingUnsupported() {
        PreJoinableClause clause1 = this.makeGlobalPreJoinableClause("dataSource_1", "x == \"j.x\"", "j.");
        LookupDataSource dataSource = new LookupDataSource("lookup");
        PreJoinableClause clause2 = this.makePreJoinableClause((DataSource)dataSource, "x == \"h.x\"", "h.", JoinType.LEFT);
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Arrays.asList(clause1, clause2)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.of(TrueDimFilter.instance())).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        Optional cacheKey = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertFalse((boolean)cacheKey.isPresent());
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_usableClauses() {
        PreJoinableClause clause1 = this.makeGlobalPreJoinableClause("dataSource_1", "x == \"j.x\"", "j.");
        PreJoinableClause clause2 = this.makeGlobalPreJoinableClause("dataSource_2", "x == \"h.x\"", "h.");
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Arrays.asList(clause1, clause2)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        Optional cacheKey = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey.isPresent());
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithExpression() {
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        PreJoinableClause clause1 = this.makeGlobalPreJoinableClause("dataSource_1", "y == \"j.y\"", "j.");
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey1 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey1.isPresent());
        Assert.assertNotEquals((long)0L, (long)((byte[])cacheKey1.get()).length);
        PreJoinableClause clause2 = this.makeGlobalPreJoinableClause("dataSource_1", "x == \"j.x\"", "j.");
        EasyMock.reset((Object[])new Object[]{analysis});
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause2)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey2 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey2.isPresent());
        Assert.assertFalse((boolean)Arrays.equals((byte[])cacheKey1.get(), (byte[])cacheKey2.get()));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithJoinType() {
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        PreJoinableClause clause1 = this.makeGlobalPreJoinableClause("dataSource_1", "x == \"j.x\"", "j.", JoinType.LEFT);
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey1 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey1.isPresent());
        Assert.assertNotEquals((long)0L, (long)((byte[])cacheKey1.get()).length);
        PreJoinableClause clause2 = this.makeGlobalPreJoinableClause("dataSource_1", "x == \"j.x\"", "j.", JoinType.INNER);
        EasyMock.reset((Object[])new Object[]{analysis});
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause2)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey2 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey2.isPresent());
        Assert.assertFalse((boolean)Arrays.equals((byte[])cacheKey1.get(), (byte[])cacheKey2.get()));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithPrefix() {
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        PreJoinableClause clause1 = this.makeGlobalPreJoinableClause("dataSource_1", "abc == xyz", "ab");
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey1 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey1.isPresent());
        Assert.assertNotEquals((long)0L, (long)((byte[])cacheKey1.get()).length);
        PreJoinableClause clause2 = this.makeGlobalPreJoinableClause("dataSource_1", "abc == xyz", "xy");
        EasyMock.reset((Object[])new Object[]{analysis});
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause2)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey2 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey2.isPresent());
        Assert.assertFalse((boolean)Arrays.equals((byte[])cacheKey1.get(), (byte[])cacheKey2.get()));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithBaseFilter() {
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.of(TrueDimFilter.instance())).anyTimes();
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        PreJoinableClause clause1 = this.makeGlobalPreJoinableClause("dataSource_1", "abc == xyz", "ab");
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey1 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey1.isPresent());
        Assert.assertNotEquals((long)0L, (long)((byte[])cacheKey1.get()).length);
        PreJoinableClause clause2 = this.makeGlobalPreJoinableClause("dataSource_1", "abc == xyz", "ab");
        EasyMock.reset((Object[])new Object[]{analysis});
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause2)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.of(FalseDimFilter.instance())).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey2 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey2.isPresent());
        Assert.assertFalse((boolean)Arrays.equals((byte[])cacheKey1.get(), (byte[])cacheKey2.get()));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithJoinable() {
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        PreJoinableClause clause1 = this.makeGlobalPreJoinableClause("dataSource_1", "x == \"j.x\"", "j.");
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey1 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey1.isPresent());
        Assert.assertNotEquals((long)0L, (long)((byte[])cacheKey1.get()).length);
        PreJoinableClause clause2 = this.makeGlobalPreJoinableClause("dataSource_2", "x == \"j.x\"", "j.");
        EasyMock.reset((Object[])new Object[]{analysis});
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause2)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey2 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey2.isPresent());
        Assert.assertFalse((boolean)Arrays.equals((byte[])cacheKey1.get(), (byte[])cacheKey2.get()));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_sameKeyForSameJoin() {
        DataSourceAnalysis analysis = (DataSourceAnalysis)EasyMock.mock(DataSourceAnalysis.class);
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        PreJoinableClause clause1 = this.makeGlobalPreJoinableClause("dataSource_1", "x == \"j.x\"", "j.");
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause1)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey1 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey1.isPresent());
        Assert.assertNotEquals((long)0L, (long)((byte[])cacheKey1.get()).length);
        PreJoinableClause clause2 = this.makeGlobalPreJoinableClause("dataSource_1", "x == \"j.x\"", "j.");
        EasyMock.reset((Object[])new Object[]{analysis});
        EasyMock.expect((Object)analysis.getPreJoinableClauses()).andReturn(Collections.singletonList(clause2)).anyTimes();
        EasyMock.expect((Object)analysis.getJoinBaseTableFilter()).andReturn(Optional.empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{analysis});
        Optional cacheKey2 = joinableFactoryWrapper.computeJoinDataSourceCacheKey(analysis);
        Assert.assertTrue((boolean)cacheKey2.isPresent());
        Assert.assertArrayEquals((byte[])((byte[])cacheKey1.get()), (byte[])((byte[])cacheKey2.get()));
    }

    @Test
    public void test_checkClausePrefixesForDuplicatesAndShadowing_noConflicts() {
        List<String> prefixes = Arrays.asList("AA", "AB", "AC", "aa", "ab", "ac", "BA");
        JoinPrefixUtils.checkPrefixesForDuplicatesAndShadowing(prefixes);
    }

    @Test
    public void test_checkClausePrefixesForDuplicatesAndShadowing_duplicate() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Detected duplicate prefix in join clauses: [AA]");
        List<String> prefixes = Arrays.asList("AA", "AA", "ABCD");
        JoinPrefixUtils.checkPrefixesForDuplicatesAndShadowing(prefixes);
    }

    @Test
    public void test_checkClausePrefixesForDuplicatesAndShadowing_shadowing() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Detected conflicting prefixes in join clauses: [ABC.DEF, ABC.]");
        List<String> prefixes = Arrays.asList("BASE.", "BASEBALL", "123.456", "23.45", "ABC.", "ABC.DEF");
        JoinPrefixUtils.checkPrefixesForDuplicatesAndShadowing(prefixes);
    }

    @Test
    public void test_convertJoinsToFilters_convertInnerJoin() {
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()))), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)ImmutableList.of()), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToPartialFilters_convertInnerJoin() {
        JoinableClause joinableClause = new JoinableClause("j.", (Joinable)new IndexedTableJoinable(TEST_INDEXED_TABLE), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.country\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)joinableClause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", INDEXED_TABLE_DS.getRowsAsList().stream().map(row -> row[0].toString()).collect(Collectors.toSet()))), (Object)ImmutableList.of((Object)joinableClause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_convertTwoInnerJoins() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("_j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"_j.k\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("__j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == \"__j.k\"", (String)"__j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS), (Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)ImmutableList.of((Object)clauses.get(2))), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToPartialAndFullFilters_convertMultipleInnerJoins() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("_j.", (Joinable)new IndexedTableJoinable(TEST_INDEXED_TABLE), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"_j.country\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("__j.", (Joinable)new IndexedTableJoinable(TEST_INDEXED_TABLE), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == \"__j.country\"", (String)"__j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS), (Object)new InDimFilter("x", INDEXED_TABLE_DS.getRowsAsList().stream().map(row -> row[0].toString()).collect(Collectors.toSet()))), (Object)ImmutableList.of((Object)clauses.get(1), (Object)clauses.get(2))), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertTooManyValues() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)2);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertLeftJoin() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_partialConvertWhenColumnIsUsed() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x", (Object)"j.k"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_convertToFalseFilterWhenOnlyNullValues() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)new IndexedTableJoinable(TEST_NULL_INDEXED_TABLE), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.nullCol\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)FalseFilter.instance()), (Object)ImmutableList.of()), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertLhsFunctions() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"concat(x,'') == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertRhsFunctions() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == concat(\"j.k\",'')", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertNonEquiJoin() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x != \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertJoinsDependedOnByLaterJoins() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("_j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"\"j.k\" == \"_j.k\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)clauses), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_partialConvertJoinsDependedOnByLaterJoins() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("_j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"\"j.k\" == \"_j.k\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("__j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == \"__j.k\"", (String)"__j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)clauses), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_partialConvertJoinsDependedOnByLaterJoins2() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("_j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"_j.k\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("__j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"\"_j.v\" == \"__j.k\"", (String)"__j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS), (Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)clauses.subList(1, clauses.size())), (Object)conversion);
    }

    private PreJoinableClause makeGlobalPreJoinableClause(String tableName, String expression, String prefix) {
        return this.makeGlobalPreJoinableClause(tableName, expression, prefix, JoinType.LEFT);
    }

    private PreJoinableClause makeGlobalPreJoinableClause(String tableName, String expression, String prefix, JoinType joinType) {
        GlobalTableDataSource dataSource = new GlobalTableDataSource(tableName);
        return this.makePreJoinableClause((DataSource)dataSource, expression, prefix, joinType);
    }

    private PreJoinableClause makePreJoinableClause(DataSource dataSource, String expression, String prefix, JoinType joinType) {
        JoinConditionAnalysis conditionAnalysis = JoinConditionAnalysis.forExpression((String)expression, (String)prefix, (ExprMacroTable)ExprMacroTable.nil());
        return new PreJoinableClause(prefix, dataSource, joinType, conditionAnalysis);
    }

    private static class JoinableFactoryWithCacheKey
    extends NoopJoinableFactory {
        private JoinableFactoryWithCacheKey() {
        }

        public Optional<byte[]> computeJoinCacheKey(DataSource dataSource, JoinConditionAnalysis condition) {
            if (dataSource.isCacheable(false) && condition.canHashJoin()) {
                String tableName = (String)Iterators.getOnlyElement(dataSource.getTableNames().iterator());
                return Optional.of(StringUtils.toUtf8((String)tableName));
            }
            return Optional.empty();
        }
    }
}

