/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseProgressIndicator;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NestedDataColumnIndexer;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.GlobalDictionarySortedCollector;
import org.apache.druid.segment.nested.NestedDataColumnSerializer;
import org.apache.druid.segment.nested.NestedDataColumnSupplier;
import org.apache.druid.segment.nested.NestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NestedDataColumnSupplierTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory((BitmapFactory)new RoaringBitmapFactory());
    List<Map<String, Object>> data = ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)1.0, (Object)"z", (Object)"a"), (Object)ImmutableMap.of((Object)"y", (Object)3.0, (Object)"z", (Object)"d"), (Object)ImmutableMap.of((Object)"x", (Object)5L, (Object)"y", (Object)5.0, (Object)"z", (Object)"b"), (Object)ImmutableMap.of((Object)"x", (Object)3L, (Object)"y", (Object)4.0, (Object)"z", (Object)"c"), (Object)ImmutableMap.of((Object)"x", (Object)2L), (Object)ImmutableMap.of((Object)"x", (Object)4L, (Object)"y", (Object)2.0, (Object)"z", (Object)"e"));
    Closer closer = Closer.create();
    SmooshedFileMapper fileMapper;
    ByteBuffer baseBuffer;

    @Before
    public void setup() throws IOException {
        String fileNameBase = "test";
        TmpFileSegmentWriteOutMediumFactory writeOutMediumFactory = TmpFileSegmentWriteOutMediumFactory.instance();
        File tmpFile = this.tempFolder.newFolder();
        try (FileSmoosher smoosher = new FileSmoosher(tmpFile);){
            NestedDataColumnSerializer serializer = new NestedDataColumnSerializer("test", new IndexSpec(), writeOutMediumFactory.makeSegmentWriteOutMedium(this.tempFolder.newFolder()), (ProgressIndicator)new BaseProgressIndicator(), this.closer);
            NestedDataColumnIndexer indexer = new NestedDataColumnIndexer();
            for (Map<String, Object> o : this.data) {
                indexer.processRowValsToUnsortedEncodedKeyComponent(o, false);
            }
            TreeMap sortedFields = new TreeMap();
            indexer.mergeFields(sortedFields);
            GlobalDictionarySortedCollector globalDictionarySortedCollector = indexer.getSortedCollector();
            serializer.open();
            serializer.serializeFields(sortedFields);
            serializer.serializeStringDictionary((Iterable)globalDictionarySortedCollector.getSortedStrings());
            serializer.serializeLongDictionary((Iterable)globalDictionarySortedCollector.getSortedLongs());
            serializer.serializeDoubleDictionary((Iterable)globalDictionarySortedCollector.getSortedDoubles());
            SettableSelector valueSelector = new SettableSelector();
            for (Map<String, Object> o : this.data) {
                valueSelector.setObject(StructuredData.wrap(o));
                serializer.serialize((ColumnValueSelector)valueSelector);
            }
            try (SmooshedWriter writer = smoosher.addWithSmooshedWriter("test", serializer.getSerializedSize());){
                serializer.writeTo((WritableByteChannel)writer, smoosher);
            }
            smoosher.close();
            this.fileMapper = (SmooshedFileMapper)this.closer.register((Closeable)SmooshedFileMapper.load((File)tmpFile));
            this.baseBuffer = this.fileMapper.mapFile("test");
        }
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testBasicFunctionality() throws IOException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        NestedDataColumnSupplier supplier = new NestedDataColumnSupplier(this.baseBuffer, bob, () -> 0, NestedDataComplexTypeSerde.OBJECT_MAPPER);
        try (NestedDataComplexColumn column = (NestedDataComplexColumn)supplier.get();){
            this.smokeTest(column);
        }
    }

    @Test
    public void testConcurrency() throws ExecutionException, InterruptedException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        NestedDataColumnSupplier supplier = new NestedDataColumnSupplier(this.baseBuffer, bob, () -> 0, NestedDataComplexTypeSerde.OBJECT_MAPPER);
        String expectedReason = "none";
        AtomicReference<String> failureReason = new AtomicReference<String>("none");
        int threads = 10;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(10);
        CountDownLatch threadsStartLatch = new CountDownLatch(1);
        for (int i = 0; i < 10; ++i) {
            futures.add(executorService.submit(() -> {
                try {
                    threadsStartLatch.await();
                    for (int iter = 0; iter < 5000; ++iter) {
                        try (NestedDataComplexColumn column = (NestedDataComplexColumn)supplier.get();){
                            this.smokeTest(column);
                            continue;
                        }
                    }
                }
                catch (Throwable ex) {
                    failureReason.set(ex.getMessage());
                }
            }));
        }
        threadsStartLatch.countDown();
        Futures.allAsList(futures).get();
        Assert.assertEquals((Object)"none", (Object)failureReason.get());
    }

    private void smokeTest(NestedDataComplexColumn column) throws IOException {
        SimpleAscendingOffset offset = new SimpleAscendingOffset(this.data.size());
        ColumnValueSelector rawSelector = column.makeColumnValueSelector((ReadableOffset)offset);
        List xPath = NestedPathFinder.parseJsonPath((String)"$.x");
        ColumnValueSelector xSelector = column.makeColumnValueSelector(xPath, (ReadableOffset)offset);
        ColumnIndexSupplier xIndexSupplier = column.getColumnIndexSupplier(xPath);
        Assert.assertNotNull((Object)xIndexSupplier);
        StringValueSetIndex xValueIndex = (StringValueSetIndex)xIndexSupplier.as(StringValueSetIndex.class);
        NullValueIndex xNulls = (NullValueIndex)xIndexSupplier.as(NullValueIndex.class);
        List yPath = NestedPathFinder.parseJsonPath((String)"$.y");
        ColumnValueSelector ySelector = column.makeColumnValueSelector(yPath, (ReadableOffset)offset);
        ColumnIndexSupplier yIndexSupplier = column.getColumnIndexSupplier(yPath);
        Assert.assertNotNull((Object)yIndexSupplier);
        StringValueSetIndex yValueIndex = (StringValueSetIndex)yIndexSupplier.as(StringValueSetIndex.class);
        NullValueIndex yNulls = (NullValueIndex)yIndexSupplier.as(NullValueIndex.class);
        List zPath = NestedPathFinder.parseJsonPath((String)"$.z");
        ColumnValueSelector zSelector = column.makeColumnValueSelector(zPath, (ReadableOffset)offset);
        ColumnIndexSupplier zIndexSupplier = column.getColumnIndexSupplier(zPath);
        Assert.assertNotNull((Object)zIndexSupplier);
        StringValueSetIndex zValueIndex = (StringValueSetIndex)zIndexSupplier.as(StringValueSetIndex.class);
        NullValueIndex zNulls = (NullValueIndex)zIndexSupplier.as(NullValueIndex.class);
        for (int i = 0; i < this.data.size(); ++i) {
            Map<String, Object> row = this.data.get(i);
            Assert.assertEquals((Object)JSON_MAPPER.writeValueAsString(row), (Object)JSON_MAPPER.writeValueAsString(StructuredData.unwrap((Object)rawSelector.getObject())));
            if (row.containsKey("x")) {
                Assert.assertEquals((Object)row.get("x"), (Object)xSelector.getObject());
                Assert.assertEquals((Object)row.get("x"), (Object)xSelector.getLong());
                Assert.assertTrue((boolean)((ImmutableBitmap)xValueIndex.forValue(String.valueOf(row.get("x"))).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)xNulls.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
            } else {
                Assert.assertNull((Object)xSelector.getObject());
                Assert.assertTrue((boolean)xSelector.isNull());
                Assert.assertTrue((boolean)((ImmutableBitmap)xValueIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)xNulls.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
            }
            if (row.containsKey("y")) {
                Assert.assertEquals((Object)row.get("y"), (Object)ySelector.getObject());
                Assert.assertEquals((Object)row.get("y"), (Object)ySelector.getDouble());
                Assert.assertTrue((boolean)((ImmutableBitmap)yValueIndex.forValue(String.valueOf(row.get("y"))).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)yNulls.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
            } else {
                Assert.assertNull((Object)ySelector.getObject());
                Assert.assertTrue((boolean)ySelector.isNull());
                Assert.assertTrue((boolean)((ImmutableBitmap)yValueIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)yNulls.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
            }
            if (row.containsKey("z")) {
                Assert.assertEquals((Object)row.get("z"), (Object)zSelector.getObject());
                Assert.assertTrue((boolean)((ImmutableBitmap)zValueIndex.forValue((String)row.get("z")).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)zNulls.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
            } else {
                Assert.assertNull((Object)zSelector.getObject());
                Assert.assertTrue((boolean)((ImmutableBitmap)zValueIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)zNulls.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
            }
            offset.increment();
        }
    }

    private static class OnlyPositionalReadsTypeStrategy<T>
    implements TypeStrategy<T> {
        private final TypeStrategy<T> delegate;

        private OnlyPositionalReadsTypeStrategy(TypeStrategy<T> delegate) {
            this.delegate = delegate;
        }

        public int estimateSizeBytes(T value) {
            return this.delegate.estimateSizeBytes(value);
        }

        public T read(ByteBuffer buffer) {
            throw new IllegalStateException("non-positional read");
        }

        public boolean readRetainsBufferReference() {
            return this.delegate.readRetainsBufferReference();
        }

        public int write(ByteBuffer buffer, T value, int maxSizeBytes) {
            return this.delegate.write(buffer, value, maxSizeBytes);
        }

        public T read(ByteBuffer buffer, int offset) {
            return (T)this.delegate.read(buffer, offset);
        }

        public int write(ByteBuffer buffer, int offset, T value, int maxSizeBytes) {
            return this.delegate.write(buffer, offset, value, maxSizeBytes);
        }

        public int compare(T o1, T o2) {
            return this.delegate.compare(o1, o2);
        }
    }

    private static class SettableSelector
    extends ObjectColumnSelector<StructuredData> {
        private StructuredData data;

        private SettableSelector() {
        }

        public void setObject(StructuredData o) {
            this.data = o;
        }

        @Nullable
        public StructuredData getObject() {
            return this.data;
        }

        public Class classOfObject() {
            return StructuredData.class;
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

