/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestObjectColumnSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CloseableUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExpressionSelectorsTest
extends InitializedNullHandlingTest {
    private static Closer CLOSER;
    private static QueryableIndex QUERYABLE_INDEX;
    private static QueryableIndexStorageAdapter QUERYABLE_INDEX_STORAGE_ADAPTER;
    private static IncrementalIndex INCREMENTAL_INDEX;
    private static IncrementalIndexStorageAdapter INCREMENTAL_INDEX_STORAGE_ADAPTER;
    private static List<StorageAdapter> ADAPTERS;
    private static final ColumnCapabilities SINGLE_VALUE;
    private static final ColumnCapabilities MULTI_VAL;

    @BeforeClass
    public static void setup() {
        CLOSER = Closer.create();
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("expression-testbench");
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        SegmentGenerator segmentGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        int numRows = 10000;
        INCREMENTAL_INDEX = (IncrementalIndex)CLOSER.register((Closeable)segmentGenerator.generateIncrementalIndex(dataSegment, schemaInfo, Granularities.HOUR, 10000));
        INCREMENTAL_INDEX_STORAGE_ADAPTER = new IncrementalIndexStorageAdapter(INCREMENTAL_INDEX);
        QUERYABLE_INDEX = (QueryableIndex)CLOSER.register((Closeable)segmentGenerator.generate(dataSegment, schemaInfo, Granularities.HOUR, 10000));
        QUERYABLE_INDEX_STORAGE_ADAPTER = new QueryableIndexStorageAdapter(QUERYABLE_INDEX);
        ADAPTERS = ImmutableList.of((Object)INCREMENTAL_INDEX_STORAGE_ADAPTER, (Object)QUERYABLE_INDEX_STORAGE_ADAPTER);
    }

    @AfterClass
    public static void teardown() {
        CloseableUtils.closeAndSuppressExceptions((Closeable)CLOSER, throwable -> {});
    }

    @Test
    public void test_single_value_string_bindings() {
        String columnName = "string3";
        for (StorageAdapter adapter : ADAPTERS) {
            Sequence cursorSequence = adapter.makeCursors(null, adapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
            cursorSequence.accumulate(null, (accumulated, cursor) -> {
                boolean isMultiVal;
                ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
                ExpressionPlan plan = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"string3\"", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan2 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"concat(\"string3\", 'foo')", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                Expr.ObjectBinding bindings = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan);
                Expr.ObjectBinding bindings2 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan2);
                DimensionSelector dimSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"string3"));
                ColumnValueSelector valueSelector = factory.makeColumnValueSelector("string3");
                boolean bl = isMultiVal = factory.getColumnCapabilities("string3") == null || factory.getColumnCapabilities("string3").hasMultipleValues().isMaybeTrue();
                while (!cursor.isDone()) {
                    Object dimSelectorVal = dimSelector.getObject();
                    Object valueSelectorVal = valueSelector.getObject();
                    Object bindingVal = bindings.get("string3");
                    Object bindingVal2 = bindings2.get("string3");
                    if (dimSelectorVal == null) {
                        Assert.assertNull((Object)dimSelectorVal);
                        Assert.assertNull((Object)valueSelectorVal);
                        Assert.assertNull((Object)bindingVal);
                        if (isMultiVal) {
                            Assert.assertNull((Object)((Object[])bindingVal2)[0]);
                        } else {
                            Assert.assertNull((Object)bindingVal2);
                        }
                    } else if (isMultiVal) {
                        Assert.assertEquals((Object)dimSelectorVal, (Object)((Object[])bindingVal)[0]);
                        Assert.assertEquals((Object)valueSelectorVal, (Object)((Object[])bindingVal)[0]);
                        Assert.assertEquals((Object)dimSelectorVal, (Object)((Object[])bindingVal2)[0]);
                        Assert.assertEquals((Object)valueSelectorVal, (Object)((Object[])bindingVal2)[0]);
                    } else {
                        Assert.assertEquals((Object)dimSelectorVal, (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelectorVal, (Object)bindingVal);
                        Assert.assertEquals((Object)dimSelectorVal, (Object)bindingVal2);
                        Assert.assertEquals((Object)valueSelectorVal, (Object)bindingVal2);
                    }
                    cursor.advance();
                }
                return null;
            });
        }
    }

    @Test
    public void test_multi_value_string_bindings() {
        String columnName = "multi-string3";
        for (StorageAdapter adapter : ADAPTERS) {
            Sequence cursorSequence = adapter.makeCursors(null, adapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
            cursorSequence.accumulate(null, (ignored, cursor) -> {
                ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
                ExpressionPlan plan = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"multi-string3\"", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan2 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"array_append(\"multi-string3\", 'foo')", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan3 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"array_length(\"multi-string3\")", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan4 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"concat(\"multi-string3\", 'foo')", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                Expr.ObjectBinding bindings = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan);
                Expr.ObjectBinding bindings2 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan2);
                Expr.ObjectBinding bindings3 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan3);
                Expr.ObjectBinding bindings4 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan4);
                DimensionSelector dimSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"multi-string3"));
                ColumnValueSelector valueSelector = factory.makeColumnValueSelector("multi-string3");
                while (!cursor.isDone()) {
                    Object dimSelectorVal = dimSelector.getObject();
                    Object valueSelectorVal = valueSelector.getObject();
                    Object bindingVal = bindings.get("multi-string3");
                    Object bindingVal2 = bindings2.get("multi-string3");
                    Object bindingVal3 = bindings3.get("multi-string3");
                    Object bindingVal4 = bindings4.get("multi-string3");
                    if (dimSelectorVal == null) {
                        Assert.assertNull((Object)dimSelectorVal);
                        Assert.assertNull((Object)valueSelectorVal);
                        Assert.assertNull((Object)bindingVal);
                        Assert.assertNull((Object)bindingVal2);
                        Assert.assertNull((Object)bindingVal3);
                        Assert.assertArrayEquals((Object[])new Object[]{null}, (Object[])((Object[])bindingVal4));
                    } else {
                        Assert.assertArrayEquals((Object[])((List)dimSelectorVal).toArray(), (Object[])((Object[])bindingVal));
                        Assert.assertArrayEquals((Object[])((List)valueSelectorVal).toArray(), (Object[])((Object[])bindingVal));
                        Assert.assertArrayEquals((Object[])((List)dimSelectorVal).toArray(), (Object[])((Object[])bindingVal2));
                        Assert.assertArrayEquals((Object[])((List)valueSelectorVal).toArray(), (Object[])((Object[])bindingVal2));
                        Assert.assertArrayEquals((Object[])((List)dimSelectorVal).toArray(), (Object[])((Object[])bindingVal3));
                        Assert.assertArrayEquals((Object[])((List)valueSelectorVal).toArray(), (Object[])((Object[])bindingVal3));
                    }
                    cursor.advance();
                }
                return ignored;
            });
        }
    }

    @Test
    public void test_long_bindings() {
        String columnName = "long3";
        for (StorageAdapter adapter : ADAPTERS) {
            Sequence cursorSequence = adapter.makeCursors(null, adapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
            cursorSequence.accumulate(null, (accumulated, cursor) -> {
                ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
                ExpressionPlan plan = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"long3\"", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan2 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"long3\" + 3", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                Expr.ObjectBinding bindings = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan);
                Expr.ObjectBinding bindings2 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan2);
                ColumnValueSelector valueSelector = factory.makeColumnValueSelector("long3");
                while (!cursor.isDone()) {
                    Object bindingVal = bindings.get("long3");
                    Object bindingVal2 = bindings2.get("long3");
                    if (valueSelector.isNull()) {
                        Assert.assertNull((Object)valueSelector.getObject());
                        Assert.assertNull((Object)bindingVal);
                        Assert.assertNull((Object)bindingVal2);
                    } else {
                        Assert.assertEquals((Object)valueSelector.getObject(), (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelector.getLong(), (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelector.getObject(), (Object)bindingVal2);
                        Assert.assertEquals((Object)valueSelector.getLong(), (Object)bindingVal2);
                    }
                    cursor.advance();
                }
                return null;
            });
        }
    }

    @Test
    public void test_double_bindings() {
        String columnName = "double3";
        for (StorageAdapter adapter : ADAPTERS) {
            Sequence cursorSequence = adapter.makeCursors(null, adapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
            cursorSequence.accumulate(null, (accumulated, cursor) -> {
                ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
                ExpressionPlan plan = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"double3\"", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan2 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"double3\" + 3.0", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                Expr.ObjectBinding bindings = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan);
                Expr.ObjectBinding bindings2 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan2);
                ColumnValueSelector valueSelector = factory.makeColumnValueSelector("double3");
                while (!cursor.isDone()) {
                    Object bindingVal = bindings.get("double3");
                    Object bindingVal2 = bindings2.get("double3");
                    if (valueSelector.isNull()) {
                        Assert.assertNull((Object)valueSelector.getObject());
                        Assert.assertNull((Object)bindingVal);
                        Assert.assertNull((Object)bindingVal2);
                    } else {
                        Assert.assertEquals((Object)valueSelector.getObject(), (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelector.getDouble(), (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelector.getObject(), (Object)bindingVal2);
                        Assert.assertEquals((Object)valueSelector.getDouble(), (Object)bindingVal2);
                    }
                    cursor.advance();
                }
                return null;
            });
        }
    }

    @Test
    public void test_canMapOverDictionary_oneSingleValueInput() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)SINGLE_VALUE));
    }

    @Test
    public void test_canMapOverDictionary_oneSingleValueInputSpecifiedTwice() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"concat(dim1, dim1) == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)SINGLE_VALUE));
    }

    @Test
    public void test_canMapOverDictionary_oneMultiValueInput() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)MULTI_VAL));
    }

    @Test
    public void test_canMapOverDictionary_oneUnknownInput() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)new ColumnCapabilitiesImpl()));
    }

    @Test
    public void test_canMapOverDictionary_oneSingleValueInputInArrayContext() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"array_contains(dim1, 2)", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault().setType(ColumnType.STRING_ARRAY)));
    }

    @Test
    public void test_canMapOverDictionary_oneMultiValueInputInArrayContext() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"array_contains(dim1, 2)", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)MULTI_VAL));
    }

    @Test
    public void test_canMapOverDictionary_oneUnknownInputInArrayContext() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"array_contains(dim1, 2)", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)new ColumnCapabilitiesImpl()));
    }

    @Test
    public void test_canMapOverDictionary() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)SINGLE_VALUE));
    }

    @Test
    public void test_supplierFromDimensionSelector() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromDimensionSelector((DimensionSelector)ExpressionSelectorsTest.dimensionSelectorFromSupplier((Supplier<String>)settableSupplier), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set(null);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onObject() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, Object.class), (boolean)true);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
        settableSupplier.set((Object)"1.234");
        Assert.assertEquals((Object)"1.234", (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onNumber() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, Number.class), (boolean)true);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onString() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, String.class), (boolean)true);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1.1");
        Assert.assertEquals((Object)"1.1", (Object)supplier.get());
        settableSupplier.set((Object)"1");
        Assert.assertEquals((Object)"1", (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onList() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, List.class), (boolean)true);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((Object[])supplier.get()));
    }

    @Test
    public void test_coerceEvalToSelectorObject() {
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofLongArray((Object[])new Long[]{1L, 2L, 3L})));
        Assert.assertEquals((Object)ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofDoubleArray((Object[])new Double[]{1.0, 2.0, 3.0})));
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofStringArray((Object[])new String[]{"a", "b", "c"})));
        ArrayList<String> withNulls = new ArrayList<String>();
        withNulls.add("a");
        withNulls.add(null);
        withNulls.add("c");
        Assert.assertEquals(withNulls, (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofStringArray((Object[])new String[]{"a", null, "c"})));
        Assert.assertNull((Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofLongArray(null)));
        Assert.assertEquals((Object)1L, (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofLongArray((Object[])new Long[]{1L})));
        Assert.assertNull((Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofLongArray((Object[])new Long[]{null})));
    }

    @Test
    public void test_incrementalIndexStringSelector() throws IndexSizeExceededException {
        IncrementalIndexSchema schema = new IncrementalIndexSchema(0L, new TimestampSpec("time", "millis", DateTimes.nowUtc()), Granularities.NONE, VirtualColumns.EMPTY, DimensionsSpec.EMPTY, new AggregatorFactory[]{new CountAggregatorFactory("count")}, true);
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setMaxRowCount(100).setIndexSchema(schema).build();
        index.add((InputRow)new MapBasedInputRow(DateTimes.nowUtc().getMillis(), (List)ImmutableList.of((Object)"x"), (Map)ImmutableMap.of((Object)"x", (Object)"foo")));
        index.add((InputRow)new MapBasedInputRow(DateTimes.nowUtc().plusMillis(1000).getMillis(), (List)ImmutableList.of((Object)"y"), (Map)ImmutableMap.of((Object)"y", (Object)"foo")));
        IncrementalIndexStorageAdapter adapter = new IncrementalIndexStorageAdapter(index);
        Sequence cursors = adapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null);
        int rowsProcessed = (Integer)cursors.map(cursor -> {
            DimensionSelector xExprSelector = ExpressionSelectors.makeDimensionSelector((ColumnSelectorFactory)cursor.getColumnSelectorFactory(), (Expr)Parser.parse((String)"concat(x, 'foo')", (ExprMacroTable)ExprMacroTable.nil()), null);
            DimensionSelector yExprSelector = ExpressionSelectors.makeDimensionSelector((ColumnSelectorFactory)cursor.getColumnSelectorFactory(), (Expr)Parser.parse((String)"concat(y, 'foo')", (ExprMacroTable)ExprMacroTable.nil()), null);
            int rowCount = 0;
            while (!cursor.isDone()) {
                List<String> expectedNull;
                Object x = xExprSelector.getObject();
                Object y = yExprSelector.getObject();
                List<String> expectedFoo = Collections.singletonList("foofoo");
                List<String> list = expectedNull = NullHandling.replaceWithDefault() ? Collections.singletonList("foo") : Collections.singletonList(null);
                if (rowCount == 0) {
                    Assert.assertEquals(expectedFoo, (Object)x);
                    Assert.assertEquals(expectedNull, (Object)y);
                } else {
                    Assert.assertEquals(expectedNull, (Object)x);
                    Assert.assertEquals(expectedFoo, (Object)y);
                }
                ++rowCount;
                cursor.advance();
            }
            return rowCount;
        }).accumulate((Object)0, (in, acc) -> in + acc);
        Assert.assertEquals((long)2L, (long)rowsProcessed);
    }

    private static DimensionSelector dimensionSelectorFromSupplier(final Supplier<String> supplier) {
        return new BaseSingleValueDimensionSelector(){

            protected String getValue() {
                return (String)supplier.get();
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("supplier", (Object)supplier);
            }
        };
    }

    private static <T> ColumnValueSelector<T> objectSelectorFromSupplier(final Supplier<T> supplier, final Class<T> clazz) {
        return new TestObjectColumnSelector<T>(){

            public Class<T> classOfObject() {
                return clazz;
            }

            public T getObject() {
                return supplier.get();
            }
        };
    }

    static {
        SINGLE_VALUE = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasMultipleValues(false).setHasNulls(true);
        MULTI_VAL = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasMultipleValues(true).setHasNulls(true);
    }
}

