/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import org.apache.druid.frame.read.columnar.ComplexFrameColumnReader;
import org.apache.druid.frame.read.columnar.DoubleFrameColumnReader;
import org.apache.druid.frame.read.columnar.FloatFrameColumnReader;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.read.columnar.LongFrameColumnReader;
import org.apache.druid.frame.read.columnar.StringFrameColumnReader;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;

public class FrameColumnReaders {
    private FrameColumnReaders() {
    }

    public static FrameColumnReader create(int columnNumber, ColumnType columnType) {
        switch ((ValueType)columnType.getType()) {
            case LONG: {
                return new LongFrameColumnReader(columnNumber);
            }
            case FLOAT: {
                return new FloatFrameColumnReader(columnNumber);
            }
            case DOUBLE: {
                return new DoubleFrameColumnReader(columnNumber);
            }
            case STRING: {
                return new StringFrameColumnReader(columnNumber, false);
            }
            case COMPLEX: {
                return new ComplexFrameColumnReader(columnNumber);
            }
            case ARRAY: {
                if (columnType.getElementType().getType() != ValueType.STRING) break;
                return new StringFrameColumnReader(columnNumber, true);
            }
        }
        throw new UOE("Unsupported column type [%s]", new Object[]{columnType});
    }
}

