/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class TimestampExtractExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_extract";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(final List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 2, 3);
        if (!args.get(1).isLiteral() || args.get(1).getLiteralValue() == null) {
            throw this.validationFailed("unit arg must be literal", new Object[0]);
        }
        if (args.size() > 2) {
            this.validationHelperCheckArgIsLiteral(args.get(2), "timezone");
        }
        Expr arg = args.get(0);
        final Unit unit = Unit.valueOf(StringUtils.toUpperCase((String)((String)args.get(1).getLiteralValue())));
        DateTimeZone timeZone = args.size() > 2 ? ExprUtils.toTimeZone(args.get(2)) : DateTimeZone.UTC;
        final ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)timeZone);
        class TimestampExtractExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            TimestampExtractExpr(Expr arg) {
                super(TimestampExtractExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                Object val = this.arg.eval(bindings).value();
                if (val == null) {
                    return ExprEval.of(null);
                }
                DateTime dateTime = new DateTime(val, (Chronology)chronology);
                long epoch = dateTime.getMillis() / 1000L;
                switch (unit) {
                    case EPOCH: {
                        return ExprEval.of((long)epoch);
                    }
                    case MICROSECOND: {
                        return ExprEval.of((long)(epoch / 1000L));
                    }
                    case MILLISECOND: {
                        return ExprEval.of((long)dateTime.millisOfSecond().get());
                    }
                    case SECOND: {
                        return ExprEval.of((long)dateTime.secondOfMinute().get());
                    }
                    case MINUTE: {
                        return ExprEval.of((long)dateTime.minuteOfHour().get());
                    }
                    case HOUR: {
                        return ExprEval.of((long)dateTime.hourOfDay().get());
                    }
                    case DAY: {
                        return ExprEval.of((long)dateTime.dayOfMonth().get());
                    }
                    case DOW: {
                        return ExprEval.of((long)dateTime.dayOfWeek().get());
                    }
                    case ISODOW: {
                        return ExprEval.of((long)dateTime.dayOfWeek().get());
                    }
                    case DOY: {
                        return ExprEval.of((long)dateTime.dayOfYear().get());
                    }
                    case WEEK: {
                        return ExprEval.of((long)dateTime.weekOfWeekyear().get());
                    }
                    case MONTH: {
                        return ExprEval.of((long)dateTime.monthOfYear().get());
                    }
                    case QUARTER: {
                        return ExprEval.of((long)((dateTime.monthOfYear().get() - 1) / 3 + 1));
                    }
                    case YEAR: {
                        return ExprEval.of((long)dateTime.year().get());
                    }
                    case ISOYEAR: {
                        return ExprEval.of((long)dateTime.year().get());
                    }
                    case DECADE: {
                        return ExprEval.of((long)(dateTime.year().get() / 10));
                    }
                    case CENTURY: {
                        return ExprEval.of((double)Math.ceil((double)dateTime.year().get() / 100.0));
                    }
                    case MILLENNIUM: {
                        return ExprEval.of((double)Math.ceil((double)dateTime.year().get() / 1000.0));
                    }
                }
                throw TimestampExtractExprMacro.this.validationFailed("unhandled unit[%s]", new Object[]{unit});
            }

            public Expr visit(Expr.Shuttle shuttle) {
                return shuttle.visit(TimestampExtractExprMacro.this.apply(shuttle.visitAll(args)));
            }

            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                switch (unit) {
                    case CENTURY: 
                    case MILLENNIUM: {
                        return ExpressionType.DOUBLE;
                    }
                }
                return ExpressionType.LONG;
            }

            public String stringify() {
                if (args.size() > 2) {
                    return StringUtils.format((String)"%s(%s, %s, %s)", (Object[])new Object[]{TimestampExtractExprMacro.FN_NAME, this.arg.stringify(), ((Expr)args.get(1)).stringify(), ((Expr)args.get(2)).stringify()});
                }
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{TimestampExtractExprMacro.FN_NAME, this.arg.stringify(), ((Expr)args.get(1)).stringify()});
            }
        }
        return new TimestampExtractExpr(arg);
    }

    public static enum Unit {
        EPOCH,
        MICROSECOND,
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        DOW,
        ISODOW,
        DOY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR,
        ISOYEAR,
        DECADE,
        CENTURY,
        MILLENNIUM;

    }
}

